/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.TreeMap;
import junit.framework.TestCase;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.utils.IOUtils;
import org.junit.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZipFileTest
extends TestCase {
    private ZipFile zf = null;

    public void tearDown() {
        ZipFile.closeQuietly((ZipFile)this.zf);
    }

    public void testCDOrder() throws Exception {
        this.readOrderTest();
        ArrayList<ZipArchiveEntry> l = Collections.list(this.zf.getEntries());
        ZipFileTest.assertEntryName(l, 0, "AbstractUnicodeExtraField");
        ZipFileTest.assertEntryName(l, 1, "AsiExtraField");
        ZipFileTest.assertEntryName(l, 2, "ExtraFieldUtils");
        ZipFileTest.assertEntryName(l, 3, "FallbackZipEncoding");
        ZipFileTest.assertEntryName(l, 4, "GeneralPurposeBit");
        ZipFileTest.assertEntryName(l, 5, "JarMarker");
        ZipFileTest.assertEntryName(l, 6, "NioZipEncoding");
        ZipFileTest.assertEntryName(l, 7, "Simple8BitZipEncoding");
        ZipFileTest.assertEntryName(l, 8, "UnicodeCommentExtraField");
        ZipFileTest.assertEntryName(l, 9, "UnicodePathExtraField");
        ZipFileTest.assertEntryName(l, 10, "UnixStat");
        ZipFileTest.assertEntryName(l, 11, "UnparseableExtraFieldData");
        ZipFileTest.assertEntryName(l, 12, "UnrecognizedExtraField");
        ZipFileTest.assertEntryName(l, 13, "ZipArchiveEntry");
        ZipFileTest.assertEntryName(l, 14, "ZipArchiveInputStream");
        ZipFileTest.assertEntryName(l, 15, "ZipArchiveOutputStream");
        ZipFileTest.assertEntryName(l, 16, "ZipEncoding");
        ZipFileTest.assertEntryName(l, 17, "ZipEncodingHelper");
        ZipFileTest.assertEntryName(l, 18, "ZipExtraField");
        ZipFileTest.assertEntryName(l, 19, "ZipUtil");
        ZipFileTest.assertEntryName(l, 20, "ZipLong");
        ZipFileTest.assertEntryName(l, 21, "ZipShort");
        ZipFileTest.assertEntryName(l, 22, "ZipFile");
    }

    public void testPhysicalOrder() throws Exception {
        this.readOrderTest();
        ArrayList<ZipArchiveEntry> l = Collections.list(this.zf.getEntriesInPhysicalOrder());
        ZipFileTest.assertEntryName(l, 0, "AbstractUnicodeExtraField");
        ZipFileTest.assertEntryName(l, 1, "AsiExtraField");
        ZipFileTest.assertEntryName(l, 2, "ExtraFieldUtils");
        ZipFileTest.assertEntryName(l, 3, "FallbackZipEncoding");
        ZipFileTest.assertEntryName(l, 4, "GeneralPurposeBit");
        ZipFileTest.assertEntryName(l, 5, "JarMarker");
        ZipFileTest.assertEntryName(l, 6, "NioZipEncoding");
        ZipFileTest.assertEntryName(l, 7, "Simple8BitZipEncoding");
        ZipFileTest.assertEntryName(l, 8, "UnicodeCommentExtraField");
        ZipFileTest.assertEntryName(l, 9, "UnicodePathExtraField");
        ZipFileTest.assertEntryName(l, 10, "UnixStat");
        ZipFileTest.assertEntryName(l, 11, "UnparseableExtraFieldData");
        ZipFileTest.assertEntryName(l, 12, "UnrecognizedExtraField");
        ZipFileTest.assertEntryName(l, 13, "ZipArchiveEntry");
        ZipFileTest.assertEntryName(l, 14, "ZipArchiveInputStream");
        ZipFileTest.assertEntryName(l, 15, "ZipArchiveOutputStream");
        ZipFileTest.assertEntryName(l, 16, "ZipEncoding");
        ZipFileTest.assertEntryName(l, 17, "ZipEncodingHelper");
        ZipFileTest.assertEntryName(l, 18, "ZipExtraField");
        ZipFileTest.assertEntryName(l, 19, "ZipFile");
        ZipFileTest.assertEntryName(l, 20, "ZipLong");
        ZipFileTest.assertEntryName(l, 21, "ZipShort");
        ZipFileTest.assertEntryName(l, 22, "ZipUtil");
    }

    public void testDoubleClose() throws Exception {
        this.readOrderTest();
        this.zf.close();
        try {
            this.zf.close();
        }
        catch (Exception ex) {
            ZipFileTest.fail((String)"Caught exception of second close");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReadingOfStoredEntry() throws Exception {
        File f = File.createTempFile("commons-compress-zipfiletest", ".zip");
        f.deleteOnExit();
        FileOutputStream o = null;
        InputStream i = null;
        try {
            o = new FileOutputStream(f);
            ZipArchiveOutputStream zo = new ZipArchiveOutputStream((OutputStream)o);
            ZipArchiveEntry ze = new ZipArchiveEntry("foo");
            ze.setMethod(0);
            ze.setSize(4L);
            ze.setCrc(3057449933L);
            zo.putArchiveEntry((ArchiveEntry)ze);
            zo.write(new byte[]{1, 2, 3, 4});
            zo.closeArchiveEntry();
            zo.close();
            ((OutputStream)o).close();
            o = null;
            this.zf = new ZipFile(f);
            ze = this.zf.getEntry("foo");
            ZipFileTest.assertNotNull((Object)ze);
            i = this.zf.getInputStream(ze);
            byte[] b = new byte[4];
            ZipFileTest.assertEquals((int)4, (int)i.read(b));
            ZipFileTest.assertEquals((int)-1, (int)i.read());
        }
        finally {
            if (o != null) {
                ((OutputStream)o).close();
            }
            if (i != null) {
                i.close();
            }
            f.delete();
        }
    }

    public void testWinzipBackSlashWorkaround() throws Exception {
        File archive = AbstractTestCase.getFile("test-winzip.zip");
        this.zf = new ZipFile(archive);
        ZipFileTest.assertNull((Object)this.zf.getEntry("\u00e4\\\u00fc.txt"));
        ZipFileTest.assertNotNull((Object)this.zf.getEntry("\u00e4/\u00fc.txt"));
    }

    public void testSkipsPK00Prefix() throws Exception {
        File archive = AbstractTestCase.getFile("COMPRESS-208.zip");
        this.zf = new ZipFile(archive);
        ZipFileTest.assertNotNull((Object)this.zf.getEntry("test1.xml"));
        ZipFileTest.assertNotNull((Object)this.zf.getEntry("test2.xml"));
    }

    public void testUnixSymlinkSampleFile() throws Exception {
        String entryPrefix = "COMPRESS-214_unix_symlinks/";
        TreeMap<String, String> expectedVals = new TreeMap<String, String>();
        expectedVals.put("COMPRESS-214_unix_symlinks/link1", "../COMPRESS-214_unix_symlinks/./a/b/c/../../../\uf999");
        expectedVals.put("COMPRESS-214_unix_symlinks/link2", "../COMPRESS-214_unix_symlinks/./a/b/c/../../../g");
        expectedVals.put("COMPRESS-214_unix_symlinks/link3", "../COMPRESS-214_unix_symlinks/././a/b/c/../../../\u76f4\u6a39");
        expectedVals.put("COMPRESS-214_unix_symlinks/link4", "\u82b1\u5b50/\u745b\u5b50");
        expectedVals.put("COMPRESS-214_unix_symlinks/\uf999", "./\u82b1\u5b50/\u745b\u5b50/\u5897\u8c37/\uf999");
        expectedVals.put("COMPRESS-214_unix_symlinks/g", "./a/b/c/d/e/f/g");
        expectedVals.put("COMPRESS-214_unix_symlinks/\u76f4\u6a39", "./g");
        expectedVals.put("COMPRESS-214_unix_symlinks/link5", "../COMPRESS-214_unix_symlinks/././a/b");
        expectedVals.put("COMPRESS-214_unix_symlinks/link6", "../COMPRESS-214_unix_symlinks/././a/b/");
        File archive = AbstractTestCase.getFile("COMPRESS-214_unix_symlinks.zip");
        this.zf = new ZipFile(archive);
        Enumeration en = this.zf.getEntries();
        while (en.hasMoreElements()) {
            ZipArchiveEntry zae = (ZipArchiveEntry)en.nextElement();
            String link = this.zf.getUnixSymlink(zae);
            if (zae.isUnixSymlink()) {
                String name = zae.getName();
                String expected = (String)expectedVals.get(name);
                ZipFileTest.assertEquals((String)expected, (String)link);
                continue;
            }
            ZipFileTest.assertNull((Object)link);
        }
    }

    public void testDuplicateEntry() throws Exception {
        File archive = AbstractTestCase.getFile("COMPRESS-227.zip");
        this.zf = new ZipFile(archive);
        ZipArchiveEntry ze = this.zf.getEntry("test1.txt");
        ZipFileTest.assertNotNull((Object)ze);
        ZipFileTest.assertNotNull((Object)this.zf.getInputStream(ze));
        int numberOfEntries = 0;
        for (ZipArchiveEntry entry : this.zf.getEntries("test1.txt")) {
            ++numberOfEntries;
            ZipFileTest.assertNotNull((Object)this.zf.getInputStream(entry));
        }
        ZipFileTest.assertEquals((int)2, (int)numberOfEntries);
    }

    public void testExcessDataInZip64ExtraField() throws Exception {
        File archive = AbstractTestCase.getFile("COMPRESS-228.zip");
        this.zf = new ZipFile(archive);
        ZipArchiveEntry ze = this.zf.getEntry("src/main/java/org/apache/commons/compress/archivers/zip/ZipFile.java");
        ZipFileTest.assertEquals((long)26101L, (long)ze.getSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUnshrinking() throws Exception {
        this.zf = new ZipFile(AbstractTestCase.getFile("SHRUNK.ZIP"));
        ZipArchiveEntry test = this.zf.getEntry("TEST1.XML");
        FileInputStream original = new FileInputStream(AbstractTestCase.getFile("test1.xml"));
        try {
            Assert.assertArrayEquals((byte[])IOUtils.toByteArray((InputStream)original), (byte[])IOUtils.toByteArray((InputStream)this.zf.getInputStream(test)));
        }
        finally {
            original.close();
        }
        test = this.zf.getEntry("TEST2.XML");
        original = new FileInputStream(AbstractTestCase.getFile("test2.xml"));
        try {
            Assert.assertArrayEquals((byte[])IOUtils.toByteArray((InputStream)original), (byte[])IOUtils.toByteArray((InputStream)this.zf.getInputStream(test)));
        }
        finally {
            original.close();
        }
    }

    public void testReadingOfFirstStoredEntry() throws Exception {
        File archive = AbstractTestCase.getFile("COMPRESS-264.zip");
        this.zf = new ZipFile(archive);
        ZipArchiveEntry ze = this.zf.getEntry("test.txt");
        ZipFileTest.assertEquals((long)5L, (long)ze.getSize());
        Assert.assertArrayEquals((byte[])new byte[]{100, 97, 116, 97, 10}, (byte[])IOUtils.toByteArray((InputStream)this.zf.getInputStream(ze)));
    }

    private void readOrderTest() throws Exception {
        File archive = AbstractTestCase.getFile("ordertest.zip");
        this.zf = new ZipFile(archive);
    }

    private static void assertEntryName(ArrayList<ZipArchiveEntry> entries, int index, String expectedName) {
        ZipArchiveEntry ze = entries.get(index);
        ZipFileTest.assertEquals((String)("src/main/java/org/apache/commons/compress/archivers/zip/" + expectedName + ".java"), (String)ze.getName());
    }
}

