/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import junit.framework.TestCase;
import org.apache.commons.compress.archivers.zip.ZipLong;

public class ZipLongTest
extends TestCase {
    public ZipLongTest(String name) {
        super(name);
    }

    public void testToBytes() {
        ZipLong zl = new ZipLong(305419896L);
        byte[] result = zl.getBytes();
        ZipLongTest.assertEquals((String)"length getBytes", (int)4, (int)result.length);
        ZipLongTest.assertEquals((String)"first byte getBytes", (int)120, (int)result[0]);
        ZipLongTest.assertEquals((String)"second byte getBytes", (int)86, (int)result[1]);
        ZipLongTest.assertEquals((String)"third byte getBytes", (int)52, (int)result[2]);
        ZipLongTest.assertEquals((String)"fourth byte getBytes", (int)18, (int)result[3]);
    }

    public void testFromBytes() {
        byte[] val = new byte[]{120, 86, 52, 18};
        ZipLong zl = new ZipLong(val);
        ZipLongTest.assertEquals((String)"value from bytes", (long)305419896L, (long)zl.getValue());
    }

    public void testEquals() {
        ZipLong zl = new ZipLong(305419896L);
        ZipLong zl2 = new ZipLong(305419896L);
        ZipLong zl3 = new ZipLong(-2023406815L);
        ZipLongTest.assertTrue((String)"reflexive", (boolean)zl.equals((Object)zl));
        ZipLongTest.assertTrue((String)"works", (boolean)zl.equals((Object)zl2));
        ZipLongTest.assertTrue((String)"works, part two", (!zl.equals((Object)zl3) ? 1 : 0) != 0);
        ZipLongTest.assertTrue((String)"symmetric", (boolean)zl2.equals((Object)zl));
        ZipLongTest.assertTrue((String)"null handling", (!zl.equals(null) ? 1 : 0) != 0);
        ZipLongTest.assertTrue((String)"non ZipLong handling", (!zl.equals((Object)new Integer(4660)) ? 1 : 0) != 0);
    }

    public void testSign() {
        ZipLong zl = new ZipLong(new byte[]{-1, -1, -1, -1});
        ZipLongTest.assertEquals((long)0xFFFFFFFFL, (long)zl.getValue());
    }

    public void testClone() {
        ZipLong s1 = new ZipLong(42L);
        ZipLong s2 = (ZipLong)s1.clone();
        ZipLongTest.assertNotSame((Object)s1, (Object)s2);
        ZipLongTest.assertEquals((Object)s1, (Object)s2);
        ZipLongTest.assertEquals((long)s1.getValue(), (long)s2.getValue());
    }
}

