/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import junit.framework.TestCase;
import org.apache.commons.compress.archivers.zip.ZipShort;

public class ZipShortTest
extends TestCase {
    public ZipShortTest(String name) {
        super(name);
    }

    public void testToBytes() {
        ZipShort zs = new ZipShort(4660);
        byte[] result = zs.getBytes();
        ZipShortTest.assertEquals((String)"length getBytes", (int)2, (int)result.length);
        ZipShortTest.assertEquals((String)"first byte getBytes", (int)52, (int)result[0]);
        ZipShortTest.assertEquals((String)"second byte getBytes", (int)18, (int)result[1]);
    }

    public void testFromBytes() {
        byte[] val = new byte[]{52, 18};
        ZipShort zs = new ZipShort(val);
        ZipShortTest.assertEquals((String)"value from bytes", (int)4660, (int)zs.getValue());
    }

    public void testEquals() {
        ZipShort zs = new ZipShort(4660);
        ZipShort zs2 = new ZipShort(4660);
        ZipShort zs3 = new ZipShort(22136);
        ZipShortTest.assertTrue((String)"reflexive", (boolean)zs.equals((Object)zs));
        ZipShortTest.assertTrue((String)"works", (boolean)zs.equals((Object)zs2));
        ZipShortTest.assertTrue((String)"works, part two", (!zs.equals((Object)zs3) ? 1 : 0) != 0);
        ZipShortTest.assertTrue((String)"symmetric", (boolean)zs2.equals((Object)zs));
        ZipShortTest.assertTrue((String)"null handling", (!zs.equals(null) ? 1 : 0) != 0);
        ZipShortTest.assertTrue((String)"non ZipShort handling", (!zs.equals((Object)new Integer(4660)) ? 1 : 0) != 0);
    }

    public void testSign() {
        ZipShort zs = new ZipShort(new byte[]{-1, -1});
        ZipShortTest.assertEquals((int)65535, (int)zs.getValue());
    }

    public void testClone() {
        ZipShort s1 = new ZipShort(42);
        ZipShort s2 = (ZipShort)s1.clone();
        ZipShortTest.assertNotSame((Object)s1, (Object)s2);
        ZipShortTest.assertEquals((Object)s1, (Object)s2);
        ZipShortTest.assertEquals((int)s1.getValue(), (int)s2.getValue());
    }
}

