/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import junit.framework.TestCase;
import org.apache.commons.compress.archivers.zip.ZipLong;
import org.apache.commons.compress.archivers.zip.ZipUtil;

public class ZipUtilTest
extends TestCase {
    private Date time;
    private ZipLong zl;

    public ZipUtilTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.time = new Date();
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.time);
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        long value = year - 1980 << 25 | month << 21 | cal.get(5) << 16 | cal.get(11) << 11 | cal.get(12) << 5 | cal.get(13) >> 1;
        byte[] result = new byte[]{(byte)(value & 0xFFL), (byte)((value & 0xFF00L) >> 8), (byte)((value & 0xFF0000L) >> 16), (byte)((value & 0xFF000000L) >> 24)};
        this.zl = new ZipLong(result);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testZipLong() throws Exception {
        ZipLong test = ZipUtil.toDosTime((Date)this.time);
        ZipUtilTest.assertEquals((long)test.getValue(), (long)this.zl.getValue());
    }

    public void testAdjustToLong() {
        ZipUtilTest.assertEquals((long)Integer.MAX_VALUE, (long)ZipUtil.adjustToLong((int)Integer.MAX_VALUE));
        ZipUtilTest.assertEquals((long)0x80000000L, (long)ZipUtil.adjustToLong((int)Integer.MIN_VALUE));
        ZipUtilTest.assertEquals((long)0xFFFFFFFEL, (long)ZipUtil.adjustToLong((int)-2));
    }

    public void testMinTime() {
        byte[] b1 = ZipUtil.toDosTime((long)0L);
        byte b10 = b1[0];
        b1[0] = (byte)(b1[0] + 1);
        byte[] b2 = ZipUtil.toDosTime((long)0L);
        ZipUtilTest.assertEquals((byte)b10, (byte)b2[0]);
    }

    public void testReverse() {
        byte[][] bTest = new byte[][]{new byte[0], {1}, {1, 2}, {1, 2, 3}, {1, 2, 3, 4}, {1, 2, 3, 4, 5}};
        byte[][] rTest = new byte[][]{new byte[0], {1}, {2, 1}, {3, 2, 1}, {4, 3, 2, 1}, {5, 4, 3, 2, 1}};
        ZipUtilTest.assertEquals((String)"test and result arrays are same length", (int)bTest.length, (int)rTest.length);
        for (int i = 0; i < bTest.length; ++i) {
            byte[] result = ZipUtil.reverse((byte[])bTest[i]);
            ZipUtilTest.assertTrue((String)"reverse mutates in-place", (bTest[i] == result ? 1 : 0) != 0);
            ZipUtilTest.assertTrue((String)"reverse actually reverses", (boolean)Arrays.equals(rTest[i], result));
        }
    }

    public void testBigToLong() {
        BigInteger big1 = BigInteger.valueOf(1L);
        BigInteger big2 = BigInteger.valueOf(Long.MAX_VALUE);
        BigInteger big3 = BigInteger.valueOf(Long.MIN_VALUE);
        ZipUtilTest.assertEquals((long)1L, (long)ZipUtil.bigToLong((BigInteger)big1));
        ZipUtilTest.assertEquals((long)Long.MAX_VALUE, (long)ZipUtil.bigToLong((BigInteger)big2));
        ZipUtilTest.assertEquals((long)Long.MIN_VALUE, (long)ZipUtil.bigToLong((BigInteger)big3));
        BigInteger big4 = big2.add(big1);
        try {
            ZipUtil.bigToLong((BigInteger)big4);
            ZipUtilTest.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        BigInteger big5 = big3.subtract(big1);
        try {
            ZipUtil.bigToLong((BigInteger)big5);
            ZipUtilTest.fail((String)"ZipUtil.bigToLong(BigInteger) should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
    }

    public void testLongToBig() {
        long l0 = 0L;
        long l1 = 1L;
        long l2 = -1L;
        long l3 = Integer.MIN_VALUE;
        long l4 = Long.MAX_VALUE;
        long l5 = Long.MIN_VALUE;
        BigInteger big0 = ZipUtil.longToBig((long)l0);
        BigInteger big1 = ZipUtil.longToBig((long)l1);
        BigInteger big2 = ZipUtil.longToBig((long)l2);
        BigInteger big3 = ZipUtil.longToBig((long)l3);
        BigInteger big4 = ZipUtil.longToBig((long)l4);
        ZipUtilTest.assertEquals((long)0L, (long)big0.longValue());
        ZipUtilTest.assertEquals((long)1L, (long)big1.longValue());
        ZipUtilTest.assertEquals((long)0xFFFFFFFFL, (long)big2.longValue());
        ZipUtilTest.assertEquals((long)0x80000000L, (long)big3.longValue());
        ZipUtilTest.assertEquals((long)Long.MAX_VALUE, (long)big4.longValue());
        try {
            ZipUtil.longToBig((long)l5);
            ZipUtilTest.fail((String)"ZipUtil.longToBig(long) should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
    }

    public void testSignedByteToUnsignedInt() {
        int expectedVal = 128;
        for (int i = -128; i <= 127; ++i) {
            byte b = (byte)i;
            ZipUtilTest.assertEquals((int)expectedVal, (int)ZipUtil.signedByteToUnsignedInt((byte)b));
            if (++expectedVal != 256) continue;
            expectedVal = 0;
        }
    }

    public void testUnsignedIntToSignedByte() {
        int unsignedVal = 128;
        for (int i = -128; i <= 127; ++i) {
            byte expectedVal = (byte)i;
            ZipUtilTest.assertEquals((byte)expectedVal, (byte)ZipUtil.unsignedIntToSignedByte((int)unsignedVal));
            if (++unsignedVal != 256) continue;
            unsignedVal = 0;
        }
        try {
            ZipUtil.unsignedIntToSignedByte((int)-1);
            ZipUtilTest.fail((String)"ZipUtil.unsignedIntToSignedByte(-1) should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            ZipUtil.unsignedIntToSignedByte((int)256);
            ZipUtilTest.fail((String)"ZipUtil.unsignedIntToSignedByte(256) should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

