/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.changes;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.ar.ArArchiveEntry;
import org.apache.commons.compress.archivers.cpio.CpioArchiveEntry;
import org.apache.commons.compress.archivers.jar.JarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.changes.Change;
import org.apache.commons.compress.changes.ChangeSet;
import org.apache.commons.compress.changes.ChangeSetPerformer;
import org.apache.commons.compress.changes.ChangeSetResults;

public final class ChangeSetTestCase
extends AbstractTestCase {
    private void archiveListDeleteDir(String prefix) {
        Iterator it = this.archiveList.iterator();
        while (it.hasNext()) {
            String entry = (String)it.next();
            if (!entry.startsWith(prefix + "/")) continue;
            it.remove();
        }
    }

    private void archiveListDelete(String prefix) {
        Iterator it = this.archiveList.iterator();
        while (it.hasNext()) {
            String entry = (String)it.next();
            if (!entry.equals(prefix)) continue;
            it.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAddChangeTwice() throws Exception {
        FileInputStream in = null;
        InputStream in2 = null;
        try {
            in = new FileInputStream(ChangeSetTestCase.getFile("test.txt"));
            in2 = new FileInputStream(ChangeSetTestCase.getFile("test2.xml"));
            ZipArchiveEntry e = new ZipArchiveEntry("test.txt");
            ZipArchiveEntry e2 = new ZipArchiveEntry("test.txt");
            ChangeSet changes = new ChangeSet();
            changes.add((ArchiveEntry)e, (InputStream)in);
            changes.add((ArchiveEntry)e2, in2);
            ChangeSetTestCase.assertEquals((int)1, (int)changes.getChanges().size());
            Change c = (Change)changes.getChanges().iterator().next();
            ChangeSetTestCase.assertEquals((Object)in2, (Object)c.getInput());
        }
        finally {
            if (in != null) {
                ((InputStream)in).close();
            }
            if (in2 != null) {
                in2.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAddChangeTwiceWithoutReplace() throws Exception {
        FileInputStream in = null;
        InputStream in2 = null;
        try {
            in = new FileInputStream(ChangeSetTestCase.getFile("test.txt"));
            in2 = new FileInputStream(ChangeSetTestCase.getFile("test2.xml"));
            ZipArchiveEntry e = new ZipArchiveEntry("test.txt");
            ZipArchiveEntry e2 = new ZipArchiveEntry("test.txt");
            ChangeSet changes = new ChangeSet();
            changes.add((ArchiveEntry)e, (InputStream)in, true);
            changes.add((ArchiveEntry)e2, in2, false);
            ChangeSetTestCase.assertEquals((int)1, (int)changes.getChanges().size());
            Change c = (Change)changes.getChanges().iterator().next();
            ChangeSetTestCase.assertEquals((Object)in, (Object)c.getInput());
        }
        finally {
            if (in != null) {
                ((InputStream)in).close();
            }
            if (in2 != null) {
                in2.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDeleteDir() throws Exception {
        String archivename = "cpio";
        File input = this.createArchive("cpio");
        ArchiveOutputStream out = null;
        ArchiveInputStream ais = null;
        File result = File.createTempFile("test", ".cpio");
        result.deleteOnExit();
        try {
            FileInputStream is = new FileInputStream(input);
            ais = this.factory.createArchiveInputStream("cpio", (InputStream)is);
            out = this.factory.createArchiveOutputStream("cpio", (OutputStream)new FileOutputStream(result));
            ChangeSet changes = new ChangeSet();
            changes.deleteDir("bla");
            this.archiveListDeleteDir("bla");
            ChangeSetPerformer performer = new ChangeSetPerformer(changes);
            performer.perform(ais, out);
            ((InputStream)is).close();
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (ais != null) {
                ais.close();
            }
        }
        this.checkArchiveContent(result, (List<String>)this.archiveList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDeleteDir2() throws Exception {
        String archivename = "cpio";
        File input = this.createArchive("cpio");
        ArchiveOutputStream out = null;
        ArchiveInputStream ais = null;
        File result = File.createTempFile("test", ".cpio");
        result.deleteOnExit();
        try {
            FileInputStream is = new FileInputStream(input);
            ais = this.factory.createArchiveInputStream("cpio", (InputStream)is);
            out = this.factory.createArchiveOutputStream("cpio", (OutputStream)new FileOutputStream(result));
            ChangeSet changes = new ChangeSet();
            changes.deleteDir("la");
            this.archiveListDeleteDir("la");
            ChangeSetPerformer performer = new ChangeSetPerformer(changes);
            performer.perform(ais, out);
            ((InputStream)is).close();
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (ais != null) {
                ais.close();
            }
        }
        this.checkArchiveContent(result, (List<String>)this.archiveList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDeleteDir3() throws Exception {
        String archivename = "cpio";
        File input = this.createArchive("cpio");
        ArchiveOutputStream out = null;
        ArchiveInputStream ais = null;
        File result = File.createTempFile("test", ".cpio");
        result.deleteOnExit();
        try {
            FileInputStream is = new FileInputStream(input);
            ais = this.factory.createArchiveInputStream("cpio", (InputStream)is);
            out = this.factory.createArchiveOutputStream("cpio", (OutputStream)new FileOutputStream(result));
            ChangeSet changes = new ChangeSet();
            changes.deleteDir("test.txt");
            this.archiveListDeleteDir("test.txt");
            ChangeSetPerformer performer = new ChangeSetPerformer(changes);
            performer.perform(ais, out);
            ((InputStream)is).close();
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (ais != null) {
                ais.close();
            }
        }
        this.checkArchiveContent(result, (List<String>)this.archiveList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDeleteFile() throws Exception {
        String archivename = "cpio";
        File input = this.createArchive("cpio");
        ArchiveOutputStream out = null;
        ArchiveInputStream ais = null;
        File result = File.createTempFile("test", ".cpio");
        result.deleteOnExit();
        try {
            FileInputStream is = new FileInputStream(input);
            ais = this.factory.createArchiveInputStream("cpio", (InputStream)is);
            out = this.factory.createArchiveOutputStream("cpio", (OutputStream)new FileOutputStream(result));
            ChangeSet changes = new ChangeSet();
            changes.delete("bla/test5.xml");
            this.archiveListDelete("bla/test5.xml");
            ChangeSetPerformer performer = new ChangeSetPerformer(changes);
            performer.perform(ais, out);
            ((InputStream)is).close();
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (ais != null) {
                ais.close();
            }
        }
        this.checkArchiveContent(result, (List<String>)this.archiveList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDeleteFile2() throws Exception {
        String archivename = "cpio";
        File input = this.createArchive("cpio");
        ArchiveOutputStream out = null;
        ArchiveInputStream ais = null;
        File result = File.createTempFile("test", ".cpio");
        result.deleteOnExit();
        try {
            FileInputStream is = new FileInputStream(input);
            ais = this.factory.createArchiveInputStream("cpio", (InputStream)is);
            out = this.factory.createArchiveOutputStream("cpio", (OutputStream)new FileOutputStream(result));
            ChangeSet changes = new ChangeSet();
            changes.delete("bla");
            ChangeSetPerformer performer = new ChangeSetPerformer(changes);
            performer.perform(ais, out);
            ((InputStream)is).close();
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (ais != null) {
                ais.close();
            }
        }
        this.checkArchiveContent(result, (List<String>)this.archiveList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testDeletePlusAddSame() throws Exception {
        File check;
        block10: {
            String archivename = "zip";
            File input = this.createArchive("zip");
            ArchiveOutputStream out = null;
            ArchiveInputStream ais = null;
            File result = File.createTempFile("test", ".zip");
            result.deleteOnExit();
            File testtxt = null;
            try {
                FileInputStream is = new FileInputStream(input);
                ais = this.factory.createArchiveInputStream("zip", (InputStream)is);
                out = this.factory.createArchiveOutputStream("zip", (OutputStream)new FileOutputStream(result));
                ChangeSet changes = new ChangeSet();
                changes.delete("test/test3.xml");
                this.archiveListDelete("test/test3.xml");
                testtxt = ChangeSetTestCase.getFile("test.txt");
                ArchiveEntry entry = out.createArchiveEntry(testtxt, "test/test3.xml");
                changes.add(entry, (InputStream)new FileInputStream(testtxt));
                this.archiveList.add("test/test3.xml");
                ChangeSetPerformer performer = new ChangeSetPerformer(changes);
                performer.perform(ais, out);
                ((InputStream)is).close();
            }
            finally {
                if (out != null) {
                    out.close();
                }
                if (ais != null) {
                    ais.close();
                }
            }
            ArchiveInputStream in = null;
            check = null;
            try {
                String str;
                FileInputStream is = new FileInputStream(result);
                BufferedInputStream buf = new BufferedInputStream(is);
                in = this.factory.createArchiveInputStream((InputStream)buf);
                check = this.checkArchiveContent(in, this.archiveList, false);
                File test3xml = new File(check, "result/test/test3.xml");
                ChangeSetTestCase.assertEquals((long)testtxt.length(), (long)test3xml.length());
                BufferedReader reader = new BufferedReader(new FileReader(test3xml));
                while ((str = reader.readLine()) != null) {
                    "111111111111111111111111111000101011".equals(str);
                }
                reader.close();
                if (in == null) break block10;
            }
            catch (Throwable throwable) {
                if (in != null) {
                    in.close();
                }
                ChangeSetTestCase.rmdir(check);
                throw throwable;
            }
            in.close();
        }
        ChangeSetTestCase.rmdir(check);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testChangeSetResults() throws Exception {
        String archivename = "cpio";
        File input = this.createArchive("cpio");
        ArchiveOutputStream out = null;
        ArchiveInputStream ais = null;
        File result = File.createTempFile("test", ".cpio");
        result.deleteOnExit();
        try {
            FileInputStream is = new FileInputStream(input);
            ais = this.factory.createArchiveInputStream("cpio", (InputStream)is);
            out = this.factory.createArchiveOutputStream("cpio", (OutputStream)new FileOutputStream(result));
            ChangeSet changes = new ChangeSet();
            changes.deleteDir("bla");
            this.archiveListDeleteDir("bla");
            File file1 = ChangeSetTestCase.getFile("test.txt");
            ArchiveEntry entry = out.createArchiveEntry(file1, "bla/test.txt");
            changes.add(entry, (InputStream)new FileInputStream(file1));
            this.archiveList.add("bla/test.txt");
            ChangeSetPerformer performer = new ChangeSetPerformer(changes);
            ChangeSetResults results = performer.perform(ais, out);
            ((InputStream)is).close();
            ChangeSetTestCase.assertEquals((int)1, (int)results.getAddedFromChangeSet().size());
            ChangeSetTestCase.assertEquals((String)"bla/test.txt", (String)((String)results.getAddedFromChangeSet().iterator().next()));
            ChangeSetTestCase.assertEquals((int)3, (int)results.getDeleted().size());
            ChangeSetTestCase.assertTrue((boolean)results.getDeleted().contains("bla/test4.xml"));
            ChangeSetTestCase.assertTrue((boolean)results.getDeleted().contains("bla/test5.xml"));
            ChangeSetTestCase.assertTrue((boolean)results.getDeleted().contains("bla/blubber/test6.xml"));
            ChangeSetTestCase.assertTrue((boolean)results.getAddedFromStream().contains("testdata/test1.xml"));
            ChangeSetTestCase.assertTrue((boolean)results.getAddedFromStream().contains("testdata/test2.xml"));
            ChangeSetTestCase.assertTrue((boolean)results.getAddedFromStream().contains("test/test3.xml"));
            ChangeSetTestCase.assertTrue((boolean)results.getAddedFromStream().contains("test.txt"));
            ChangeSetTestCase.assertTrue((boolean)results.getAddedFromStream().contains("something/bla"));
            ChangeSetTestCase.assertTrue((boolean)results.getAddedFromStream().contains("test with spaces.txt"));
            ChangeSetTestCase.assertEquals((int)6, (int)results.getAddedFromStream().size());
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (ais != null) {
                ais.close();
            }
        }
        this.checkArchiveContent(result, (List<String>)this.archiveList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDeletePlusAdd() throws Exception {
        String archivename = "cpio";
        File input = this.createArchive("cpio");
        ArchiveOutputStream out = null;
        ArchiveInputStream ais = null;
        File result = File.createTempFile("test", ".cpio");
        result.deleteOnExit();
        try {
            FileInputStream is = new FileInputStream(input);
            ais = this.factory.createArchiveInputStream("cpio", (InputStream)is);
            out = this.factory.createArchiveOutputStream("cpio", (OutputStream)new FileOutputStream(result));
            ChangeSet changes = new ChangeSet();
            changes.deleteDir("bla");
            this.archiveListDeleteDir("bla");
            File file1 = ChangeSetTestCase.getFile("test.txt");
            ArchiveEntry entry = out.createArchiveEntry(file1, "bla/test.txt");
            changes.add(entry, (InputStream)new FileInputStream(file1));
            this.archiveList.add("bla/test.txt");
            ChangeSetPerformer performer = new ChangeSetPerformer(changes);
            performer.perform(ais, out);
            ((InputStream)is).close();
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (ais != null) {
                ais.close();
            }
        }
        this.checkArchiveContent(result, (List<String>)this.archiveList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDeleteFromAndAddToZip() throws Exception {
        String archivename = "zip";
        File input = this.createArchive("zip");
        ArchiveOutputStream out = null;
        ArchiveInputStream ais = null;
        File result = File.createTempFile("test", ".zip");
        result.deleteOnExit();
        try {
            FileInputStream is = new FileInputStream(input);
            ais = this.factory.createArchiveInputStream("zip", (InputStream)is);
            out = this.factory.createArchiveOutputStream("zip", (OutputStream)new FileOutputStream(result));
            ChangeSet changes = new ChangeSet();
            File file1 = ChangeSetTestCase.getFile("test.txt");
            ZipArchiveEntry entry = new ZipArchiveEntry("blub/test.txt");
            changes.add((ArchiveEntry)entry, (InputStream)new FileInputStream(file1));
            this.archiveList.add("blub/test.txt");
            changes.delete("testdata/test1.xml");
            this.archiveListDelete("testdata/test1.xml");
            ChangeSetPerformer performer = new ChangeSetPerformer(changes);
            performer.perform(ais, out);
            ((InputStream)is).close();
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (ais != null) {
                ais.close();
            }
        }
        this.checkArchiveContent(result, (List<String>)this.archiveList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDeleteFromAndAddToZipUsingZipFilePerform() throws Exception {
        String archivename = "zip";
        File input = this.createArchive("zip");
        ArchiveOutputStream out = null;
        ZipFile ais = null;
        File result = File.createTempFile("test", ".zip");
        result.deleteOnExit();
        try {
            ais = new ZipFile(input);
            out = this.factory.createArchiveOutputStream("zip", (OutputStream)new FileOutputStream(result));
            ChangeSet changes = new ChangeSet();
            File file1 = ChangeSetTestCase.getFile("test.txt");
            ZipArchiveEntry entry = new ZipArchiveEntry("blub/test.txt");
            changes.add((ArchiveEntry)entry, (InputStream)new FileInputStream(file1));
            this.archiveList.add("blub/test.txt");
            changes.delete("testdata/test1.xml");
            this.archiveListDelete("testdata/test1.xml");
            ChangeSetPerformer performer = new ChangeSetPerformer(changes);
            performer.perform(ais, out);
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (ais != null) {
                ais.close();
            }
        }
        this.checkArchiveContent(result, (List<String>)this.archiveList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAddDeleteAdd() throws Exception {
        String archivename = "cpio";
        File input = this.createArchive("cpio");
        ArchiveOutputStream out = null;
        ArchiveInputStream ais = null;
        File result = File.createTempFile("test", ".cpio");
        result.deleteOnExit();
        try {
            FileInputStream is = new FileInputStream(input);
            ais = this.factory.createArchiveInputStream("cpio", (InputStream)is);
            out = this.factory.createArchiveOutputStream("cpio", (OutputStream)new FileOutputStream(result));
            ChangeSet changes = new ChangeSet();
            File file1 = ChangeSetTestCase.getFile("test.txt");
            CpioArchiveEntry entry = new CpioArchiveEntry("blub/test.txt");
            changes.add((ArchiveEntry)entry, (InputStream)new FileInputStream(file1));
            this.archiveList.add("blub/test.txt");
            changes.deleteDir("blub");
            this.archiveListDeleteDir("blub");
            ChangeSetPerformer performer = new ChangeSetPerformer(changes);
            performer.perform(ais, out);
            ((InputStream)is).close();
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (ais != null) {
                ais.close();
            }
        }
        this.checkArchiveContent(result, (List<String>)this.archiveList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDeleteAddDelete() throws Exception {
        String archivename = "cpio";
        File input = this.createArchive("cpio");
        ArchiveOutputStream out = null;
        ArchiveInputStream ais = null;
        File result = File.createTempFile("test", ".cpio");
        result.deleteOnExit();
        try {
            FileInputStream is = new FileInputStream(input);
            ais = this.factory.createArchiveInputStream("cpio", (InputStream)is);
            out = this.factory.createArchiveOutputStream("cpio", (OutputStream)new FileOutputStream(result));
            ChangeSet changes = new ChangeSet();
            changes.deleteDir("bla");
            File file1 = ChangeSetTestCase.getFile("test.txt");
            CpioArchiveEntry entry = new CpioArchiveEntry("bla/test.txt");
            changes.add((ArchiveEntry)entry, (InputStream)new FileInputStream(file1));
            this.archiveList.add("bla/test.txt");
            changes.deleteDir("bla");
            this.archiveListDeleteDir("bla");
            ChangeSetPerformer performer = new ChangeSetPerformer(changes);
            performer.perform(ais, out);
            ((InputStream)is).close();
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (ais != null) {
                ais.close();
            }
        }
        this.checkArchiveContent(result, (List<String>)this.archiveList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDeleteFromZip() throws Exception {
        ArchiveOutputStream out = null;
        ArchiveInputStream ais = null;
        File temp = null;
        try {
            ChangeSet changes = new ChangeSet();
            changes.delete("test2.xml");
            File input = ChangeSetTestCase.getFile("bla.zip");
            FileInputStream is = new FileInputStream(input);
            ais = this.factory.createArchiveInputStream("zip", (InputStream)is);
            temp = File.createTempFile("test", ".zip");
            temp.deleteOnExit();
            out = this.factory.createArchiveOutputStream("zip", (OutputStream)new FileOutputStream(temp));
            ChangeSetPerformer performer = new ChangeSetPerformer(changes);
            performer.perform(ais, out);
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (ais != null) {
                ais.close();
            }
        }
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("test1.xml");
        this.checkArchiveContent(temp, expected);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDeleteFromTar() throws Exception {
        ArchiveOutputStream out = null;
        ArchiveInputStream ais = null;
        File temp = null;
        try {
            ChangeSet changes = new ChangeSet();
            changes.delete("test2.xml");
            File input = ChangeSetTestCase.getFile("bla.tar");
            FileInputStream is = new FileInputStream(input);
            ais = this.factory.createArchiveInputStream("tar", (InputStream)is);
            temp = new File(this.dir, "bla.tar");
            out = this.factory.createArchiveOutputStream("tar", (OutputStream)new FileOutputStream(temp));
            ChangeSetPerformer performer = new ChangeSetPerformer(changes);
            performer.perform(ais, out);
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (ais != null) {
                ais.close();
            }
        }
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("test1.xml");
        this.checkArchiveContent(temp, expected);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDeleteFromJar() throws Exception {
        ArchiveOutputStream out = null;
        ArchiveInputStream ais = null;
        File temp = null;
        try {
            ChangeSet changes = new ChangeSet();
            changes.delete("test2.xml");
            changes.deleteDir("META-INF");
            changes.delete(".classpath");
            changes.delete(".project");
            File input = ChangeSetTestCase.getFile("bla.jar");
            FileInputStream is = new FileInputStream(input);
            ais = this.factory.createArchiveInputStream("jar", (InputStream)is);
            temp = new File(this.dir, "bla.jar");
            out = this.factory.createArchiveOutputStream("jar", (OutputStream)new FileOutputStream(temp));
            ChangeSetPerformer performer = new ChangeSetPerformer(changes);
            performer.perform(ais, out);
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (ais != null) {
                ais.close();
            }
        }
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("test1.xml");
        this.checkArchiveContent(temp, expected);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDeleteFromAndAddToTar() throws Exception {
        ArchiveOutputStream out = null;
        ArchiveInputStream ais = null;
        File temp = null;
        try {
            ChangeSet changes = new ChangeSet();
            changes.delete("test2.xml");
            File file1 = ChangeSetTestCase.getFile("test.txt");
            TarArchiveEntry entry = new TarArchiveEntry("testdata/test.txt");
            entry.setModTime(0L);
            entry.setSize(file1.length());
            entry.setUserId(0);
            entry.setGroupId(0);
            entry.setUserName("avalon");
            entry.setGroupName("excalibur");
            entry.setMode(32768);
            changes.add((ArchiveEntry)entry, (InputStream)new FileInputStream(file1));
            File input = ChangeSetTestCase.getFile("bla.tar");
            FileInputStream is = new FileInputStream(input);
            ais = this.factory.createArchiveInputStream("tar", (InputStream)is);
            temp = new File(this.dir, "bla.tar");
            out = this.factory.createArchiveOutputStream("tar", (OutputStream)new FileOutputStream(temp));
            ChangeSetPerformer performer = new ChangeSetPerformer(changes);
            performer.perform(ais, out);
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (ais != null) {
                ais.close();
            }
        }
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("test1.xml");
        expected.add("testdata/test.txt");
        ArchiveInputStream in = this.factory.createArchiveInputStream("tar", (InputStream)new FileInputStream(temp));
        this.checkArchiveContent(in, expected);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDeleteFromAndAddToJar() throws Exception {
        ArchiveOutputStream out = null;
        ArchiveInputStream ais = null;
        File temp = null;
        try {
            ChangeSet changes = new ChangeSet();
            changes.delete("test2.xml");
            changes.deleteDir("META-INF");
            changes.delete(".classpath");
            changes.delete(".project");
            File file1 = ChangeSetTestCase.getFile("test.txt");
            JarArchiveEntry entry = new JarArchiveEntry("testdata/test.txt");
            changes.add((ArchiveEntry)entry, (InputStream)new FileInputStream(file1));
            File input = ChangeSetTestCase.getFile("bla.jar");
            FileInputStream is = new FileInputStream(input);
            ais = this.factory.createArchiveInputStream("jar", (InputStream)is);
            temp = new File(this.dir, "bla.jar");
            out = this.factory.createArchiveOutputStream("jar", (OutputStream)new FileOutputStream(temp));
            ChangeSetPerformer performer = new ChangeSetPerformer(changes);
            performer.perform(ais, out);
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (ais != null) {
                ais.close();
            }
        }
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("test1.xml");
        expected.add("testdata/test.txt");
        this.checkArchiveContent(temp, expected);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDeleteFromAr() throws Exception {
        ArchiveOutputStream out = null;
        ArchiveInputStream ais = null;
        File temp = null;
        try {
            ChangeSet changes = new ChangeSet();
            changes.delete("test2.xml");
            File input = ChangeSetTestCase.getFile("bla.ar");
            FileInputStream is = new FileInputStream(input);
            ais = this.factory.createArchiveInputStream("ar", (InputStream)is);
            temp = new File(this.dir, "bla.ar");
            out = this.factory.createArchiveOutputStream("ar", (OutputStream)new FileOutputStream(temp));
            ChangeSetPerformer performer = new ChangeSetPerformer(changes);
            performer.perform(ais, out);
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (ais != null) {
                ais.close();
            }
        }
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("test1.xml");
        this.checkArchiveContent(temp, expected);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDeleteFromAndAddToAr() throws Exception {
        ArchiveOutputStream out = null;
        ArchiveInputStream ais = null;
        File temp = null;
        try {
            ChangeSet changes = new ChangeSet();
            changes.delete("test2.xml");
            File file1 = ChangeSetTestCase.getFile("test.txt");
            ArArchiveEntry entry = new ArArchiveEntry("test.txt", file1.length());
            changes.add((ArchiveEntry)entry, (InputStream)new FileInputStream(file1));
            File input = ChangeSetTestCase.getFile("bla.ar");
            FileInputStream is = new FileInputStream(input);
            ais = this.factory.createArchiveInputStream("ar", (InputStream)is);
            temp = new File(this.dir, "bla.ar");
            out = this.factory.createArchiveOutputStream("ar", (OutputStream)new FileOutputStream(temp));
            ChangeSetPerformer performer = new ChangeSetPerformer(changes);
            performer.perform(ais, out);
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (ais != null) {
                ais.close();
            }
        }
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("test1.xml");
        expected.add("test.txt");
        this.checkArchiveContent(temp, expected);
    }

    public void testRenameAndDelete() throws Exception {
    }

    public void testAddMoveDelete() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAddToEmptyArchive() throws Exception {
        String archivename = "zip";
        File input = this.createEmptyArchive("zip");
        ArchiveOutputStream out = null;
        ArchiveInputStream ais = null;
        FileInputStream is = null;
        File result = File.createTempFile("test", ".zip");
        result.deleteOnExit();
        ChangeSet changes = new ChangeSet();
        try {
            is = new FileInputStream(input);
            ais = this.factory.createArchiveInputStream("zip", (InputStream)is);
            out = this.factory.createArchiveOutputStream("zip", (OutputStream)new FileOutputStream(result));
            File file1 = ChangeSetTestCase.getFile("test.txt");
            ZipArchiveEntry entry = new ZipArchiveEntry("bla/test.txt");
            changes.add((ArchiveEntry)entry, (InputStream)new FileInputStream(file1));
            this.archiveList.add("bla/test.txt");
            ChangeSetPerformer performer = new ChangeSetPerformer(changes);
            performer.perform(ais, out);
            ((InputStream)is).close();
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (ais != null) {
                ais.close();
            } else if (is != null) {
                ((InputStream)is).close();
            }
        }
        this.checkArchiveContent(result, (List<String>)this.archiveList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDeleteAddToOneFileArchive() throws Exception {
        String archivename = "zip";
        File input = this.createSingleEntryArchive("zip");
        ArchiveOutputStream out = null;
        ArchiveInputStream ais = null;
        FileInputStream is = null;
        File result = File.createTempFile("test", ".zip");
        result.deleteOnExit();
        ChangeSet changes = new ChangeSet();
        try {
            is = new FileInputStream(input);
            ais = this.factory.createArchiveInputStream("zip", (InputStream)is);
            out = this.factory.createArchiveOutputStream("zip", (OutputStream)new FileOutputStream(result));
            changes.delete("test1.xml");
            this.archiveListDelete("test1.xml");
            File file = ChangeSetTestCase.getFile("test.txt");
            ArchiveEntry entry = out.createArchiveEntry(file, "bla/test.txt");
            changes.add(entry, (InputStream)new FileInputStream(file));
            this.archiveList.add("bla/test.txt");
            ChangeSetPerformer performer = new ChangeSetPerformer(changes);
            performer.perform(ais, out);
            ((InputStream)is).close();
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (ais != null) {
                ais.close();
            } else if (is != null) {
                ((InputStream)is).close();
            }
        }
        this.checkArchiveContent(result, (List<String>)this.archiveList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAddDeleteToOneFileArchive() throws Exception {
        String archivename = "cpio";
        File input = this.createSingleEntryArchive("cpio");
        ArchiveOutputStream out = null;
        ArchiveInputStream ais = null;
        FileInputStream is = null;
        File result = File.createTempFile("test", ".cpio");
        result.deleteOnExit();
        ChangeSet changes = new ChangeSet();
        try {
            is = new FileInputStream(input);
            ais = this.factory.createArchiveInputStream("cpio", (InputStream)is);
            out = this.factory.createArchiveOutputStream("cpio", (OutputStream)new FileOutputStream(result));
            File file = ChangeSetTestCase.getFile("test.txt");
            ArchiveEntry entry = out.createArchiveEntry(file, "bla/test.txt");
            changes.add(entry, (InputStream)new FileInputStream(file));
            this.archiveList.add("bla/test.txt");
            changes.delete("test1.xml");
            this.archiveListDelete("test1.xml");
            ChangeSetPerformer performer = new ChangeSetPerformer(changes);
            performer.perform(ais, out);
            ((InputStream)is).close();
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (ais != null) {
                ais.close();
            } else if (is != null) {
                ((InputStream)is).close();
            }
        }
        this.checkArchiveContent(result, (List<String>)this.archiveList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAddAllreadyExistingWithReplaceTrue() throws Exception {
        String archivename = "zip";
        File input = this.createArchive("zip");
        ArchiveOutputStream out = null;
        ArchiveInputStream ais = null;
        File result = File.createTempFile("test", ".zip");
        result.deleteOnExit();
        try {
            FileInputStream is = new FileInputStream(input);
            ais = this.factory.createArchiveInputStream("zip", (InputStream)is);
            out = this.factory.createArchiveOutputStream("zip", (OutputStream)new FileOutputStream(result));
            ChangeSet changes = new ChangeSet();
            File file1 = ChangeSetTestCase.getFile("test.txt");
            ZipArchiveEntry entry = new ZipArchiveEntry("testdata/test1.xml");
            changes.add((ArchiveEntry)entry, (InputStream)new FileInputStream(file1), true);
            ChangeSetPerformer performer = new ChangeSetPerformer(changes);
            ChangeSetResults results = performer.perform(ais, out);
            ChangeSetTestCase.assertTrue((boolean)results.getAddedFromChangeSet().contains("testdata/test1.xml"));
            ((InputStream)is).close();
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (ais != null) {
                ais.close();
            }
        }
        this.checkArchiveContent(result, (List<String>)this.archiveList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAddAllreadyExistingWithReplaceFalse() throws Exception {
        String archivename = "zip";
        File input = this.createArchive("zip");
        ArchiveOutputStream out = null;
        ArchiveInputStream ais = null;
        File result = File.createTempFile("test", ".zip");
        result.deleteOnExit();
        try {
            FileInputStream is = new FileInputStream(input);
            ais = this.factory.createArchiveInputStream("zip", (InputStream)is);
            out = this.factory.createArchiveOutputStream("zip", (OutputStream)new FileOutputStream(result));
            ChangeSet changes = new ChangeSet();
            File file1 = ChangeSetTestCase.getFile("test.txt");
            ZipArchiveEntry entry = new ZipArchiveEntry("testdata/test1.xml");
            changes.add((ArchiveEntry)entry, (InputStream)new FileInputStream(file1), false);
            ChangeSetPerformer performer = new ChangeSetPerformer(changes);
            ChangeSetResults results = performer.perform(ais, out);
            ChangeSetTestCase.assertTrue((boolean)results.getAddedFromStream().contains("testdata/test1.xml"));
            ChangeSetTestCase.assertTrue((boolean)results.getAddedFromChangeSet().isEmpty());
            ChangeSetTestCase.assertTrue((boolean)results.getDeleted().isEmpty());
            ((InputStream)is).close();
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (ais != null) {
                ais.close();
            }
        }
        this.checkArchiveContent(result, (List<String>)this.archiveList);
    }
}

