/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors;

import junit.framework.TestCase;
import org.apache.commons.compress.compressors.bzip2.BZip2Utils;

public class BZip2UtilsTestCase
extends TestCase {
    public void testIsCompressedFilename() {
        BZip2UtilsTestCase.assertFalse((boolean)BZip2Utils.isCompressedFilename((String)""));
        BZip2UtilsTestCase.assertFalse((boolean)BZip2Utils.isCompressedFilename((String)".gz"));
        BZip2UtilsTestCase.assertTrue((boolean)BZip2Utils.isCompressedFilename((String)"x.tbz2"));
        BZip2UtilsTestCase.assertTrue((boolean)BZip2Utils.isCompressedFilename((String)"x.tbz"));
        BZip2UtilsTestCase.assertTrue((boolean)BZip2Utils.isCompressedFilename((String)"x.bz2"));
        BZip2UtilsTestCase.assertTrue((boolean)BZip2Utils.isCompressedFilename((String)"x.bz"));
        BZip2UtilsTestCase.assertFalse((boolean)BZip2Utils.isCompressedFilename((String)"xbz2"));
        BZip2UtilsTestCase.assertFalse((boolean)BZip2Utils.isCompressedFilename((String)"xbz"));
        BZip2UtilsTestCase.assertTrue((boolean)BZip2Utils.isCompressedFilename((String)"x.TBZ2"));
        BZip2UtilsTestCase.assertTrue((boolean)BZip2Utils.isCompressedFilename((String)"x.Tbz2"));
        BZip2UtilsTestCase.assertTrue((boolean)BZip2Utils.isCompressedFilename((String)"x.tbZ2"));
        BZip2UtilsTestCase.assertFalse((boolean)BZip2Utils.isCompressedFilename((String)"x.bz "));
        BZip2UtilsTestCase.assertFalse((boolean)BZip2Utils.isCompressedFilename((String)"x.tbz\n"));
        BZip2UtilsTestCase.assertFalse((boolean)BZip2Utils.isCompressedFilename((String)"x.tbz2.y"));
    }

    public void testGetUncompressedFilename() {
        BZip2UtilsTestCase.assertEquals((String)"", (String)BZip2Utils.getUncompressedFilename((String)""));
        BZip2UtilsTestCase.assertEquals((String)".bz2", (String)BZip2Utils.getUncompressedFilename((String)".bz2"));
        BZip2UtilsTestCase.assertEquals((String)"x.tar", (String)BZip2Utils.getUncompressedFilename((String)"x.tbz2"));
        BZip2UtilsTestCase.assertEquals((String)"x.tar", (String)BZip2Utils.getUncompressedFilename((String)"x.tbz"));
        BZip2UtilsTestCase.assertEquals((String)"x", (String)BZip2Utils.getUncompressedFilename((String)"x.bz2"));
        BZip2UtilsTestCase.assertEquals((String)"x", (String)BZip2Utils.getUncompressedFilename((String)"x.bz"));
        BZip2UtilsTestCase.assertEquals((String)"x.tar", (String)BZip2Utils.getUncompressedFilename((String)"x.TBZ2"));
        BZip2UtilsTestCase.assertEquals((String)"X.tar", (String)BZip2Utils.getUncompressedFilename((String)"X.Tbz2"));
        BZip2UtilsTestCase.assertEquals((String)"X.tar", (String)BZip2Utils.getUncompressedFilename((String)"X.tbZ2"));
        BZip2UtilsTestCase.assertEquals((String)"x.bz ", (String)BZip2Utils.getUncompressedFilename((String)"x.bz "));
        BZip2UtilsTestCase.assertEquals((String)"x.tbz\n", (String)BZip2Utils.getUncompressedFilename((String)"x.tbz\n"));
        BZip2UtilsTestCase.assertEquals((String)"x.tbz2.y", (String)BZip2Utils.getUncompressedFilename((String)"x.tbz2.y"));
    }

    public void testGetCompressedFilename() {
        BZip2UtilsTestCase.assertEquals((String)".bz2", (String)BZip2Utils.getCompressedFilename((String)""));
        BZip2UtilsTestCase.assertEquals((String)" .bz2", (String)BZip2Utils.getCompressedFilename((String)" "));
        BZip2UtilsTestCase.assertEquals((String)"x.bz2", (String)BZip2Utils.getCompressedFilename((String)"x"));
        BZip2UtilsTestCase.assertEquals((String)"X.bz2", (String)BZip2Utils.getCompressedFilename((String)"X"));
        BZip2UtilsTestCase.assertEquals((String)"x.tar.bz2", (String)BZip2Utils.getCompressedFilename((String)"x.tar"));
        BZip2UtilsTestCase.assertEquals((String)"x.tar.bz2", (String)BZip2Utils.getCompressedFilename((String)"x.TAR"));
    }
}

