/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.compress.compressors.snappy.FramedSnappyCompressorInputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.junit.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FramedSnappyTestCase
extends AbstractTestCase {
    public void testDefaultExtraction() throws Exception {
        this.testUnarchive(new AbstractTestCase.StreamWrapper<CompressorInputStream>(){

            @Override
            public CompressorInputStream wrap(InputStream is) throws IOException {
                return new FramedSnappyCompressorInputStream(is);
            }
        });
    }

    public void testDefaultExtractionViaFactory() throws Exception {
        this.testUnarchive(new AbstractTestCase.StreamWrapper<CompressorInputStream>(){

            @Override
            public CompressorInputStream wrap(InputStream is) throws Exception {
                return new CompressorStreamFactory().createCompressorInputStream("snappy-framed", is);
            }
        });
    }

    public void testDefaultExtractionViaFactoryAutodetection() throws Exception {
        this.testUnarchive(new AbstractTestCase.StreamWrapper<CompressorInputStream>(){

            @Override
            public CompressorInputStream wrap(InputStream is) throws Exception {
                return new CompressorStreamFactory().createCompressorInputStream(is);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testUnarchive(AbstractTestCase.StreamWrapper<CompressorInputStream> wrapper) throws Exception {
        File input = FramedSnappyTestCase.getFile("bla.tar.sz");
        File output = new File(this.dir, "bla.tar");
        FileInputStream is = new FileInputStream(input);
        try {
            CompressorInputStream in = wrapper.wrap(new BufferedInputStream(is));
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(output);
                IOUtils.copy((InputStream)in, (OutputStream)out);
                FramedSnappyTestCase.assertEquals((long)995L, (long)in.getBytesRead());
            }
            finally {
                if (out != null) {
                    out.close();
                }
                in.close();
            }
        }
        finally {
            is.close();
        }
        File original = FramedSnappyTestCase.getFile("bla.tar");
        FileInputStream written = new FileInputStream(output);
        try {
            FileInputStream orig = new FileInputStream(original);
            try {
                Assert.assertArrayEquals((byte[])IOUtils.toByteArray((InputStream)written), (byte[])IOUtils.toByteArray((InputStream)orig));
            }
            finally {
                orig.close();
            }
        }
        finally {
            written.close();
        }
    }
}

