/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorOutputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipParameters;
import org.apache.commons.compress.utils.IOUtils;
import org.junit.Assert;

public final class GZipTestCase
extends AbstractTestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGzipCreation() throws Exception {
        File input = GZipTestCase.getFile("test1.xml");
        File output = new File(this.dir, "test1.xml.gz");
        FileOutputStream out = new FileOutputStream(output);
        try {
            CompressorOutputStream cos = new CompressorStreamFactory().createCompressorOutputStream("gz", (OutputStream)out);
            try {
                IOUtils.copy((InputStream)new FileInputStream(input), (OutputStream)cos);
            }
            finally {
                cos.close();
            }
        }
        finally {
            ((OutputStream)out).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGzipUnarchive() throws Exception {
        File input = GZipTestCase.getFile("bla.tgz");
        File output = new File(this.dir, "bla.tar");
        FileInputStream is = new FileInputStream(input);
        try {
            CompressorInputStream in = new CompressorStreamFactory().createCompressorInputStream("gz", (InputStream)is);
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(output);
                IOUtils.copy((InputStream)in, (OutputStream)out);
            }
            finally {
                if (out != null) {
                    out.close();
                }
                in.close();
            }
        }
        finally {
            ((InputStream)is).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConcatenatedStreamsReadFirstOnly() throws Exception {
        File input = GZipTestCase.getFile("multiple.gz");
        FileInputStream is = new FileInputStream(input);
        try {
            CompressorInputStream in = new CompressorStreamFactory().createCompressorInputStream("gz", (InputStream)is);
            try {
                GZipTestCase.assertEquals((int)97, (int)in.read());
                GZipTestCase.assertEquals((int)-1, (int)in.read());
            }
            finally {
                in.close();
            }
        }
        finally {
            ((InputStream)is).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConcatenatedStreamsReadFully() throws Exception {
        File input = GZipTestCase.getFile("multiple.gz");
        FileInputStream is = new FileInputStream(input);
        try {
            GzipCompressorInputStream in = new GzipCompressorInputStream((InputStream)is, true);
            try {
                GZipTestCase.assertEquals((int)97, (int)in.read());
                GZipTestCase.assertEquals((int)98, (int)in.read());
                GZipTestCase.assertEquals((int)0, (int)in.available());
                GZipTestCase.assertEquals((int)-1, (int)in.read());
            }
            finally {
                in.close();
            }
        }
        finally {
            ((InputStream)is).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCorruptedInput() throws Exception {
        InputStream in = null;
        OutputStream out = null;
        CompressorInputStream cin = null;
        try {
            in = new FileInputStream(GZipTestCase.getFile("bla.tgz"));
            out = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)in, (OutputStream)out);
            in.close();
            out.close();
            byte[] data = ((ByteArrayOutputStream)out).toByteArray();
            in = new ByteArrayInputStream(data, 0, data.length - 1);
            cin = new CompressorStreamFactory().createCompressorInputStream("gz", in);
            out = new ByteArrayOutputStream();
            try {
                IOUtils.copy((InputStream)cin, (OutputStream)out);
                GZipTestCase.fail((String)"Expected an exception");
            }
            catch (IOException ioex) {
                // empty catch block
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (cin != null) {
                cin.close();
            }
            if (in != null) {
                in.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInteroperabilityWithGzipCompressorInputStream() throws Exception {
        byte[] content;
        FileInputStream fis = new FileInputStream(GZipTestCase.getFile("test3.xml"));
        try {
            content = IOUtils.toByteArray((InputStream)fis);
        }
        finally {
            fis.close();
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        GzipParameters parameters = new GzipParameters();
        parameters.setCompressionLevel(9);
        parameters.setOperatingSystem(3);
        parameters.setFilename("test3.xml");
        parameters.setComment("Test file");
        parameters.setModificationTime(System.currentTimeMillis());
        GzipCompressorOutputStream out = new GzipCompressorOutputStream((OutputStream)bout, parameters);
        out.write(content);
        out.flush();
        out.close();
        GzipCompressorInputStream in = new GzipCompressorInputStream((InputStream)new ByteArrayInputStream(bout.toByteArray()));
        byte[] content2 = IOUtils.toByteArray((InputStream)in);
        Assert.assertArrayEquals((String)"uncompressed content", (byte[])content, (byte[])content2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInteroperabilityWithGZIPInputStream() throws Exception {
        byte[] content;
        FileInputStream fis = new FileInputStream(GZipTestCase.getFile("test3.xml"));
        try {
            content = IOUtils.toByteArray((InputStream)fis);
        }
        finally {
            fis.close();
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        GzipParameters parameters = new GzipParameters();
        parameters.setCompressionLevel(9);
        parameters.setOperatingSystem(3);
        parameters.setFilename("test3.xml");
        parameters.setComment("Test file");
        parameters.setModificationTime(System.currentTimeMillis());
        GzipCompressorOutputStream out = new GzipCompressorOutputStream((OutputStream)bout, parameters);
        out.write(content);
        out.flush();
        out.close();
        GZIPInputStream in = new GZIPInputStream(new ByteArrayInputStream(bout.toByteArray()));
        byte[] content2 = IOUtils.toByteArray((InputStream)in);
        Assert.assertArrayEquals((String)"uncompressed content", (byte[])content, (byte[])content2);
    }

    public void testInvalidCompressionLevel() {
        GzipParameters parameters = new GzipParameters();
        try {
            parameters.setCompressionLevel(10);
            GZipTestCase.fail((String)"IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            parameters.setCompressionLevel(-5);
            GZipTestCase.fail((String)"IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testExtraFlags(int compressionLevel, int flag) throws Exception {
        byte[] content;
        FileInputStream fis = new FileInputStream(GZipTestCase.getFile("test3.xml"));
        try {
            content = IOUtils.toByteArray((InputStream)fis);
        }
        finally {
            fis.close();
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        GzipParameters parameters = new GzipParameters();
        parameters.setCompressionLevel(compressionLevel);
        GzipCompressorOutputStream out = new GzipCompressorOutputStream((OutputStream)bout, parameters);
        IOUtils.copy((InputStream)new ByteArrayInputStream(content), (OutputStream)out);
        out.flush();
        out.close();
        GZipTestCase.assertEquals((String)"extra flags (XFL)", (int)flag, (int)bout.toByteArray()[8]);
    }

    public void testExtraFlagsFastestCompression() throws Exception {
        this.testExtraFlags(1, 4);
    }

    public void testExtraFlagsBestCompression() throws Exception {
        this.testExtraFlags(9, 2);
    }

    public void testExtraFlagsDefaultCompression() throws Exception {
        this.testExtraFlags(-1, 0);
    }

    public void testOverWrite() throws Exception {
        GzipCompressorOutputStream out = new GzipCompressorOutputStream((OutputStream)new ByteArrayOutputStream());
        out.close();
        try {
            out.write(0);
            GZipTestCase.fail((String)"IOException expected");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMetadataRoundTrip() throws Exception {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        GzipParameters parameters = new GzipParameters();
        parameters.setCompressionLevel(9);
        parameters.setModificationTime(123456000L);
        parameters.setOperatingSystem(13);
        parameters.setFilename("test3.xml");
        parameters.setComment("Umlaute m\u00c3\u00b6glich?");
        GzipCompressorOutputStream out = new GzipCompressorOutputStream((OutputStream)bout, parameters);
        FileInputStream fis = new FileInputStream(GZipTestCase.getFile("test3.xml"));
        try {
            IOUtils.copy((InputStream)fis, (OutputStream)out);
        }
        finally {
            fis.close();
            out.close();
        }
        GzipCompressorInputStream input = new GzipCompressorInputStream((InputStream)new ByteArrayInputStream(bout.toByteArray()));
        input.close();
        GzipParameters readParams = input.getMetaData();
        GZipTestCase.assertEquals((int)9, (int)readParams.getCompressionLevel());
        GZipTestCase.assertEquals((long)123456000L, (long)readParams.getModificationTime());
        GZipTestCase.assertEquals((int)13, (int)readParams.getOperatingSystem());
        GZipTestCase.assertEquals((String)"test3.xml", (String)readParams.getFilename());
        GZipTestCase.assertEquals((String)"Umlaute m\u00c3\u00b6glich?", (String)readParams.getComment());
    }
}

