/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors;

import junit.framework.TestCase;
import org.apache.commons.compress.compressors.gzip.GzipUtils;

public class GzipUtilsTestCase
extends TestCase {
    public void testIsCompressedFilename() {
        GzipUtilsTestCase.assertFalse((boolean)GzipUtils.isCompressedFilename((String)""));
        GzipUtilsTestCase.assertFalse((boolean)GzipUtils.isCompressedFilename((String)".gz"));
        GzipUtilsTestCase.assertTrue((boolean)GzipUtils.isCompressedFilename((String)"x.tgz"));
        GzipUtilsTestCase.assertTrue((boolean)GzipUtils.isCompressedFilename((String)"x.taz"));
        GzipUtilsTestCase.assertTrue((boolean)GzipUtils.isCompressedFilename((String)"x.svgz"));
        GzipUtilsTestCase.assertTrue((boolean)GzipUtils.isCompressedFilename((String)"x.cpgz"));
        GzipUtilsTestCase.assertTrue((boolean)GzipUtils.isCompressedFilename((String)"x.wmz"));
        GzipUtilsTestCase.assertTrue((boolean)GzipUtils.isCompressedFilename((String)"x.emz"));
        GzipUtilsTestCase.assertTrue((boolean)GzipUtils.isCompressedFilename((String)"x.gz"));
        GzipUtilsTestCase.assertTrue((boolean)GzipUtils.isCompressedFilename((String)"x.z"));
        GzipUtilsTestCase.assertTrue((boolean)GzipUtils.isCompressedFilename((String)"x-gz"));
        GzipUtilsTestCase.assertTrue((boolean)GzipUtils.isCompressedFilename((String)"x-z"));
        GzipUtilsTestCase.assertTrue((boolean)GzipUtils.isCompressedFilename((String)"x_z"));
        GzipUtilsTestCase.assertFalse((boolean)GzipUtils.isCompressedFilename((String)"xxgz"));
        GzipUtilsTestCase.assertFalse((boolean)GzipUtils.isCompressedFilename((String)"xzz"));
        GzipUtilsTestCase.assertFalse((boolean)GzipUtils.isCompressedFilename((String)"xaz"));
        GzipUtilsTestCase.assertTrue((boolean)GzipUtils.isCompressedFilename((String)"x.SVGZ"));
        GzipUtilsTestCase.assertTrue((boolean)GzipUtils.isCompressedFilename((String)"x.Svgz"));
        GzipUtilsTestCase.assertTrue((boolean)GzipUtils.isCompressedFilename((String)"x.svGZ"));
        GzipUtilsTestCase.assertFalse((boolean)GzipUtils.isCompressedFilename((String)"x.wmz "));
        GzipUtilsTestCase.assertFalse((boolean)GzipUtils.isCompressedFilename((String)"x.wmz\n"));
        GzipUtilsTestCase.assertFalse((boolean)GzipUtils.isCompressedFilename((String)"x.wmz.y"));
    }

    public void testGetUncompressedFilename() {
        GzipUtilsTestCase.assertEquals((String)"", (String)GzipUtils.getUncompressedFilename((String)""));
        GzipUtilsTestCase.assertEquals((String)".gz", (String)GzipUtils.getUncompressedFilename((String)".gz"));
        GzipUtilsTestCase.assertEquals((String)"x.tar", (String)GzipUtils.getUncompressedFilename((String)"x.tgz"));
        GzipUtilsTestCase.assertEquals((String)"x.tar", (String)GzipUtils.getUncompressedFilename((String)"x.taz"));
        GzipUtilsTestCase.assertEquals((String)"x.svg", (String)GzipUtils.getUncompressedFilename((String)"x.svgz"));
        GzipUtilsTestCase.assertEquals((String)"x.cpio", (String)GzipUtils.getUncompressedFilename((String)"x.cpgz"));
        GzipUtilsTestCase.assertEquals((String)"x.wmf", (String)GzipUtils.getUncompressedFilename((String)"x.wmz"));
        GzipUtilsTestCase.assertEquals((String)"x.emf", (String)GzipUtils.getUncompressedFilename((String)"x.emz"));
        GzipUtilsTestCase.assertEquals((String)"x", (String)GzipUtils.getUncompressedFilename((String)"x.gz"));
        GzipUtilsTestCase.assertEquals((String)"x", (String)GzipUtils.getUncompressedFilename((String)"x.z"));
        GzipUtilsTestCase.assertEquals((String)"x", (String)GzipUtils.getUncompressedFilename((String)"x-gz"));
        GzipUtilsTestCase.assertEquals((String)"x", (String)GzipUtils.getUncompressedFilename((String)"x-z"));
        GzipUtilsTestCase.assertEquals((String)"x", (String)GzipUtils.getUncompressedFilename((String)"x_z"));
        GzipUtilsTestCase.assertEquals((String)"x.svg", (String)GzipUtils.getUncompressedFilename((String)"x.SVGZ"));
        GzipUtilsTestCase.assertEquals((String)"X.svg", (String)GzipUtils.getUncompressedFilename((String)"X.SVGZ"));
        GzipUtilsTestCase.assertEquals((String)"X.svg", (String)GzipUtils.getUncompressedFilename((String)"X.svGZ"));
        GzipUtilsTestCase.assertEquals((String)"x.wmz ", (String)GzipUtils.getUncompressedFilename((String)"x.wmz "));
        GzipUtilsTestCase.assertEquals((String)"x.wmz\n", (String)GzipUtils.getUncompressedFilename((String)"x.wmz\n"));
        GzipUtilsTestCase.assertEquals((String)"x.wmz.y", (String)GzipUtils.getUncompressedFilename((String)"x.wmz.y"));
    }

    public void testGetCompressedFilename() {
        GzipUtilsTestCase.assertEquals((String)".gz", (String)GzipUtils.getCompressedFilename((String)""));
        GzipUtilsTestCase.assertEquals((String)"x.gz", (String)GzipUtils.getCompressedFilename((String)"x"));
        GzipUtilsTestCase.assertEquals((String)"x.tgz", (String)GzipUtils.getCompressedFilename((String)"x.tar"));
        GzipUtilsTestCase.assertEquals((String)"x.svgz", (String)GzipUtils.getCompressedFilename((String)"x.svg"));
        GzipUtilsTestCase.assertEquals((String)"x.cpgz", (String)GzipUtils.getCompressedFilename((String)"x.cpio"));
        GzipUtilsTestCase.assertEquals((String)"x.wmz", (String)GzipUtils.getCompressedFilename((String)"x.wmf"));
        GzipUtilsTestCase.assertEquals((String)"x.emz", (String)GzipUtils.getCompressedFilename((String)"x.emf"));
        GzipUtilsTestCase.assertEquals((String)"x.svgz", (String)GzipUtils.getCompressedFilename((String)"x.SVG"));
        GzipUtilsTestCase.assertEquals((String)"X.svgz", (String)GzipUtils.getCompressedFilename((String)"X.SVG"));
        GzipUtilsTestCase.assertEquals((String)"X.svgz", (String)GzipUtils.getCompressedFilename((String)"X.svG"));
        GzipUtilsTestCase.assertEquals((String)"x.wmf .gz", (String)GzipUtils.getCompressedFilename((String)"x.wmf "));
        GzipUtilsTestCase.assertEquals((String)"x.wmf\n.gz", (String)GzipUtils.getCompressedFilename((String)"x.wmf\n"));
        GzipUtilsTestCase.assertEquals((String)"x.wmf.y.gz", (String)GzipUtils.getCompressedFilename((String)"x.wmf.y"));
    }
}

