/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorOutputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.compress.compressors.xz.XZCompressorInputStream;
import org.apache.commons.compress.utils.IOUtils;

public final class XZTestCase
extends AbstractTestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testXZCreation() throws Exception {
        long max = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getMax();
        System.out.println("XZTestCase: HeapMax=" + max + " bytes " + (double)max / 1048576.0 + " MB");
        File input = XZTestCase.getFile("test1.xml");
        File output = new File(this.dir, "test1.xml.xz");
        FileOutputStream out = new FileOutputStream(output);
        try {
            CompressorOutputStream cos = new CompressorStreamFactory().createCompressorOutputStream("xz", (OutputStream)out);
            try {
                IOUtils.copy((InputStream)new FileInputStream(input), (OutputStream)cos);
            }
            finally {
                cos.close();
            }
        }
        finally {
            ((OutputStream)out).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testXZUnarchive() throws Exception {
        File input = XZTestCase.getFile("bla.tar.xz");
        File output = new File(this.dir, "bla.tar");
        FileInputStream is = new FileInputStream(input);
        try {
            CompressorInputStream in = new CompressorStreamFactory().createCompressorInputStream("xz", (InputStream)is);
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(output);
                IOUtils.copy((InputStream)in, (OutputStream)out);
            }
            finally {
                if (out != null) {
                    out.close();
                }
                in.close();
            }
        }
        finally {
            ((InputStream)is).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConcatenatedStreamsReadFirstOnly() throws Exception {
        File input = XZTestCase.getFile("multiple.xz");
        FileInputStream is = new FileInputStream(input);
        try {
            CompressorInputStream in = new CompressorStreamFactory().createCompressorInputStream("xz", (InputStream)is);
            try {
                XZTestCase.assertEquals((int)97, (int)in.read());
                XZTestCase.assertEquals((int)-1, (int)in.read());
            }
            finally {
                in.close();
            }
        }
        finally {
            ((InputStream)is).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConcatenatedStreamsReadFully() throws Exception {
        File input = XZTestCase.getFile("multiple.xz");
        FileInputStream is = new FileInputStream(input);
        try {
            XZCompressorInputStream in = new XZCompressorInputStream((InputStream)is, true);
            try {
                XZTestCase.assertEquals((int)97, (int)in.read());
                XZTestCase.assertEquals((int)98, (int)in.read());
                XZTestCase.assertEquals((int)0, (int)in.available());
                XZTestCase.assertEquals((int)-1, (int)in.read());
            }
            finally {
                in.close();
            }
        }
        finally {
            ((InputStream)is).close();
        }
    }
}

