/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors;

import junit.framework.TestCase;
import org.apache.commons.compress.compressors.xz.XZUtils;

public class XZUtilsTestCase
extends TestCase {
    public void testIsCompressedFilename() {
        XZUtilsTestCase.assertFalse((boolean)XZUtils.isCompressedFilename((String)""));
        XZUtilsTestCase.assertFalse((boolean)XZUtils.isCompressedFilename((String)".xz"));
        XZUtilsTestCase.assertTrue((boolean)XZUtils.isCompressedFilename((String)"x.txz"));
        XZUtilsTestCase.assertTrue((boolean)XZUtils.isCompressedFilename((String)"x.xz"));
        XZUtilsTestCase.assertTrue((boolean)XZUtils.isCompressedFilename((String)"x-xz"));
        XZUtilsTestCase.assertFalse((boolean)XZUtils.isCompressedFilename((String)"xxgz"));
        XZUtilsTestCase.assertFalse((boolean)XZUtils.isCompressedFilename((String)"xzz"));
        XZUtilsTestCase.assertFalse((boolean)XZUtils.isCompressedFilename((String)"xaz"));
        XZUtilsTestCase.assertFalse((boolean)XZUtils.isCompressedFilename((String)"x.txz "));
        XZUtilsTestCase.assertFalse((boolean)XZUtils.isCompressedFilename((String)"x.txz\n"));
        XZUtilsTestCase.assertFalse((boolean)XZUtils.isCompressedFilename((String)"x.txz.y"));
    }

    public void testGetUncompressedFilename() {
        XZUtilsTestCase.assertEquals((String)"", (String)XZUtils.getUncompressedFilename((String)""));
        XZUtilsTestCase.assertEquals((String)".xz", (String)XZUtils.getUncompressedFilename((String)".xz"));
        XZUtilsTestCase.assertEquals((String)"x.tar", (String)XZUtils.getUncompressedFilename((String)"x.txz"));
        XZUtilsTestCase.assertEquals((String)"x", (String)XZUtils.getUncompressedFilename((String)"x.xz"));
        XZUtilsTestCase.assertEquals((String)"x", (String)XZUtils.getUncompressedFilename((String)"x-xz"));
        XZUtilsTestCase.assertEquals((String)"x.txz ", (String)XZUtils.getUncompressedFilename((String)"x.txz "));
        XZUtilsTestCase.assertEquals((String)"x.txz\n", (String)XZUtils.getUncompressedFilename((String)"x.txz\n"));
        XZUtilsTestCase.assertEquals((String)"x.txz.y", (String)XZUtils.getUncompressedFilename((String)"x.txz.y"));
    }

    public void testGetCompressedFilename() {
        XZUtilsTestCase.assertEquals((String)".xz", (String)XZUtils.getCompressedFilename((String)""));
        XZUtilsTestCase.assertEquals((String)"x.xz", (String)XZUtils.getCompressedFilename((String)"x"));
        XZUtilsTestCase.assertEquals((String)"x.txz", (String)XZUtils.getCompressedFilename((String)"x.tar"));
        XZUtilsTestCase.assertEquals((String)"x.wmf .xz", (String)XZUtils.getCompressedFilename((String)"x.wmf "));
        XZUtilsTestCase.assertEquals((String)"x.wmf\n.xz", (String)XZUtils.getCompressedFilename((String)"x.wmf\n"));
        XZUtilsTestCase.assertEquals((String)"x.wmf.y.xz", (String)XZUtils.getCompressedFilename((String)"x.wmf.y"));
    }
}

