/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.compress.compressors.z.ZCompressorInputStream;
import org.apache.commons.compress.utils.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ZTestCase
extends AbstractTestCase {
    public void testZUnarchive() throws Exception {
        this.testUnarchive(new AbstractTestCase.StreamWrapper<CompressorInputStream>(){

            @Override
            public CompressorInputStream wrap(InputStream is) throws IOException {
                return new ZCompressorInputStream(is);
            }
        });
    }

    public void testZUnarchiveViaFactory() throws Exception {
        this.testUnarchive(new AbstractTestCase.StreamWrapper<CompressorInputStream>(){

            @Override
            public CompressorInputStream wrap(InputStream is) throws Exception {
                return new CompressorStreamFactory().createCompressorInputStream("z", is);
            }
        });
    }

    public void testZUnarchiveViaAutoDetection() throws Exception {
        this.testUnarchive(new AbstractTestCase.StreamWrapper<CompressorInputStream>(){

            @Override
            public CompressorInputStream wrap(InputStream is) throws Exception {
                return new CompressorStreamFactory().createCompressorInputStream((InputStream)new BufferedInputStream(is));
            }
        });
    }

    public void testMatches() throws Exception {
        ZTestCase.assertFalse((boolean)ZCompressorInputStream.matches((byte[])new byte[]{1, 2, 3, 4}, (int)4));
        ZTestCase.assertFalse((boolean)ZCompressorInputStream.matches((byte[])new byte[]{31, 2, 3, 4}, (int)4));
        ZTestCase.assertFalse((boolean)ZCompressorInputStream.matches((byte[])new byte[]{1, -99, 3, 4}, (int)4));
        ZTestCase.assertFalse((boolean)ZCompressorInputStream.matches((byte[])new byte[]{31, -99, 3, 4}, (int)3));
        ZTestCase.assertTrue((boolean)ZCompressorInputStream.matches((byte[])new byte[]{31, -99, 3, 4}, (int)4));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testUnarchive(AbstractTestCase.StreamWrapper<CompressorInputStream> wrapper) throws Exception {
        File input = ZTestCase.getFile("bla.tar.Z");
        File output = new File(this.dir, "bla.tar");
        FileInputStream is = new FileInputStream(input);
        try {
            CompressorInputStream in = wrapper.wrap(is);
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(output);
                IOUtils.copy((InputStream)in, (OutputStream)out);
            }
            finally {
                if (out != null) {
                    out.close();
                }
                in.close();
            }
        }
        finally {
            ((InputStream)is).close();
        }
    }
}

