/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.snappy;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.snappy.FramedSnappyCompressorInputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.junit.Assert;

public final class FramedSnappyCompressorInputStreamTest
extends AbstractTestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMatches() throws IOException {
        FramedSnappyCompressorInputStreamTest.assertFalse((boolean)FramedSnappyCompressorInputStream.matches((byte[])new byte[10], (int)10));
        byte[] b = new byte[12];
        File input = FramedSnappyCompressorInputStreamTest.getFile("bla.tar.sz");
        FileInputStream in = new FileInputStream(input);
        try {
            IOUtils.readFully((InputStream)in, (byte[])b);
        }
        finally {
            in.close();
        }
        FramedSnappyCompressorInputStreamTest.assertFalse((boolean)FramedSnappyCompressorInputStream.matches((byte[])b, (int)9));
        FramedSnappyCompressorInputStreamTest.assertTrue((boolean)FramedSnappyCompressorInputStream.matches((byte[])b, (int)10));
        FramedSnappyCompressorInputStreamTest.assertTrue((boolean)FramedSnappyCompressorInputStream.matches((byte[])b, (int)12));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLoremIpsum() throws Exception {
        FileInputStream isSz = new FileInputStream(FramedSnappyCompressorInputStreamTest.getFile("lorem-ipsum.txt.sz"));
        File outputSz = new File(this.dir, "lorem-ipsum.1");
        File outputGz = new File(this.dir, "lorem-ipsum.2");
        try {
            FramedSnappyCompressorInputStream in = new FramedSnappyCompressorInputStream((InputStream)isSz);
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(outputSz);
                IOUtils.copy((InputStream)in, (OutputStream)out);
            }
            finally {
                if (out != null) {
                    out.close();
                }
                in.close();
            }
            FileInputStream isGz = new FileInputStream(FramedSnappyCompressorInputStreamTest.getFile("lorem-ipsum.txt.gz"));
            try {
                in = new GzipCompressorInputStream((InputStream)isGz);
                try {
                    out = new FileOutputStream(outputGz);
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                }
                finally {
                    if (out != null) {
                        out.close();
                    }
                    in.close();
                }
            }
            finally {
                isGz.close();
            }
        }
        finally {
            isSz.close();
        }
        FileInputStream sz = new FileInputStream(outputSz);
        try {
            FileInputStream gz = new FileInputStream(outputGz);
            try {
                Assert.assertArrayEquals((byte[])IOUtils.toByteArray((InputStream)sz), (byte[])IOUtils.toByteArray((InputStream)gz));
            }
            finally {
                gz.close();
            }
        }
        finally {
            sz.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRemainingChunkTypes() throws Exception {
        FileInputStream isSz = new FileInputStream(FramedSnappyCompressorInputStreamTest.getFile("mixed.txt.sz"));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            FramedSnappyCompressorInputStream in = new FramedSnappyCompressorInputStream((InputStream)isSz);
            IOUtils.copy((InputStream)in, (OutputStream)out);
            out.close();
        }
        finally {
            isSz.close();
        }
        Assert.assertArrayEquals((byte[])new byte[]{49, 50, 51, 52, 53, 54, 55, 56, 57, 53, 54, 55, 56, 57, 53, 54, 55, 56, 57, 53, 54, 55, 56, 57, 53, 54, 55, 56, 57, 10, 49, 50, 51, 52, 49, 50, 51, 52}, (byte[])out.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAvailable() throws Exception {
        FileInputStream isSz = new FileInputStream(FramedSnappyCompressorInputStreamTest.getFile("mixed.txt.sz"));
        try {
            FramedSnappyCompressorInputStream in = new FramedSnappyCompressorInputStream((InputStream)isSz);
            FramedSnappyCompressorInputStreamTest.assertEquals((int)0, (int)in.available());
            FramedSnappyCompressorInputStreamTest.assertEquals((int)49, (int)in.read());
            FramedSnappyCompressorInputStreamTest.assertEquals((int)3, (int)in.available());
            FramedSnappyCompressorInputStreamTest.assertEquals((int)3, (int)in.read(new byte[5], 0, 3));
            FramedSnappyCompressorInputStreamTest.assertEquals((int)53, (int)in.read());
            FramedSnappyCompressorInputStreamTest.assertEquals((int)4, (int)in.available());
            FramedSnappyCompressorInputStreamTest.assertEquals((int)4, (int)in.read(new byte[5], 0, 4));
            FramedSnappyCompressorInputStreamTest.assertEquals((int)53, (int)in.read());
            FramedSnappyCompressorInputStreamTest.assertEquals((int)19, (int)in.available());
            in.close();
        }
        finally {
            isSz.close();
        }
    }

    public void testUnskippableChunk() {
        byte[] input = new byte[]{-1, 6, 0, 0, 115, 78, 97, 80, 112, 89, 2, 2, 0, 0, 1, 1};
        try {
            FramedSnappyCompressorInputStream in = new FramedSnappyCompressorInputStream((InputStream)new ByteArrayInputStream(input));
            in.read();
            FramedSnappyCompressorInputStreamTest.fail((String)"expected an exception");
        }
        catch (IOException ex) {
            FramedSnappyCompressorInputStreamTest.assertTrue((ex.getMessage().indexOf("unskippable chunk") > -1 ? 1 : 0) != 0);
        }
    }

    public void testChecksumUnmasking() {
        this.testChecksumUnmasking(51031L);
        this.testChecksumUnmasking(4294952791L);
    }

    public void testChecksumUnmasking(long x) {
        FramedSnappyCompressorInputStreamTest.assertEquals((String)Long.toHexString(x), (String)Long.toHexString(FramedSnappyCompressorInputStream.unmask((long)this.mask(x))));
    }

    private long mask(long x) {
        return (x >>> 15 | x << 17) + 2726488792L & 0xFFFFFFFFL;
    }
}

