/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.utils.CountingInputStream;
import org.apache.commons.compress.utils.CountingOutputStream;
import org.junit.Assert;
import org.junit.Test;

public class CountingStreamTest {
    @Test
    public void output() throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        CountingOutputStream o = new CountingOutputStream((OutputStream)bos);
        o.write(1);
        Assert.assertEquals((long)1L, (long)o.getBytesWritten());
        o.write(new byte[]{2, 3});
        Assert.assertEquals((long)3L, (long)o.getBytesWritten());
        o.write(new byte[]{2, 3, 4, 5}, 2, 1);
        Assert.assertEquals((long)4L, (long)o.getBytesWritten());
        o.count(-1L);
        Assert.assertEquals((long)4L, (long)o.getBytesWritten());
        o.count(-2L);
        Assert.assertEquals((long)2L, (long)o.getBytesWritten());
        o.close();
        Assert.assertArrayEquals((byte[])new byte[]{1, 2, 3, 4}, (byte[])bos.toByteArray());
    }

    @Test
    public void input() throws Exception {
        ByteArrayInputStream bis = new ByteArrayInputStream(new byte[]{1, 2, 3, 4});
        CountingInputStream i = new CountingInputStream((InputStream)bis);
        Assert.assertEquals((long)1L, (long)i.read());
        Assert.assertEquals((long)1L, (long)i.getBytesRead());
        byte[] b = new byte[2];
        i.read(b);
        Assert.assertEquals((long)3L, (long)i.getBytesRead());
        Assert.assertArrayEquals((byte[])new byte[]{2, 3}, (byte[])b);
        b = new byte[3];
        i.read(b, 1, 1);
        Assert.assertArrayEquals((byte[])new byte[]{0, 4, 0}, (byte[])b);
        Assert.assertEquals((long)4L, (long)i.getBytesRead());
        i.count(-1L);
        Assert.assertEquals((long)4L, (long)i.getBytesRead());
        i.count(-2L);
        Assert.assertEquals((long)2L, (long)i.getBytesRead());
        i.close();
    }
}

