/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.utils;

import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.junit.Assert;
import org.junit.Test;

public class IOUtilsTest {
    @Test
    public void skipUsingSkip() throws Exception {
        this.skip(new StreamWrapper(){

            public InputStream wrap(InputStream toWrap) {
                return toWrap;
            }
        });
    }

    @Test
    public void skipUsingRead() throws Exception {
        this.skip(new StreamWrapper(){

            public InputStream wrap(InputStream toWrap) {
                return new FilterInputStream(toWrap){

                    public long skip(long s) {
                        return 0L;
                    }
                };
            }
        });
    }

    @Test
    public void skipUsingSkipAndRead() throws Exception {
        this.skip(new StreamWrapper(){

            public InputStream wrap(final InputStream toWrap) {
                return new FilterInputStream(toWrap){
                    boolean skipped;

                    public long skip(long s) throws IOException {
                        if (!this.skipped) {
                            toWrap.skip(5L);
                            this.skipped = true;
                            return 5L;
                        }
                        return 0L;
                    }
                };
            }
        });
    }

    private void skip(StreamWrapper wrapper) throws Exception {
        ByteArrayInputStream in = new ByteArrayInputStream(new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11});
        InputStream sut = wrapper.wrap(in);
        Assert.assertEquals((long)10L, (long)IOUtils.skip((InputStream)sut, (long)10L));
        Assert.assertEquals((long)11L, (long)sut.read());
    }

    private static interface StreamWrapper {
        public InputStream wrap(InputStream var1);
    }
}

