/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging.jdk14;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import junit.framework.Test;
import org.apache.commons.logging.DummyException;
import org.apache.commons.logging.PathableClassLoader;
import org.apache.commons.logging.PathableTestSuite;
import org.apache.commons.logging.jdk14.DefaultConfigTestCase;
import org.apache.commons.logging.jdk14.TestHandler;

public class CustomConfigTestCase
extends DefaultConfigTestCase {
    protected static final String HANDLER_NAME = "org.apache.commons.logging.jdk14.TestHandler";
    protected TestHandler handler = null;
    protected Handler[] handlers = null;
    protected Logger logger = null;
    protected LogManager manager = null;
    protected Level[] testLevels = new Level[]{Level.FINE, Level.INFO, Level.WARNING, Level.SEVERE, Level.SEVERE};
    protected String[] testMessages = new String[]{"debug", "info", "warn", "error", "fatal"};
    static /* synthetic */ Class class$org$apache$commons$logging$jdk14$CustomConfigAPITestCase;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class class$junit$framework$Test;
    static /* synthetic */ Class class$org$apache$commons$logging$jdk14$CustomConfigTestCase;

    public CustomConfigTestCase(String name) {
        super(name);
    }

    protected static byte[] readClass(String name, ClassLoader srcCL) throws Exception {
        int read;
        String resName = name.replace('.', '/') + ".class";
        System.err.println("Trying to load resource [" + resName + "]");
        InputStream is = srcCL.getResourceAsStream(resName);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        System.err.println("Reading resource [" + resName + "]");
        byte[] buf = new byte[1000];
        while ((read = is.read(buf)) > 0) {
            baos.write(buf, 0, read);
        }
        is.close();
        return baos.toByteArray();
    }

    protected static void loadTestHandler(String className, ClassLoader targetCL) {
        try {
            targetCL.loadClass(className);
            return;
        }
        catch (ClassNotFoundException ex) {
            try {
                ClassLoader srcCL = (class$org$apache$commons$logging$jdk14$CustomConfigAPITestCase == null ? (class$org$apache$commons$logging$jdk14$CustomConfigAPITestCase = CustomConfigTestCase.class$("org.apache.commons.logging.jdk14.CustomConfigAPITestCase")) : class$org$apache$commons$logging$jdk14$CustomConfigAPITestCase).getClassLoader();
                byte[] classData = CustomConfigTestCase.readClass(className, srcCL);
                Class[] params = new Class[]{class$java$lang$String == null ? (class$java$lang$String = CustomConfigTestCase.class$("java.lang.String")) : class$java$lang$String, classData.getClass(), Integer.TYPE, Integer.TYPE};
                Method m = (class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = CustomConfigTestCase.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader).getDeclaredMethod("defineClass", params);
                Object[] args = new Object[]{className, classData, new Integer(0), new Integer(classData.length)};
                m.setAccessible(true);
                m.invoke((Object)targetCL, args);
            }
            catch (Exception e) {
                e.printStackTrace();
                CustomConfigTestCase.fail((String)("Unable to load class " + className));
            }
            return;
        }
    }

    public void setUp() throws Exception {
        this.setUpManager("org/apache/commons/logging/jdk14/CustomConfig.properties");
        this.setUpLogger(((Object)((Object)this)).getClass().getName());
        this.setUpHandlers();
        this.setUpFactory();
        this.setUpLog(((Object)((Object)this)).getClass().getName());
    }

    public static Test suite() throws Exception {
        PathableClassLoader cl = new PathableClassLoader(null);
        cl.useExplicitLoader("junit.", (class$junit$framework$Test == null ? (class$junit$framework$Test = CustomConfigTestCase.class$("junit.framework.Test")) : class$junit$framework$Test).getClassLoader());
        ClassLoader scl = ClassLoader.getSystemClassLoader();
        CustomConfigTestCase.loadTestHandler(HANDLER_NAME, scl);
        cl.useExplicitLoader(HANDLER_NAME, scl);
        cl.addLogicalLib("commons-logging");
        cl.addLogicalLib("testclasses");
        Class<?> testClass = cl.loadClass((class$org$apache$commons$logging$jdk14$CustomConfigTestCase == null ? (class$org$apache$commons$logging$jdk14$CustomConfigTestCase = CustomConfigTestCase.class$("org.apache.commons.logging.jdk14.CustomConfigTestCase")) : class$org$apache$commons$logging$jdk14$CustomConfigTestCase).getName());
        return new PathableTestSuite(testClass, cl);
    }

    public void tearDown() {
        super.tearDown();
        this.handlers = null;
        this.logger = null;
        this.manager = null;
    }

    public void testExceptionMessages() throws Exception {
        this.logExceptionMessages();
        this.checkLogRecords(true);
    }

    public void testPlainMessages() throws Exception {
        this.logPlainMessages();
        this.checkLogRecords(false);
    }

    public void testPristineHandlers() {
        CustomConfigTestCase.assertNotNull((Object)this.handlers);
        CustomConfigTestCase.assertEquals((int)1, (int)this.handlers.length);
        CustomConfigTestCase.assertTrue((boolean)(this.handlers[0] instanceof TestHandler));
        CustomConfigTestCase.assertNotNull((Object)this.handler);
    }

    public void testPristineLogger() {
        CustomConfigTestCase.assertNotNull((String)"Logger exists", (Object)this.logger);
        CustomConfigTestCase.assertEquals((String)"Logger name", (String)((Object)((Object)this)).getClass().getName(), (String)this.logger.getName());
        CustomConfigTestCase.assertTrue((boolean)this.logger.isLoggable(Level.SEVERE));
        CustomConfigTestCase.assertTrue((boolean)this.logger.isLoggable(Level.WARNING));
        CustomConfigTestCase.assertTrue((boolean)this.logger.isLoggable(Level.INFO));
        CustomConfigTestCase.assertTrue((boolean)this.logger.isLoggable(Level.CONFIG));
        CustomConfigTestCase.assertTrue((boolean)this.logger.isLoggable(Level.FINE));
        CustomConfigTestCase.assertTrue((!this.logger.isLoggable(Level.FINER) ? 1 : 0) != 0);
        CustomConfigTestCase.assertTrue((!this.logger.isLoggable(Level.FINEST) ? 1 : 0) != 0);
    }

    public void testSerializable() throws Exception {
        super.testSerializable();
        this.testExceptionMessages();
    }

    protected void checkLog() {
        CustomConfigTestCase.assertNotNull((String)"Log exists", (Object)this.log);
        CustomConfigTestCase.assertEquals((String)"Log class", (String)"org.apache.commons.logging.impl.Jdk14Logger", (String)this.log.getClass().getName());
        CustomConfigTestCase.assertTrue((boolean)this.log.isFatalEnabled());
        CustomConfigTestCase.assertTrue((boolean)this.log.isErrorEnabled());
        CustomConfigTestCase.assertTrue((boolean)this.log.isWarnEnabled());
        CustomConfigTestCase.assertTrue((boolean)this.log.isInfoEnabled());
        CustomConfigTestCase.assertTrue((boolean)this.log.isDebugEnabled());
        CustomConfigTestCase.assertTrue((!this.log.isTraceEnabled() ? 1 : 0) != 0);
    }

    protected void checkLogRecords(boolean thrown) {
        Iterator records = this.handler.records();
        for (int i = 0; i < this.testMessages.length; ++i) {
            CustomConfigTestCase.assertTrue((boolean)records.hasNext());
            LogRecord record = (LogRecord)records.next();
            CustomConfigTestCase.assertEquals((String)"LogRecord level", (Object)this.testLevels[i], (Object)record.getLevel());
            CustomConfigTestCase.assertEquals((String)"LogRecord message", (String)this.testMessages[i], (String)record.getMessage());
            CustomConfigTestCase.assertTrue((String)"LogRecord class", (boolean)record.getSourceClassName().startsWith("org.apache.commons.logging.jdk14.CustomConfig"));
            if (thrown) {
                CustomConfigTestCase.assertEquals((String)"LogRecord method", (String)"logExceptionMessages", (String)record.getSourceMethodName());
            } else {
                CustomConfigTestCase.assertEquals((String)"LogRecord method", (String)"logPlainMessages", (String)record.getSourceMethodName());
            }
            if (thrown) {
                CustomConfigTestCase.assertNotNull((String)"LogRecord thrown", (Object)record.getThrown());
                CustomConfigTestCase.assertTrue((String)"LogRecord thrown type", (boolean)(record.getThrown() instanceof DummyException));
                continue;
            }
            CustomConfigTestCase.assertNull((String)"LogRecord thrown", (Object)record.getThrown());
        }
        CustomConfigTestCase.assertTrue((!records.hasNext() ? 1 : 0) != 0);
        this.handler.flush();
    }

    protected void logExceptionMessages() {
        DummyException t = new DummyException();
        this.log.trace((Object)"trace", (Throwable)t);
        this.log.debug((Object)"debug", (Throwable)t);
        this.log.info((Object)"info", (Throwable)t);
        this.log.warn((Object)"warn", (Throwable)t);
        this.log.error((Object)"error", (Throwable)t);
        this.log.fatal((Object)"fatal", (Throwable)t);
    }

    protected void logPlainMessages() {
        this.log.trace((Object)"trace");
        this.log.debug((Object)"debug");
        this.log.info((Object)"info");
        this.log.warn((Object)"warn");
        this.log.error((Object)"error");
        this.log.fatal((Object)"fatal");
    }

    protected void setUpHandlers() throws Exception {
        Logger parent = this.logger;
        while (parent.getParent() != null) {
            parent = parent.getParent();
        }
        this.handlers = parent.getHandlers();
        CustomConfigTestCase.assertNotNull((String)"No Handlers defined for JDK14 logging", (Object)this.handlers);
        CustomConfigTestCase.assertEquals((String)"Unexpected number of handlers for JDK14 logging", (int)1, (int)this.handlers.length);
        CustomConfigTestCase.assertNotNull((String)"Handler is null", (Object)this.handlers[0]);
        CustomConfigTestCase.assertTrue((String)"Handler not of expected type", (boolean)(this.handlers[0] instanceof TestHandler));
        this.handler = (TestHandler)this.handlers[0];
    }

    protected void setUpLogger(String name) throws Exception {
        this.logger = Logger.getLogger(name);
    }

    protected void setUpManager(String config) throws Exception {
        this.manager = LogManager.getLogManager();
        InputStream is = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(config);
        this.manager.readConfiguration(is);
        is.close();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

