/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging.security;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AllPermission;
import java.util.Hashtable;
import junit.framework.Test;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.PathableClassLoader;
import org.apache.commons.logging.PathableTestSuite;
import org.apache.commons.logging.security.MockSecurityManager;

public class SecurityAllowedTestCase
extends TestCase {
    private SecurityManager oldSecMgr;
    static /* synthetic */ Class class$junit$framework$Test;
    static /* synthetic */ Class class$org$apache$commons$logging$security$SecurityAllowedTestCase$CustomHashtable;
    static /* synthetic */ Class class$java$lang$Class;

    public static Test suite() throws Exception {
        PathableClassLoader parent = new PathableClassLoader(null);
        parent.useExplicitLoader("junit.", (class$junit$framework$Test == null ? (class$junit$framework$Test = SecurityAllowedTestCase.class$("junit.framework.Test")) : class$junit$framework$Test).getClassLoader());
        parent.addLogicalLib("commons-logging");
        parent.addLogicalLib("testclasses");
        Class<?> testClass = parent.loadClass("org.apache.commons.logging.security.SecurityAllowedTestCase");
        return new PathableTestSuite(testClass, parent);
    }

    public void setUp() {
        this.oldSecMgr = System.getSecurityManager();
    }

    public void tearDown() {
        System.setSecurityManager(this.oldSecMgr);
    }

    public void testAllAllowed() {
        System.setProperty("org.apache.commons.logging.LogFactory.HashtableImpl", (class$org$apache$commons$logging$security$SecurityAllowedTestCase$CustomHashtable == null ? (class$org$apache$commons$logging$security$SecurityAllowedTestCase$CustomHashtable = SecurityAllowedTestCase.class$("org.apache.commons.logging.security.SecurityAllowedTestCase$CustomHashtable")) : class$org$apache$commons$logging$security$SecurityAllowedTestCase$CustomHashtable).getName());
        MockSecurityManager mySecurityManager = new MockSecurityManager();
        mySecurityManager.addPermission(new AllPermission());
        System.setSecurityManager(mySecurityManager);
        try {
            Class<?> c = ((Object)((Object)this)).getClass().getClassLoader().loadClass("org.apache.commons.logging.LogFactory");
            Method m = c.getMethod("getLog", class$java$lang$Class == null ? (class$java$lang$Class = SecurityAllowedTestCase.class$("java.lang.Class")) : class$java$lang$Class);
            Log log = (Log)m.invoke(null, ((Object)((Object)this)).getClass());
            int untrustedCodeCount = mySecurityManager.getUntrustedCodeCount();
            log.info((Object)"testing");
            System.setSecurityManager(null);
            Field factoryField = c.getDeclaredField("factories");
            factoryField.setAccessible(true);
            Object factoryTable = factoryField.get(null);
            SecurityAllowedTestCase.assertNotNull((Object)factoryTable);
            SecurityAllowedTestCase.assertEquals((String)(class$org$apache$commons$logging$security$SecurityAllowedTestCase$CustomHashtable == null ? (class$org$apache$commons$logging$security$SecurityAllowedTestCase$CustomHashtable = SecurityAllowedTestCase.class$("org.apache.commons.logging.security.SecurityAllowedTestCase$CustomHashtable")) : class$org$apache$commons$logging$security$SecurityAllowedTestCase$CustomHashtable).getName(), (String)factoryTable.getClass().getName());
            SecurityAllowedTestCase.assertEquals((String)"Untrusted code count", (int)untrustedCodeCount, (int)mySecurityManager.getUntrustedCodeCount());
        }
        catch (Throwable t) {
            System.setSecurityManager(this.oldSecMgr);
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            t.printStackTrace(pw);
            SecurityAllowedTestCase.fail((String)("Unexpected exception:" + t.getMessage() + ":" + sw.toString()));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class CustomHashtable
    extends Hashtable {
        private static final long serialVersionUID = 8941017300059246720L;
    }
}

