/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http;

import org.apache.http.ConnectionClosedException;
import org.apache.http.HttpException;
import org.apache.http.MethodNotSupportedException;
import org.apache.http.NoHttpResponseException;
import org.apache.http.ProtocolException;
import org.apache.http.UnsupportedHttpVersionException;
import org.junit.Assert;
import org.junit.Test;

public class TestHttpExceptions {
    private static final String CLEAN_MESSAGE = "[0x00]Hello[0x06][0x07][0x08][0x09][0x0a][0x0b][0x0c][0x0d][0x0e][0x0f]World";
    private static String nonPrintableMessage = String.valueOf(new char[]{'\u0001', 'H', 'e', 'l', 'l', 'o', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\u0000', 'W', 'o', 'r', 'l', 'd'});

    @Test
    public void testConstructor() {
        Exception cause = new Exception();
        new HttpException();
        new HttpException("Oppsie");
        new HttpException("Oppsie", (Throwable)cause);
        new ProtocolException();
        new ProtocolException("Oppsie");
        new ProtocolException("Oppsie", (Throwable)cause);
        new NoHttpResponseException("Oppsie");
        new ConnectionClosedException("Oppsie");
        new MethodNotSupportedException("Oppsie");
        new MethodNotSupportedException("Oppsie", (Throwable)cause);
        new UnsupportedHttpVersionException();
        new UnsupportedHttpVersionException("Oppsie");
    }

    @Test
    public void testNonPrintableCharactersInConnectionClosedException() {
        Assert.assertEquals((Object)CLEAN_MESSAGE, (Object)new ConnectionClosedException(nonPrintableMessage).getMessage());
    }

    @Test
    public void testNonPrintableCharactersInHttpException() {
        Assert.assertEquals((Object)CLEAN_MESSAGE, (Object)new HttpException(nonPrintableMessage).getMessage());
    }

    @Test
    public void testNonPrintableCharactersInMethodNotSupportedException() {
        Assert.assertEquals((Object)CLEAN_MESSAGE, (Object)new MethodNotSupportedException(nonPrintableMessage).getMessage());
    }

    @Test
    public void testNonPrintableCharactersInNoHttpResponseException() {
        Assert.assertEquals((Object)CLEAN_MESSAGE, (Object)new NoHttpResponseException(nonPrintableMessage).getMessage());
    }

    @Test
    public void testNonPrintableCharactersInProtocolException() {
        Assert.assertEquals((Object)CLEAN_MESSAGE, (Object)new ProtocolException(nonPrintableMessage).getMessage());
    }

    @Test
    public void testNonPrintableCharactersInUnsupportedHttpVersionException() {
        Assert.assertEquals((Object)CLEAN_MESSAGE, (Object)new UnsupportedHttpVersionException(nonPrintableMessage).getMessage());
    }
}

