/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import org.apache.http.HttpHost;
import org.junit.Assert;
import org.junit.Test;

public class TestHttpHost {
    @Test
    public void testConstructor() {
        HttpHost host1 = new HttpHost("somehost");
        Assert.assertEquals((Object)"somehost", (Object)host1.getHostName());
        Assert.assertEquals((long)-1L, (long)host1.getPort());
        Assert.assertEquals((Object)"http", (Object)host1.getSchemeName());
        HttpHost host2 = new HttpHost("somehost", 8080);
        Assert.assertEquals((Object)"somehost", (Object)host2.getHostName());
        Assert.assertEquals((long)8080L, (long)host2.getPort());
        Assert.assertEquals((Object)"http", (Object)host2.getSchemeName());
        HttpHost host3 = new HttpHost("somehost", -1);
        Assert.assertEquals((Object)"somehost", (Object)host3.getHostName());
        Assert.assertEquals((long)-1L, (long)host3.getPort());
        Assert.assertEquals((Object)"http", (Object)host3.getSchemeName());
        HttpHost host4 = new HttpHost("somehost", 443, "https");
        Assert.assertEquals((Object)"somehost", (Object)host4.getHostName());
        Assert.assertEquals((long)443L, (long)host4.getPort());
        Assert.assertEquals((Object)"https", (Object)host4.getSchemeName());
        try {
            new HttpHost((String)null, -1, null);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            new HttpHost("   ", -1, null);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            new HttpHost((InetAddress)null, -1, null);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
    }

    @Test
    public void testHashCode() throws Exception {
        HttpHost host1 = new HttpHost("somehost", 8080, "http");
        HttpHost host2 = new HttpHost("somehost", 80, "http");
        HttpHost host3 = new HttpHost("someotherhost", 8080, "http");
        HttpHost host4 = new HttpHost("somehost", 80, "http");
        HttpHost host5 = new HttpHost("SomeHost", 80, "http");
        HttpHost host6 = new HttpHost("SomeHost", 80, "myhttp");
        HttpHost host7 = new HttpHost(InetAddress.getByAddress("127.0.0.1", new byte[]{127, 0, 0, 1}), 80, "http");
        HttpHost host8 = new HttpHost("127.0.0.1", 80, "http");
        HttpHost host9 = new HttpHost(InetAddress.getByAddress("somehost", new byte[]{127, 0, 0, 1}), 80, "http");
        HttpHost host10 = new HttpHost(InetAddress.getByAddress(new byte[]{127, 0, 0, 1}), "somehost", 80, "http");
        HttpHost host11 = new HttpHost(InetAddress.getByAddress("someotherhost", new byte[]{127, 0, 0, 1}), 80, "http");
        Assert.assertTrue((host1.hashCode() == host1.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((host1.hashCode() != host2.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((host1.hashCode() != host3.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((host2.hashCode() == host4.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((host2.hashCode() == host5.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((host5.hashCode() != host6.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((host7.hashCode() != host8.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((host8.hashCode() != host9.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((host9.hashCode() == host10.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((host10.hashCode() != host11.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((host9.hashCode() != host11.hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void testEquals() throws Exception {
        HttpHost host1 = new HttpHost("somehost", 8080, "http");
        HttpHost host2 = new HttpHost("somehost", 80, "http");
        HttpHost host3 = new HttpHost("someotherhost", 8080, "http");
        HttpHost host4 = new HttpHost("somehost", 80, "http");
        HttpHost host5 = new HttpHost("SomeHost", 80, "http");
        HttpHost host6 = new HttpHost("SomeHost", 80, "myhttp");
        HttpHost host7 = new HttpHost(InetAddress.getByAddress("127.0.0.1", new byte[]{127, 0, 0, 1}), 80, "http");
        HttpHost host8 = new HttpHost("127.0.0.1", 80, "http");
        HttpHost host9 = new HttpHost(InetAddress.getByAddress("somehost", new byte[]{127, 0, 0, 1}), 80, "http");
        HttpHost host10 = new HttpHost(InetAddress.getByAddress(new byte[]{127, 0, 0, 1}), "somehost", 80, "http");
        HttpHost host11 = new HttpHost(InetAddress.getByAddress("someotherhost", new byte[]{127, 0, 0, 1}), 80, "http");
        Assert.assertTrue((boolean)host1.equals((Object)host1));
        Assert.assertFalse((boolean)host1.equals((Object)host2));
        Assert.assertFalse((boolean)host1.equals((Object)host3));
        Assert.assertTrue((boolean)host2.equals((Object)host4));
        Assert.assertTrue((boolean)host2.equals((Object)host5));
        Assert.assertFalse((boolean)host5.equals((Object)host6));
        Assert.assertFalse((boolean)host7.equals((Object)host8));
        Assert.assertTrue((!host7.equals((Object)host9) ? 1 : 0) != 0);
        Assert.assertFalse((boolean)host1.equals(null));
        Assert.assertFalse((boolean)host1.equals((Object)"http://somehost"));
        Assert.assertFalse((boolean)host9.equals((Object)"http://somehost"));
        Assert.assertFalse((boolean)host8.equals((Object)host9));
        Assert.assertTrue((boolean)host9.equals((Object)host10));
        Assert.assertFalse((boolean)host9.equals((Object)host11));
    }

    @Test
    public void testToString() throws Exception {
        HttpHost host1 = new HttpHost("somehost");
        Assert.assertEquals((Object)"http://somehost", (Object)host1.toString());
        HttpHost host2 = new HttpHost("somehost", -1);
        Assert.assertEquals((Object)"http://somehost", (Object)host2.toString());
        HttpHost host3 = new HttpHost("somehost", -1);
        Assert.assertEquals((Object)"http://somehost", (Object)host3.toString());
        HttpHost host4 = new HttpHost("somehost", 8888);
        Assert.assertEquals((Object)"http://somehost:8888", (Object)host4.toString());
        HttpHost host5 = new HttpHost("somehost", -1, "myhttp");
        Assert.assertEquals((Object)"myhttp://somehost", (Object)host5.toString());
        HttpHost host6 = new HttpHost("somehost", 80, "myhttp");
        Assert.assertEquals((Object)"myhttp://somehost:80", (Object)host6.toString());
        HttpHost host7 = new HttpHost(InetAddress.getByAddress("127.0.0.1", new byte[]{127, 0, 0, 1}), 80, "http");
        Assert.assertEquals((Object)"http://127.0.0.1:80", (Object)host7.toString());
        HttpHost host9 = new HttpHost(InetAddress.getByAddress("somehost", new byte[]{127, 0, 0, 1}), 80, "http");
        Assert.assertEquals((Object)"http://somehost:80", (Object)host9.toString());
    }

    @Test
    public void testToHostString() {
        HttpHost host1 = new HttpHost("somehost");
        Assert.assertEquals((Object)"somehost", (Object)host1.toHostString());
        HttpHost host2 = new HttpHost("somehost");
        Assert.assertEquals((Object)"somehost", (Object)host2.toHostString());
        HttpHost host3 = new HttpHost("somehost", -1);
        Assert.assertEquals((Object)"somehost", (Object)host3.toHostString());
        HttpHost host4 = new HttpHost("somehost", 8888);
        Assert.assertEquals((Object)"somehost:8888", (Object)host4.toHostString());
    }

    @Test
    public void testCloning() throws Exception {
        HttpHost orig = new HttpHost("somehost", 8080, "https");
        HttpHost clone = (HttpHost)orig.clone();
        Assert.assertEquals((Object)orig, (Object)clone);
    }

    @Test
    public void testSerialization() throws Exception {
        HttpHost orig = new HttpHost("somehost", 8080, "https");
        ByteArrayOutputStream outbuffer = new ByteArrayOutputStream();
        ObjectOutputStream outStream = new ObjectOutputStream(outbuffer);
        outStream.writeObject(orig);
        outStream.close();
        byte[] raw = outbuffer.toByteArray();
        ByteArrayInputStream inBuffer = new ByteArrayInputStream(raw);
        ObjectInputStream inStream = new ObjectInputStream(inBuffer);
        HttpHost clone = (HttpHost)inStream.readObject();
        Assert.assertEquals((Object)orig, (Object)clone);
    }

    @Test
    public void testCreateFromString() throws Exception {
        Assert.assertEquals((Object)new HttpHost("somehost", 8080, "https"), (Object)HttpHost.create((String)"https://somehost:8080"));
        Assert.assertEquals((Object)new HttpHost("somehost", 8080, "https"), (Object)HttpHost.create((String)"HttpS://SomeHost:8080"));
        Assert.assertEquals((Object)new HttpHost("somehost", 1234, null), (Object)HttpHost.create((String)"somehost:1234"));
        Assert.assertEquals((Object)new HttpHost("somehost", -1, null), (Object)HttpHost.create((String)"somehost"));
    }

    @Test
    public void testCreateFromStringInvalid() throws Exception {
        try {
            HttpHost.create(null);
            Assert.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            HttpHost.create((String)" host ");
            Assert.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            HttpHost.create((String)"host :8080");
            Assert.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            HttpHost.create((String)"");
            Assert.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

