/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.junit.Assert;
import org.junit.Test;

public class TestHttpVersion {
    @Test
    public void testHttpVersionInvalidConstructorInput() throws Exception {
        try {
            new HttpVersion(-1, -1);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            new HttpVersion(0, -1);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testHttpVersionEquality() throws Exception {
        HttpVersion ver1 = new HttpVersion(1, 1);
        HttpVersion ver2 = new HttpVersion(1, 1);
        Assert.assertEquals((long)ver1.hashCode(), (long)ver2.hashCode());
        Assert.assertTrue((boolean)ver1.equals((Object)ver1));
        Assert.assertTrue((boolean)ver1.equals((Object)ver2));
        Assert.assertTrue((boolean)ver1.equals((Object)ver1));
        Assert.assertTrue((boolean)ver1.equals((Object)ver2));
        Assert.assertFalse((boolean)ver1.equals((Object)new Float(1.1)));
        Assert.assertTrue((boolean)new HttpVersion(0, 9).equals((Object)HttpVersion.HTTP_0_9));
        Assert.assertTrue((boolean)new HttpVersion(1, 0).equals((Object)HttpVersion.HTTP_1_0));
        Assert.assertTrue((boolean)new HttpVersion(1, 1).equals((Object)HttpVersion.HTTP_1_1));
        Assert.assertFalse((boolean)new HttpVersion(1, 1).equals((Object)HttpVersion.HTTP_1_0));
        Assert.assertTrue((boolean)new ProtocolVersion("HTTP", 0, 9).equals((Object)HttpVersion.HTTP_0_9));
        Assert.assertTrue((boolean)new ProtocolVersion("HTTP", 1, 0).equals((Object)HttpVersion.HTTP_1_0));
        Assert.assertTrue((boolean)new ProtocolVersion("HTTP", 1, 1).equals((Object)HttpVersion.HTTP_1_1));
        Assert.assertFalse((boolean)new ProtocolVersion("http", 1, 1).equals((Object)HttpVersion.HTTP_1_1));
        Assert.assertTrue((boolean)HttpVersion.HTTP_0_9.equals((Object)new ProtocolVersion("HTTP", 0, 9)));
        Assert.assertTrue((boolean)HttpVersion.HTTP_1_0.equals((Object)new ProtocolVersion("HTTP", 1, 0)));
        Assert.assertTrue((boolean)HttpVersion.HTTP_1_1.equals((Object)new ProtocolVersion("HTTP", 1, 1)));
        Assert.assertFalse((boolean)HttpVersion.HTTP_1_1.equals((Object)new ProtocolVersion("http", 1, 1)));
    }

    @Test
    public void testHttpVersionComparison() {
        Assert.assertTrue((boolean)HttpVersion.HTTP_0_9.lessEquals((ProtocolVersion)HttpVersion.HTTP_1_1));
        Assert.assertTrue((boolean)HttpVersion.HTTP_0_9.greaterEquals((ProtocolVersion)HttpVersion.HTTP_0_9));
        Assert.assertFalse((boolean)HttpVersion.HTTP_0_9.greaterEquals((ProtocolVersion)HttpVersion.HTTP_1_0));
        Assert.assertTrue((HttpVersion.HTTP_1_0.compareToVersion((ProtocolVersion)HttpVersion.HTTP_1_1) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((HttpVersion.HTTP_1_0.compareToVersion((ProtocolVersion)HttpVersion.HTTP_0_9) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((HttpVersion.HTTP_1_0.compareToVersion((ProtocolVersion)HttpVersion.HTTP_1_0) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCloning() throws Exception {
        HttpVersion orig = HttpVersion.HTTP_1_1;
        HttpVersion clone = (HttpVersion)orig.clone();
        Assert.assertEquals((Object)orig, (Object)clone);
    }

    @Test
    public void testSerialization() throws Exception {
        HttpVersion orig = HttpVersion.HTTP_1_1;
        ByteArrayOutputStream outbuffer = new ByteArrayOutputStream();
        ObjectOutputStream outStream = new ObjectOutputStream(outbuffer);
        outStream.writeObject(orig);
        outStream.close();
        byte[] raw = outbuffer.toByteArray();
        ByteArrayInputStream inBuffer = new ByteArrayInputStream(raw);
        ObjectInputStream inStream = new ObjectInputStream(inBuffer);
        HttpVersion clone = (HttpVersion)inStream.readObject();
        Assert.assertEquals((Object)orig, (Object)clone);
    }
}

