/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.concurrent;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.http.concurrent.BasicFuture;
import org.apache.http.concurrent.BasicFutureCallback;
import org.junit.Assert;
import org.junit.Test;

public class TestBasicFuture {
    @Test
    public void testCompleted() throws Exception {
        BasicFutureCallback callback = new BasicFutureCallback();
        BasicFuture future = new BasicFuture(callback);
        Assert.assertFalse((boolean)future.isDone());
        Object result = new Object();
        Exception boom = new Exception();
        future.completed(result);
        future.failed(boom);
        Assert.assertTrue((boolean)callback.isCompleted());
        Assert.assertSame((Object)result, callback.getResult());
        Assert.assertFalse((boolean)callback.isFailed());
        Assert.assertNull((Object)callback.getException());
        Assert.assertFalse((boolean)callback.isCancelled());
        Assert.assertSame((Object)result, (Object)future.get());
        Assert.assertTrue((boolean)future.isDone());
        Assert.assertFalse((boolean)future.isCancelled());
    }

    @Test
    public void testCompletedWithTimeout() throws Exception {
        BasicFutureCallback callback = new BasicFutureCallback();
        BasicFuture future = new BasicFuture(callback);
        Assert.assertFalse((boolean)future.isDone());
        Object result = new Object();
        Exception boom = new Exception();
        future.completed(result);
        future.failed(boom);
        Assert.assertTrue((boolean)callback.isCompleted());
        Assert.assertSame((Object)result, callback.getResult());
        Assert.assertFalse((boolean)callback.isFailed());
        Assert.assertNull((Object)callback.getException());
        Assert.assertFalse((boolean)callback.isCancelled());
        Assert.assertSame((Object)result, (Object)future.get(1L, TimeUnit.MILLISECONDS));
        Assert.assertTrue((boolean)future.isDone());
        Assert.assertFalse((boolean)future.isCancelled());
    }

    @Test
    public void testFailed() throws Exception {
        BasicFutureCallback callback = new BasicFutureCallback();
        BasicFuture future = new BasicFuture(callback);
        Object result = new Object();
        Exception boom = new Exception();
        future.failed(boom);
        future.completed(result);
        Assert.assertFalse((boolean)callback.isCompleted());
        Assert.assertNull(callback.getResult());
        Assert.assertTrue((boolean)callback.isFailed());
        Assert.assertSame((Object)boom, (Object)callback.getException());
        Assert.assertFalse((boolean)callback.isCancelled());
        try {
            future.get();
        }
        catch (ExecutionException ex) {
            Assert.assertSame((Object)boom, (Object)ex.getCause());
        }
        Assert.assertTrue((boolean)future.isDone());
        Assert.assertFalse((boolean)future.isCancelled());
    }

    @Test
    public void testCancelled() throws Exception {
        BasicFutureCallback callback = new BasicFutureCallback();
        BasicFuture future = new BasicFuture(callback);
        Object result = new Object();
        Exception boom = new Exception();
        future.cancel(true);
        future.failed(boom);
        future.completed(result);
        Assert.assertFalse((boolean)callback.isCompleted());
        Assert.assertNull(callback.getResult());
        Assert.assertFalse((boolean)callback.isFailed());
        Assert.assertNull((Object)callback.getException());
        Assert.assertTrue((boolean)callback.isCancelled());
        try {
            future.get();
            Assert.fail((String)"CancellationException expected");
        }
        catch (CancellationException ex) {
            // empty catch block
        }
        Assert.assertTrue((boolean)future.isDone());
        Assert.assertTrue((boolean)future.isCancelled());
    }

    @Test
    public void testAsyncCompleted() throws Exception {
        final BasicFuture future = new BasicFuture(null);
        final Object result = new Object();
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(100L);
                    future.completed(result);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        t.setDaemon(true);
        t.start();
        Assert.assertSame((Object)result, (Object)future.get(60L, TimeUnit.SECONDS));
        Assert.assertTrue((boolean)future.isDone());
        Assert.assertFalse((boolean)future.isCancelled());
    }

    @Test
    public void testAsyncFailed() throws Exception {
        final BasicFuture future = new BasicFuture(null);
        final Exception boom = new Exception();
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(100L);
                    future.failed(boom);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        t.setDaemon(true);
        t.start();
        try {
            future.get(60L, TimeUnit.SECONDS);
        }
        catch (ExecutionException ex) {
            Assert.assertSame((Object)boom, (Object)ex.getCause());
        }
        Assert.assertTrue((boolean)future.isDone());
        Assert.assertFalse((boolean)future.isCancelled());
    }

    @Test(expected=CancellationException.class)
    public void testAsyncCancelled() throws Exception {
        final BasicFuture future = new BasicFuture(null);
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(100L);
                    future.cancel(true);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        t.setDaemon(true);
        t.start();
        future.get(60L, TimeUnit.SECONDS);
    }

    @Test(expected=TimeoutException.class)
    public void testAsyncTimeout() throws Exception {
        final BasicFuture future = new BasicFuture(null);
        final Object result = new Object();
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(200L);
                    future.completed(result);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        t.setDaemon(true);
        t.start();
        future.get(1L, TimeUnit.MILLISECONDS);
    }

    @Test(expected=TimeoutException.class)
    public void testAsyncNegativeTimeout() throws Exception {
        BasicFuture future = new BasicFuture(null);
        future.get(-1L, TimeUnit.MILLISECONDS);
    }
}

