/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.entity;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.InputStreamEntity;
import org.junit.Assert;
import org.junit.Test;

public class TestBufferedHttpEntity {
    @Test
    public void testBufferingEntity() throws Exception {
        byte[] bytes = "Message content".getBytes(Consts.ASCII);
        InputStreamEntity httpentity = new InputStreamEntity((InputStream)new ByteArrayInputStream(bytes), -1L);
        BufferedHttpEntity bufentity = new BufferedHttpEntity((HttpEntity)httpentity);
        Assert.assertEquals((long)bytes.length, (long)bufentity.getContentLength());
        Assert.assertTrue((boolean)bufentity.isRepeatable());
        Assert.assertFalse((boolean)bufentity.isChunked());
        Assert.assertFalse((boolean)bufentity.isStreaming());
        Assert.assertNotNull((Object)bufentity.getContent());
        Assert.assertNotNull((Object)bufentity.getContent());
    }

    @Test
    public void testWrappingEntity() throws Exception {
        byte[] bytes = "Message content".getBytes(Consts.ASCII);
        ByteArrayEntity httpentity = new ByteArrayEntity(bytes);
        httpentity.setChunked(true);
        BufferedHttpEntity bufentity = new BufferedHttpEntity((HttpEntity)httpentity);
        Assert.assertEquals((long)bytes.length, (long)bufentity.getContentLength());
        Assert.assertTrue((boolean)bufentity.isRepeatable());
        Assert.assertTrue((boolean)bufentity.isChunked());
        Assert.assertFalse((boolean)bufentity.isStreaming());
        Assert.assertNotNull((Object)bufentity.getContent());
        Assert.assertNotNull((Object)bufentity.getContent());
    }

    @Test
    public void testIllegalConstructor() throws Exception {
        try {
            new BufferedHttpEntity(null);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testWriteToBuffered() throws Exception {
        int i;
        byte[] bytes = "Message content".getBytes(Consts.ASCII);
        InputStreamEntity httpentity = new InputStreamEntity((InputStream)new ByteArrayInputStream(bytes), -1L);
        BufferedHttpEntity bufentity = new BufferedHttpEntity((HttpEntity)httpentity);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        bufentity.writeTo((OutputStream)out);
        byte[] bytes2 = out.toByteArray();
        Assert.assertNotNull((Object)bytes2);
        Assert.assertEquals((long)bytes.length, (long)bytes2.length);
        for (i = 0; i < bytes.length; ++i) {
            Assert.assertEquals((long)bytes[i], (long)bytes2[i]);
        }
        out = new ByteArrayOutputStream();
        bufentity.writeTo((OutputStream)out);
        bytes2 = out.toByteArray();
        Assert.assertNotNull((Object)bytes2);
        Assert.assertEquals((long)bytes.length, (long)bytes2.length);
        for (i = 0; i < bytes.length; ++i) {
            Assert.assertEquals((long)bytes[i], (long)bytes2[i]);
        }
        try {
            bufentity.writeTo(null);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
    }

    @Test
    public void testWriteToWrapped() throws Exception {
        int i;
        byte[] bytes = "Message content".getBytes(Consts.ASCII);
        ByteArrayEntity httpentity = new ByteArrayEntity(bytes);
        BufferedHttpEntity bufentity = new BufferedHttpEntity((HttpEntity)httpentity);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        bufentity.writeTo((OutputStream)out);
        byte[] bytes2 = out.toByteArray();
        Assert.assertNotNull((Object)bytes2);
        Assert.assertEquals((long)bytes.length, (long)bytes2.length);
        for (i = 0; i < bytes.length; ++i) {
            Assert.assertEquals((long)bytes[i], (long)bytes2[i]);
        }
        out = new ByteArrayOutputStream();
        bufentity.writeTo((OutputStream)out);
        bytes2 = out.toByteArray();
        Assert.assertNotNull((Object)bytes2);
        Assert.assertEquals((long)bytes.length, (long)bytes2.length);
        for (i = 0; i < bytes.length; ++i) {
            Assert.assertEquals((long)bytes[i], (long)bytes2[i]);
        }
        try {
            bufentity.writeTo(null);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
    }
}

