/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.entity;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.HttpEntityWrapper;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestHttpEntityWrapper {
    @Test
    public void testBasics() throws Exception {
        String s = "Message content";
        StringEntity httpentity = new StringEntity("Message content", ContentType.TEXT_PLAIN);
        httpentity.setContentEncoding("identity");
        HttpEntityWrapper wrapped = new HttpEntityWrapper((HttpEntity)httpentity);
        Assert.assertEquals((long)httpentity.getContentLength(), (long)wrapped.getContentLength());
        Assert.assertEquals((Object)httpentity.getContentType(), (Object)wrapped.getContentType());
        Assert.assertEquals((Object)httpentity.getContentEncoding(), (Object)wrapped.getContentEncoding());
        Assert.assertEquals((Object)httpentity.isChunked(), (Object)wrapped.isChunked());
        Assert.assertEquals((Object)httpentity.isRepeatable(), (Object)wrapped.isRepeatable());
        Assert.assertEquals((Object)httpentity.isStreaming(), (Object)wrapped.isStreaming());
        Assert.assertNotNull((Object)wrapped.getContent());
    }

    @Test
    public void testIllegalConstructor() throws Exception {
        try {
            new HttpEntityWrapper(null);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testWriteTo() throws Exception {
        int i;
        String s = "Message content";
        byte[] bytes = "Message content".getBytes(Consts.ISO_8859_1);
        StringEntity httpentity = new StringEntity("Message content");
        HttpEntityWrapper wrapped = new HttpEntityWrapper((HttpEntity)httpentity);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        wrapped.writeTo((OutputStream)out);
        byte[] bytes2 = out.toByteArray();
        Assert.assertNotNull((Object)bytes2);
        Assert.assertEquals((long)bytes.length, (long)bytes2.length);
        for (i = 0; i < bytes.length; ++i) {
            Assert.assertEquals((long)bytes[i], (long)bytes2[i]);
        }
        out = new ByteArrayOutputStream();
        wrapped.writeTo((OutputStream)out);
        bytes2 = out.toByteArray();
        Assert.assertNotNull((Object)bytes2);
        Assert.assertEquals((long)bytes.length, (long)bytes2.length);
        for (i = 0; i < bytes.length; ++i) {
            Assert.assertEquals((long)bytes[i], (long)bytes2[i]);
        }
        try {
            wrapped.writeTo(null);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
    }

    @Test
    public void testConsumeContent() throws Exception {
        String s = "Message content";
        StringEntity httpentity = new StringEntity("Message content");
        HttpEntityWrapper wrapped = new HttpEntityWrapper((HttpEntity)httpentity);
        EntityUtils.consume((HttpEntity)wrapped);
        EntityUtils.consume((HttpEntity)wrapped);
    }
}

