/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import org.apache.http.config.MessageConstraints;
import org.apache.http.impl.io.HttpTransportMetricsImpl;
import org.apache.http.impl.io.SessionInputBufferImpl;

public class SessionInputBufferMock
extends SessionInputBufferImpl {
    public static final int BUFFER_SIZE = 16;

    public SessionInputBufferMock(InputStream inStream, int bufferSize, MessageConstraints constrains, CharsetDecoder decoder) {
        super(new HttpTransportMetricsImpl(), bufferSize, -1, constrains, decoder);
        this.bind(inStream);
    }

    public SessionInputBufferMock(InputStream inStream, int bufferSize) {
        this(inStream, bufferSize, null, null);
    }

    public SessionInputBufferMock(byte[] bytes, int bufferSize, MessageConstraints constrains, CharsetDecoder decoder) {
        this(new ByteArrayInputStream(bytes), bufferSize, constrains, decoder);
    }

    public SessionInputBufferMock(byte[] bytes, int bufferSize, MessageConstraints constrains) {
        this(new ByteArrayInputStream(bytes), bufferSize, constrains, null);
    }

    public SessionInputBufferMock(byte[] bytes, int bufferSize) {
        this(new ByteArrayInputStream(bytes), bufferSize);
    }

    public SessionInputBufferMock(byte[] bytes) {
        this(bytes, 16);
    }

    public SessionInputBufferMock(byte[] bytes, MessageConstraints constrains, Charset charset) {
        this(bytes, 16, constrains, charset != null ? charset.newDecoder() : null);
    }

    public SessionInputBufferMock(byte[] bytes, Charset charset) {
        this(bytes, null, charset);
    }

    public SessionInputBufferMock(byte[] bytes, CharsetDecoder decoder) {
        this(bytes, 16, null, decoder);
    }

    public SessionInputBufferMock(String s, MessageConstraints constrains, Charset charset) {
        this(s.getBytes(charset), constrains, charset);
    }

    public SessionInputBufferMock(String s, Charset charset) {
        this(s.getBytes(charset), MessageConstraints.DEFAULT, charset);
    }

    public boolean isDataAvailable(int timeout) throws IOException {
        return true;
    }
}

