/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl;

import java.io.ByteArrayOutputStream;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import org.apache.http.impl.io.HttpTransportMetricsImpl;
import org.apache.http.impl.io.SessionOutputBufferImpl;

public class SessionOutputBufferMock
extends SessionOutputBufferImpl {
    public static final int BUFFER_SIZE = 16;
    private final ByteArrayOutputStream buffer;

    public SessionOutputBufferMock(ByteArrayOutputStream buffer, int bufferSize, int fragementSizeHint, CharsetEncoder encoder) {
        super(new HttpTransportMetricsImpl(), bufferSize, fragementSizeHint, encoder);
        this.bind(buffer);
        this.buffer = buffer;
    }

    public SessionOutputBufferMock(ByteArrayOutputStream buffer, int bufferSize) {
        this(buffer, bufferSize, bufferSize, null);
    }

    public SessionOutputBufferMock(CharsetEncoder encoder) {
        this(new ByteArrayOutputStream(), 16, 16, encoder);
    }

    public SessionOutputBufferMock(Charset charset) {
        this(new ByteArrayOutputStream(), 16, 16, charset != null ? charset.newEncoder() : null);
    }

    public SessionOutputBufferMock(ByteArrayOutputStream buffer) {
        this(buffer, 16, 16, null);
    }

    public SessionOutputBufferMock() {
        this(new ByteArrayOutputStream());
    }

    public byte[] getData() {
        return this.buffer != null ? this.buffer.toByteArray() : new byte[]{};
    }
}

