/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpMessage;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.config.MessageConstraints;
import org.apache.http.entity.ContentLengthStrategy;
import org.apache.http.impl.BHttpConnectionBase;
import org.apache.http.impl.entity.LaxContentLengthStrategy;
import org.apache.http.impl.entity.StrictContentLengthStrategy;
import org.apache.http.impl.io.ChunkedInputStream;
import org.apache.http.impl.io.ChunkedOutputStream;
import org.apache.http.impl.io.ContentLengthInputStream;
import org.apache.http.impl.io.ContentLengthOutputStream;
import org.apache.http.impl.io.IdentityInputStream;
import org.apache.http.impl.io.IdentityOutputStream;
import org.apache.http.message.BasicHttpResponse;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

public class TestBHttpConnectionBase {
    @Mock
    private Socket socket;
    private BHttpConnectionBase conn;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.conn = new BHttpConnectionBase(1024, 1024, null, null, MessageConstraints.DEFAULT, (ContentLengthStrategy)LaxContentLengthStrategy.INSTANCE, (ContentLengthStrategy)StrictContentLengthStrategy.INSTANCE);
    }

    @Test
    public void testBasics() throws Exception {
        Assert.assertFalse((boolean)this.conn.isOpen());
        Assert.assertEquals((long)-1L, (long)this.conn.getLocalPort());
        Assert.assertEquals((long)-1L, (long)this.conn.getRemotePort());
        Assert.assertEquals(null, (Object)this.conn.getLocalAddress());
        Assert.assertEquals(null, (Object)this.conn.getRemoteAddress());
        Assert.assertEquals((Object)"[Not bound]", (Object)this.conn.toString());
    }

    @Test
    public void testSocketBind() throws Exception {
        InetAddress localAddress = InetAddress.getByAddress(new byte[]{127, 0, 0, 1});
        int localPort = 8888;
        InetAddress remoteAddress = InetAddress.getByAddress(new byte[]{10, 0, 0, 2});
        int remotePort = 80;
        InetSocketAddress localSockAddress = new InetSocketAddress(localAddress, 8888);
        InetSocketAddress remoteSockAddress = new InetSocketAddress(remoteAddress, 80);
        Mockito.when((Object)this.socket.getLocalSocketAddress()).thenReturn((Object)localSockAddress);
        Mockito.when((Object)this.socket.getRemoteSocketAddress()).thenReturn((Object)remoteSockAddress);
        Mockito.when((Object)this.socket.getLocalAddress()).thenReturn((Object)localAddress);
        Mockito.when((Object)this.socket.getLocalPort()).thenReturn((Object)8888);
        Mockito.when((Object)this.socket.getInetAddress()).thenReturn((Object)remoteAddress);
        Mockito.when((Object)this.socket.getPort()).thenReturn((Object)80);
        this.conn.bind(this.socket);
        Assert.assertEquals((Object)"127.0.0.1:8888<->10.0.0.2:80", (Object)this.conn.toString());
        Assert.assertTrue((boolean)this.conn.isOpen());
        Assert.assertEquals((long)8888L, (long)this.conn.getLocalPort());
        Assert.assertEquals((long)80L, (long)this.conn.getRemotePort());
        Assert.assertEquals((Object)InetAddress.getByAddress(new byte[]{127, 0, 0, 1}), (Object)this.conn.getLocalAddress());
        Assert.assertEquals((Object)InetAddress.getByAddress(new byte[]{10, 0, 0, 2}), (Object)this.conn.getRemoteAddress());
    }

    @Test
    public void testConnectionClose() throws Exception {
        InputStream inStream = (InputStream)Mockito.mock(InputStream.class);
        OutputStream outStream = (OutputStream)Mockito.mock(OutputStream.class);
        Mockito.when((Object)this.socket.getInputStream()).thenReturn((Object)inStream);
        Mockito.when((Object)this.socket.getOutputStream()).thenReturn((Object)outStream);
        this.conn.bind(this.socket);
        this.conn.ensureOpen();
        this.conn.getSessionOutputBuffer().write(0);
        Assert.assertTrue((boolean)this.conn.isOpen());
        this.conn.close();
        Assert.assertFalse((boolean)this.conn.isOpen());
        ((OutputStream)Mockito.verify((Object)outStream, (VerificationMode)Mockito.times((int)1))).write((byte[])Matchers.any(), Matchers.anyInt(), Matchers.anyInt());
        ((Socket)Mockito.verify((Object)this.socket, (VerificationMode)Mockito.times((int)1))).shutdownInput();
        ((Socket)Mockito.verify((Object)this.socket, (VerificationMode)Mockito.times((int)1))).shutdownOutput();
        ((Socket)Mockito.verify((Object)this.socket, (VerificationMode)Mockito.times((int)1))).close();
        this.conn.close();
        ((Socket)Mockito.verify((Object)this.socket, (VerificationMode)Mockito.times((int)1))).close();
        ((OutputStream)Mockito.verify((Object)outStream, (VerificationMode)Mockito.times((int)1))).write((byte[])Matchers.any(), Matchers.anyInt(), Matchers.anyInt());
    }

    @Test
    public void testConnectionShutdown() throws Exception {
        InputStream inStream = (InputStream)Mockito.mock(InputStream.class);
        OutputStream outStream = (OutputStream)Mockito.mock(OutputStream.class);
        Mockito.when((Object)this.socket.getInputStream()).thenReturn((Object)inStream);
        Mockito.when((Object)this.socket.getOutputStream()).thenReturn((Object)outStream);
        this.conn.bind(this.socket);
        this.conn.ensureOpen();
        this.conn.getSessionOutputBuffer().write(0);
        Assert.assertTrue((boolean)this.conn.isOpen());
        this.conn.shutdown();
        Assert.assertFalse((boolean)this.conn.isOpen());
        ((OutputStream)Mockito.verify((Object)outStream, (VerificationMode)Mockito.never())).write((byte[])Matchers.any(), Matchers.anyInt(), Matchers.anyInt());
        ((Socket)Mockito.verify((Object)this.socket, (VerificationMode)Mockito.never())).shutdownInput();
        ((Socket)Mockito.verify((Object)this.socket, (VerificationMode)Mockito.never())).shutdownOutput();
        ((Socket)Mockito.verify((Object)this.socket, (VerificationMode)Mockito.times((int)1))).close();
        this.conn.close();
        ((Socket)Mockito.verify((Object)this.socket, (VerificationMode)Mockito.times((int)1))).close();
        this.conn.shutdown();
        ((Socket)Mockito.verify((Object)this.socket, (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test
    public void testPrepareInputLengthDelimited() throws Exception {
        BasicHttpResponse message = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        message.addHeader("Content-Length", "10");
        message.addHeader("Content-Type", "stuff");
        message.addHeader("Content-Encoding", "identity");
        HttpEntity entity = this.conn.prepareInput((HttpMessage)message);
        Assert.assertNotNull((Object)entity);
        Assert.assertFalse((boolean)entity.isChunked());
        Assert.assertEquals((long)10L, (long)entity.getContentLength());
        Header ct = entity.getContentType();
        Assert.assertNotNull((Object)ct);
        Assert.assertEquals((Object)"stuff", (Object)ct.getValue());
        Header ce = entity.getContentEncoding();
        Assert.assertNotNull((Object)ce);
        Assert.assertEquals((Object)"identity", (Object)ce.getValue());
        InputStream inStream = entity.getContent();
        Assert.assertNotNull((Object)inStream);
        Assert.assertTrue((boolean)(inStream instanceof ContentLengthInputStream));
    }

    @Test
    public void testPrepareInputChunked() throws Exception {
        BasicHttpResponse message = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        message.addHeader("Transfer-Encoding", "chunked");
        HttpEntity entity = this.conn.prepareInput((HttpMessage)message);
        Assert.assertNotNull((Object)entity);
        Assert.assertTrue((boolean)entity.isChunked());
        Assert.assertEquals((long)-1L, (long)entity.getContentLength());
        InputStream inStream = entity.getContent();
        Assert.assertNotNull((Object)inStream);
        Assert.assertTrue((boolean)(inStream instanceof ChunkedInputStream));
    }

    @Test
    public void testPrepareInputIdentity() throws Exception {
        BasicHttpResponse message = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        HttpEntity entity = this.conn.prepareInput((HttpMessage)message);
        Assert.assertNotNull((Object)entity);
        Assert.assertFalse((boolean)entity.isChunked());
        Assert.assertEquals((long)-1L, (long)entity.getContentLength());
        InputStream inStream = entity.getContent();
        Assert.assertNotNull((Object)inStream);
        Assert.assertTrue((boolean)(inStream instanceof IdentityInputStream));
    }

    @Test
    public void testPrepareOutputLengthDelimited() throws Exception {
        BasicHttpResponse message = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        message.addHeader("Content-Length", "10");
        OutputStream outStream = this.conn.prepareOutput((HttpMessage)message);
        Assert.assertNotNull((Object)outStream);
        Assert.assertTrue((boolean)(outStream instanceof ContentLengthOutputStream));
    }

    @Test
    public void testPrepareOutputChunked() throws Exception {
        BasicHttpResponse message = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        message.addHeader("Transfer-Encoding", "chunked");
        OutputStream outStream = this.conn.prepareOutput((HttpMessage)message);
        Assert.assertNotNull((Object)outStream);
        Assert.assertTrue((boolean)(outStream instanceof ChunkedOutputStream));
    }

    @Test
    public void testPrepareOutputIdentity() throws Exception {
        BasicHttpResponse message = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        OutputStream outStream = this.conn.prepareOutput((HttpMessage)message);
        Assert.assertNotNull((Object)outStream);
        Assert.assertTrue((boolean)(outStream instanceof IdentityOutputStream));
    }

    @Test
    public void testSetSocketTimeout() throws Exception {
        this.conn.bind(this.socket);
        this.conn.setSocketTimeout(123);
        ((Socket)Mockito.verify((Object)this.socket, (VerificationMode)Mockito.times((int)1))).setSoTimeout(123);
    }

    @Test
    public void testSetSocketTimeoutException() throws Exception {
        this.conn.bind(this.socket);
        ((Socket)Mockito.doThrow((Throwable)new SocketException()).when((Object)this.socket)).setSoTimeout(Matchers.anyInt());
        this.conn.setSocketTimeout(123);
        ((Socket)Mockito.verify((Object)this.socket, (VerificationMode)Mockito.times((int)1))).setSoTimeout(123);
    }

    @Test
    public void testGetSocketTimeout() throws Exception {
        Assert.assertEquals((long)-1L, (long)this.conn.getSocketTimeout());
        Mockito.when((Object)this.socket.getSoTimeout()).thenReturn((Object)345);
        this.conn.bind(this.socket);
        Assert.assertEquals((long)345L, (long)this.conn.getSocketTimeout());
    }

    @Test
    public void testGetSocketTimeoutException() throws Exception {
        Assert.assertEquals((long)-1L, (long)this.conn.getSocketTimeout());
        Mockito.when((Object)this.socket.getSoTimeout()).thenThrow(new Throwable[]{new SocketException()});
        this.conn.bind(this.socket);
        Assert.assertEquals((long)-1L, (long)this.conn.getSocketTimeout());
    }

    @Test
    public void testAwaitInputInBuffer() throws Exception {
        ByteArrayInputStream inStream = (ByteArrayInputStream)Mockito.spy((Object)new ByteArrayInputStream(new byte[]{1, 2, 3, 4, 5}));
        Mockito.when((Object)this.socket.getInputStream()).thenReturn((Object)inStream);
        this.conn.bind(this.socket);
        this.conn.ensureOpen();
        this.conn.getSessionInputBuffer().read();
        Assert.assertTrue((boolean)this.conn.awaitInput(432));
        ((Socket)Mockito.verify((Object)this.socket, (VerificationMode)Mockito.never())).setSoTimeout(Matchers.anyInt());
        ((ByteArrayInputStream)Mockito.verify((Object)inStream, (VerificationMode)Mockito.times((int)1))).read((byte[])Matchers.any(), Matchers.anyInt(), Matchers.anyInt());
    }

    @Test
    public void testAwaitInputInSocket() throws Exception {
        ByteArrayInputStream inStream = (ByteArrayInputStream)Mockito.spy((Object)new ByteArrayInputStream(new byte[]{1, 2, 3, 4, 5}));
        Mockito.when((Object)this.socket.getInputStream()).thenReturn((Object)inStream);
        Mockito.when((Object)this.socket.getSoTimeout()).thenReturn((Object)345);
        this.conn.bind(this.socket);
        this.conn.ensureOpen();
        Assert.assertTrue((boolean)this.conn.awaitInput(432));
        ((Socket)Mockito.verify((Object)this.socket, (VerificationMode)Mockito.times((int)1))).setSoTimeout(432);
        ((Socket)Mockito.verify((Object)this.socket, (VerificationMode)Mockito.times((int)1))).setSoTimeout(345);
        ((ByteArrayInputStream)Mockito.verify((Object)inStream, (VerificationMode)Mockito.times((int)1))).read((byte[])Matchers.any(), Matchers.anyInt(), Matchers.anyInt());
    }

    @Test
    public void testAwaitInputNoData() throws Exception {
        InputStream inStream = (InputStream)Mockito.mock(InputStream.class);
        Mockito.when((Object)this.socket.getInputStream()).thenReturn((Object)inStream);
        Mockito.when((Object)inStream.read((byte[])Matchers.any(), Matchers.anyInt(), Matchers.anyInt())).thenReturn((Object)-1);
        this.conn.bind(this.socket);
        this.conn.ensureOpen();
        Assert.assertFalse((boolean)this.conn.awaitInput(432));
    }

    @Test
    public void testStaleWhenClosed() throws Exception {
        this.conn.bind(this.socket);
        this.conn.ensureOpen();
        this.conn.close();
        Assert.assertTrue((boolean)this.conn.isStale());
    }

    @Test
    public void testNotStaleWhenHasData() throws Exception {
        ByteArrayInputStream inStream = (ByteArrayInputStream)Mockito.spy((Object)new ByteArrayInputStream(new byte[]{1, 2, 3, 4, 5}));
        Mockito.when((Object)this.socket.getInputStream()).thenReturn((Object)inStream);
        this.conn.bind(this.socket);
        this.conn.ensureOpen();
        Assert.assertFalse((boolean)this.conn.isStale());
    }

    @Test
    public void testStaleWhenEndOfStream() throws Exception {
        InputStream inStream = (InputStream)Mockito.mock(InputStream.class);
        Mockito.when((Object)this.socket.getInputStream()).thenReturn((Object)inStream);
        Mockito.when((Object)inStream.read((byte[])Matchers.any(), Matchers.anyInt(), Matchers.anyInt())).thenReturn((Object)-1);
        this.conn.bind(this.socket);
        this.conn.ensureOpen();
        Assert.assertTrue((boolean)this.conn.isStale());
    }

    @Test
    public void testNotStaleWhenTimeout() throws Exception {
        InputStream inStream = (InputStream)Mockito.mock(InputStream.class);
        Mockito.when((Object)this.socket.getInputStream()).thenReturn((Object)inStream);
        Mockito.when((Object)inStream.read((byte[])Matchers.any(), Matchers.anyInt(), Matchers.anyInt())).thenThrow(new Throwable[]{new SocketTimeoutException()});
        this.conn.bind(this.socket);
        this.conn.ensureOpen();
        Assert.assertFalse((boolean)this.conn.isStale());
    }

    @Test
    public void testStaleWhenIOError() throws Exception {
        InputStream inStream = (InputStream)Mockito.mock(InputStream.class);
        Mockito.when((Object)this.socket.getInputStream()).thenReturn((Object)inStream);
        Mockito.when((Object)inStream.read((byte[])Matchers.any(), Matchers.anyInt(), Matchers.anyInt())).thenThrow(new Throwable[]{new SocketException()});
        this.conn.bind(this.socket);
        this.conn.ensureOpen();
        Assert.assertTrue((boolean)this.conn.isStale());
    }
}

