/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl;

import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.message.BasicHttpRequest;
import org.junit.Assert;
import org.junit.Test;

public class TestBasicRequest {
    @Test
    public void testConstructor() throws Exception {
        new BasicHttpRequest("GET", "/stuff");
        new BasicHttpRequest("GET", "/stuff", (ProtocolVersion)HttpVersion.HTTP_1_1);
        try {
            new BasicHttpRequest(null, "/stuff");
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            new BasicHttpRequest("GET", null);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testRequestLine() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("GET", "/stuff", (ProtocolVersion)HttpVersion.HTTP_1_0);
        Assert.assertEquals((Object)"GET", (Object)request.getRequestLine().getMethod());
        Assert.assertEquals((Object)"/stuff", (Object)request.getRequestLine().getUri());
        Assert.assertEquals((Object)HttpVersion.HTTP_1_0, (Object)request.getRequestLine().getProtocolVersion());
    }
}

