/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.net.Socket;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.config.MessageConstraints;
import org.apache.http.entity.ContentLengthStrategy;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.DefaultBHttpClientConnection;
import org.apache.http.impl.entity.LaxContentLengthStrategy;
import org.apache.http.impl.entity.StrictContentLengthStrategy;
import org.apache.http.impl.io.DefaultHttpRequestWriterFactory;
import org.apache.http.impl.io.DefaultHttpResponseParserFactory;
import org.apache.http.io.HttpMessageParserFactory;
import org.apache.http.io.HttpMessageWriterFactory;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.apache.http.message.BasicHttpRequest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class TestDefaultBHttpClientConnection {
    @Mock
    private Socket socket;
    private DefaultBHttpClientConnection conn;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.conn = new DefaultBHttpClientConnection(1024, 1024, null, null, MessageConstraints.DEFAULT, (ContentLengthStrategy)LaxContentLengthStrategy.INSTANCE, (ContentLengthStrategy)StrictContentLengthStrategy.INSTANCE, (HttpMessageWriterFactory)DefaultHttpRequestWriterFactory.INSTANCE, (HttpMessageParserFactory)DefaultHttpResponseParserFactory.INSTANCE);
    }

    @Test
    public void testBasics() throws Exception {
        Assert.assertFalse((boolean)this.conn.isOpen());
        Assert.assertEquals((Object)"[Not bound]", (Object)this.conn.toString());
    }

    @Test
    public void testReadRequestHead() throws Exception {
        String s = "HTTP/1.1 200 OK\r\nUser-Agent: test\r\n\r\n";
        ByteArrayInputStream inStream = new ByteArrayInputStream("HTTP/1.1 200 OK\r\nUser-Agent: test\r\n\r\n".getBytes(Consts.ASCII));
        Mockito.when((Object)this.socket.getInputStream()).thenReturn((Object)inStream);
        this.conn.bind(this.socket);
        Assert.assertEquals((long)0L, (long)this.conn.getMetrics().getResponseCount());
        HttpResponse response = this.conn.receiveResponseHeader();
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((Object)HttpVersion.HTTP_1_1, (Object)response.getProtocolVersion());
        Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        Assert.assertTrue((boolean)response.containsHeader("User-Agent"));
        Assert.assertEquals((long)1L, (long)this.conn.getMetrics().getResponseCount());
    }

    @Test
    public void testReadRequestEntity() throws Exception {
        String s = "HTTP/1.1 200 OK\r\nUser-Agent: test\r\nContent-Length: 3\r\n\r\n123";
        ByteArrayInputStream inStream = new ByteArrayInputStream("HTTP/1.1 200 OK\r\nUser-Agent: test\r\nContent-Length: 3\r\n\r\n123".getBytes(Consts.ASCII));
        Mockito.when((Object)this.socket.getInputStream()).thenReturn((Object)inStream);
        this.conn.bind(this.socket);
        Assert.assertEquals((long)0L, (long)this.conn.getMetrics().getResponseCount());
        HttpResponse response = this.conn.receiveResponseHeader();
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((Object)HttpVersion.HTTP_1_1, (Object)response.getProtocolVersion());
        Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        Assert.assertTrue((boolean)response.containsHeader("User-Agent"));
        Assert.assertEquals((long)1L, (long)this.conn.getMetrics().getResponseCount());
        this.conn.receiveResponseEntity(response);
        HttpEntity entity = response.getEntity();
        Assert.assertNotNull((Object)entity);
        Assert.assertEquals((long)3L, (long)entity.getContentLength());
        Assert.assertEquals((long)1L, (long)this.conn.getMetrics().getResponseCount());
    }

    @Test
    public void testWriteResponseHead() throws Exception {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        Mockito.when((Object)this.socket.getOutputStream()).thenReturn((Object)outStream);
        this.conn.bind(this.socket);
        Assert.assertEquals((long)0L, (long)this.conn.getMetrics().getRequestCount());
        BasicHttpRequest request = new BasicHttpRequest("GET", "/stuff", (ProtocolVersion)HttpVersion.HTTP_1_1);
        request.addHeader("User-Agent", "test");
        this.conn.sendRequestHeader((HttpRequest)request);
        this.conn.flush();
        Assert.assertEquals((long)1L, (long)this.conn.getMetrics().getRequestCount());
        String s = new String(outStream.toByteArray(), "ASCII");
        Assert.assertEquals((Object)"GET /stuff HTTP/1.1\r\nUser-Agent: test\r\n\r\n", (Object)s);
    }

    @Test
    public void testWriteResponseEntity() throws Exception {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        Mockito.when((Object)this.socket.getOutputStream()).thenReturn((Object)outStream);
        this.conn.bind(this.socket);
        Assert.assertEquals((long)0L, (long)this.conn.getMetrics().getRequestCount());
        BasicHttpEntityEnclosingRequest request = new BasicHttpEntityEnclosingRequest("POST", "/stuff", (ProtocolVersion)HttpVersion.HTTP_1_1);
        request.addHeader("User-Agent", "test");
        request.addHeader("Content-Length", "3");
        request.setEntity((HttpEntity)new StringEntity("123", ContentType.TEXT_PLAIN));
        this.conn.sendRequestHeader((HttpRequest)request);
        this.conn.sendRequestEntity((HttpEntityEnclosingRequest)request);
        this.conn.flush();
        Assert.assertEquals((long)1L, (long)this.conn.getMetrics().getRequestCount());
        String s = new String(outStream.toByteArray(), "ASCII");
        Assert.assertEquals((Object)"POST /stuff HTTP/1.1\r\nUser-Agent: test\r\nContent-Length: 3\r\n\r\n123", (Object)s);
    }
}

