/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl;

import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.message.BasicHttpRequest;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestDefaultConnectionReuseStrategy {
    private HttpContext context;
    private ConnectionReuseStrategy reuseStrategy;

    @Before
    public void setUp() {
        this.reuseStrategy = DefaultConnectionReuseStrategy.INSTANCE;
        this.context = new BasicHttpContext(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIllegalResponseArg() throws Exception {
        this.reuseStrategy.keepAlive(null, this.context);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIllegalContextArg() throws Exception {
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        this.reuseStrategy.keepAlive((HttpResponse)response, null);
    }

    @Test
    public void testNoContentLengthResponseHttp1_0() throws Exception {
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_0, 200, "OK");
        Assert.assertFalse((boolean)this.reuseStrategy.keepAlive((HttpResponse)response, this.context));
    }

    @Test
    public void testNoContentLengthResponseHttp1_1() throws Exception {
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        Assert.assertFalse((boolean)this.reuseStrategy.keepAlive((HttpResponse)response, this.context));
    }

    @Test
    public void testChunkedContent() throws Exception {
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        response.addHeader("Transfer-Encoding", "chunked");
        Assert.assertTrue((boolean)this.reuseStrategy.keepAlive((HttpResponse)response, this.context));
    }

    @Test
    public void testIgnoreInvalidKeepAlive() throws Exception {
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_0, 200, "OK");
        response.addHeader("Connection", "keep-alive");
        Assert.assertFalse((boolean)this.reuseStrategy.keepAlive((HttpResponse)response, this.context));
    }

    @Test
    public void testExplicitClose() throws Exception {
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        response.addHeader("Transfer-Encoding", "chunked");
        response.addHeader("Connection", "close");
        Assert.assertFalse((boolean)this.reuseStrategy.keepAlive((HttpResponse)response, this.context));
    }

    @Test
    public void testExplicitKeepAlive() throws Exception {
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_0, 200, "OK");
        response.addHeader("Content-Length", "10");
        response.addHeader("Connection", "keep-alive");
        Assert.assertTrue((boolean)this.reuseStrategy.keepAlive((HttpResponse)response, this.context));
    }

    @Test
    public void testHTTP10Default() throws Exception {
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_0, 200, "OK");
        response.addHeader("Content-Length", "10");
        Assert.assertFalse((boolean)this.reuseStrategy.keepAlive((HttpResponse)response, this.context));
    }

    @Test
    public void testHTTP11Default() throws Exception {
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        response.addHeader("Content-Length", "10");
        Assert.assertTrue((boolean)this.reuseStrategy.keepAlive((HttpResponse)response, this.context));
    }

    @Test
    public void testFutureHTTP() throws Exception {
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)new HttpVersion(3, 45), 200, "OK");
        response.addHeader("Content-Length", "10");
        Assert.assertTrue((boolean)this.reuseStrategy.keepAlive((HttpResponse)response, this.context));
    }

    @Test
    public void testBrokenConnectionDirective1() throws Exception {
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_0, 200, "OK");
        response.addHeader("Content-Length", "10");
        response.addHeader("Connection", "keep--alive");
        Assert.assertFalse((boolean)this.reuseStrategy.keepAlive((HttpResponse)response, this.context));
    }

    @Test
    public void testBrokenConnectionDirective2() throws Exception {
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_0, 200, "OK");
        response.addHeader("Content-Length", "10");
        response.addHeader("Connection", null);
        Assert.assertFalse((boolean)this.reuseStrategy.keepAlive((HttpResponse)response, this.context));
    }

    @Test
    public void testConnectionTokens1() throws Exception {
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        response.addHeader("Transfer-Encoding", "chunked");
        response.addHeader("Connection", "yadda, cLOSe, dumdy");
        Assert.assertFalse((boolean)this.reuseStrategy.keepAlive((HttpResponse)response, this.context));
    }

    @Test
    public void testConnectionTokens2() throws Exception {
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        response.addHeader("Transfer-Encoding", "chunked");
        response.addHeader("Connection", "yadda, kEEP-alive, dumdy");
        Assert.assertTrue((boolean)this.reuseStrategy.keepAlive((HttpResponse)response, this.context));
    }

    @Test
    public void testConnectionTokens3() throws Exception {
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        response.addHeader("Transfer-Encoding", "chunked");
        response.addHeader("Connection", "yadda, keep-alive, close, dumdy");
        Assert.assertFalse((boolean)this.reuseStrategy.keepAlive((HttpResponse)response, this.context));
    }

    @Test
    public void testConnectionTokens4() throws Exception {
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        response.addHeader("Transfer-Encoding", "chunked");
        response.addHeader("Connection", "yadda, close, dumdy");
        response.addHeader("Proxy-Connection", "keep-alive");
        Assert.assertFalse((boolean)this.reuseStrategy.keepAlive((HttpResponse)response, this.context));
    }

    @Test
    public void testConnectionTokens5() throws Exception {
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        response.addHeader("Transfer-Encoding", "chunked");
        response.addHeader("Connection", "yadda, dumdy");
        response.addHeader("Proxy-Connection", "close");
        Assert.assertTrue((boolean)this.reuseStrategy.keepAlive((HttpResponse)response, this.context));
    }

    @Test
    public void testConnectionTokens6() throws Exception {
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        response.addHeader("Transfer-Encoding", "chunked");
        response.addHeader("Connection", "");
        response.addHeader("Proxy-Connection", "close");
        Assert.assertTrue((boolean)this.reuseStrategy.keepAlive((HttpResponse)response, this.context));
    }

    @Test
    public void testConnectionTokensInvalid() throws Exception {
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        response.addHeader("Transfer-Encoding", "chunked");
        response.addHeader("Connection", "keep-alive=true");
        Assert.assertFalse((boolean)this.reuseStrategy.keepAlive((HttpResponse)response, this.context));
    }

    @Test
    public void testMultipleContentLength() throws Exception {
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        response.addHeader("Content-Length", "10");
        response.addHeader("Content-Length", "11");
        Assert.assertFalse((boolean)this.reuseStrategy.keepAlive((HttpResponse)response, this.context));
    }

    @Test
    public void testInvalidContentLength() throws Exception {
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        response.addHeader("Content-Length", "crap");
        Assert.assertFalse((boolean)this.reuseStrategy.keepAlive((HttpResponse)response, this.context));
    }

    @Test
    public void testInvalidNegativeContentLength() throws Exception {
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        response.addHeader("Content-Length", "-10");
        Assert.assertFalse((boolean)this.reuseStrategy.keepAlive((HttpResponse)response, this.context));
    }

    @Test
    public void testNoContentResponse() throws Exception {
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 204, "No Content");
        Assert.assertTrue((boolean)this.reuseStrategy.keepAlive((HttpResponse)response, this.context));
    }

    @Test
    public void testNoContentResponseHttp10() throws Exception {
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_0, 204, "No Content");
        Assert.assertFalse((boolean)this.reuseStrategy.keepAlive((HttpResponse)response, this.context));
    }

    @Test
    public void testRequestClose() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        request.addHeader("Connection", "close");
        this.context.setAttribute("http.request", (Object)request);
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        response.addHeader("Content-Length", "10");
        response.addHeader("Connection", "keep-alive");
        Assert.assertFalse((boolean)this.reuseStrategy.keepAlive((HttpResponse)response, this.context));
    }

    @Test
    public void testHeadRequestWithout() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("HEAD", "/");
        this.context.setAttribute("http.request", (Object)request);
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        Assert.assertTrue((boolean)this.reuseStrategy.keepAlive((HttpResponse)response, this.context));
    }

    @Test
    public void testHttp204ContentLengthGreaterThanZero() throws Exception {
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 204, "OK");
        response.addHeader("Content-Length", "10");
        response.addHeader("Connection", "keep-alive");
        Assert.assertFalse((boolean)this.reuseStrategy.keepAlive((HttpResponse)response, this.context));
    }

    @Test
    public void testHttp204ContentLengthEqualToZero() throws Exception {
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 204, "OK");
        response.addHeader("Content-Length", "0");
        response.addHeader("Connection", "keep-alive");
        Assert.assertTrue((boolean)this.reuseStrategy.keepAlive((HttpResponse)response, this.context));
    }

    @Test
    public void testHttp204ChunkedContent() throws Exception {
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 204, "OK");
        response.addHeader("Transfer-Encoding", "chunked");
        response.addHeader("Connection", "keep-alive");
        Assert.assertFalse((boolean)this.reuseStrategy.keepAlive((HttpResponse)response, this.context));
    }
}

