/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.apache.http.HttpStatus;
import org.apache.http.impl.EnglishReasonPhraseCatalog;
import org.junit.Assert;
import org.junit.Test;

public class TestEnglishReasonPhraseCatalog {
    @Test
    public void testReasonPhrases() throws IllegalAccessException {
        Field[] publicFields = HttpStatus.class.getFields();
        Assert.assertNotNull((Object)publicFields);
        Assert.assertTrue((publicFields.length > 0 ? 1 : 0) != 0);
        for (Field f : publicFields) {
            int modifiers = f.getModifiers();
            if (f.getType() != Integer.TYPE || !Modifier.isPublic(modifiers) || !Modifier.isFinal(modifiers) || !Modifier.isStatic(modifiers)) continue;
            int iValue = f.getInt(null);
            String text = EnglishReasonPhraseCatalog.INSTANCE.getReason(iValue, null);
            Assert.assertNotNull((String)("text is null for HttpStatus." + f.getName()), (Object)text);
            Assert.assertTrue((text.length() > 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testStatusInvalid() throws Exception {
        try {
            EnglishReasonPhraseCatalog.INSTANCE.getReason(-1, null);
            Assert.fail((String)"IllegalArgumentException must have been thrown (-1)");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            EnglishReasonPhraseCatalog.INSTANCE.getReason(99, null);
            Assert.fail((String)"IllegalArgumentException must have been thrown (99)");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            EnglishReasonPhraseCatalog.INSTANCE.getReason(600, null);
            Assert.fail((String)"IllegalArgumentException must have been thrown (600)");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testStatusAll() throws Exception {
        for (int i = 100; i < 600; ++i) {
            EnglishReasonPhraseCatalog.INSTANCE.getReason(i, null);
        }
    }
}

