/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.cookie;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.http.impl.cookie.BasicClientCookie2;
import org.junit.Assert;
import org.junit.Test;

public class TestBasicClientCookie2 {
    @Test
    public void testConstructor() {
        BasicClientCookie2 cookie = new BasicClientCookie2("name", "value");
        Assert.assertEquals((Object)"name", (Object)cookie.getName());
        Assert.assertEquals((Object)"value", (Object)cookie.getValue());
        try {
            new BasicClientCookie2(null, null);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testCloning() throws Exception {
        BasicClientCookie2 orig = new BasicClientCookie2("name", "value");
        orig.setDomain("domain");
        orig.setPath("/");
        orig.setAttribute("attrib", "stuff");
        orig.setPorts(new int[]{80, 8080});
        BasicClientCookie2 clone = (BasicClientCookie2)orig.clone();
        Assert.assertEquals((Object)orig.getName(), (Object)clone.getName());
        Assert.assertEquals((Object)orig.getValue(), (Object)clone.getValue());
        Assert.assertEquals((Object)orig.getDomain(), (Object)clone.getDomain());
        Assert.assertEquals((Object)orig.getPath(), (Object)clone.getPath());
        Assert.assertEquals((Object)orig.getAttribute("attrib"), (Object)clone.getAttribute("attrib"));
        Assert.assertEquals((long)orig.getPorts().length, (long)clone.getPorts().length);
        Assert.assertEquals((long)orig.getPorts()[0], (long)clone.getPorts()[0]);
        Assert.assertEquals((long)orig.getPorts()[1], (long)clone.getPorts()[1]);
    }

    @Test
    public void testHTTPCLIENT_1031() throws Exception {
        BasicClientCookie2 orig = new BasicClientCookie2("name", "value");
        orig.setDomain("domain");
        orig.setPath("/");
        orig.setAttribute("attrib", "stuff");
        BasicClientCookie2 clone = (BasicClientCookie2)orig.clone();
        Assert.assertEquals((Object)orig.getName(), (Object)clone.getName());
        Assert.assertEquals((Object)orig.getValue(), (Object)clone.getValue());
        Assert.assertEquals((Object)orig.getDomain(), (Object)clone.getDomain());
        Assert.assertEquals((Object)orig.getPath(), (Object)clone.getPath());
        Assert.assertEquals((Object)orig.getAttribute("attrib"), (Object)clone.getAttribute("attrib"));
        Assert.assertNull((Object)clone.getPorts());
    }

    @Test
    public void testSerialization() throws Exception {
        BasicClientCookie2 orig = new BasicClientCookie2("name", "value");
        orig.setDomain("domain");
        orig.setPath("/");
        orig.setAttribute("attrib", "stuff");
        orig.setPorts(new int[]{80, 8080});
        ByteArrayOutputStream outbuffer = new ByteArrayOutputStream();
        ObjectOutputStream outStream = new ObjectOutputStream(outbuffer);
        outStream.writeObject(orig);
        outStream.close();
        byte[] raw = outbuffer.toByteArray();
        ByteArrayInputStream inBuffer = new ByteArrayInputStream(raw);
        ObjectInputStream inStream = new ObjectInputStream(inBuffer);
        BasicClientCookie2 clone = (BasicClientCookie2)inStream.readObject();
        Assert.assertEquals((Object)orig.getName(), (Object)clone.getName());
        Assert.assertEquals((Object)orig.getValue(), (Object)clone.getValue());
        Assert.assertEquals((Object)orig.getDomain(), (Object)clone.getDomain());
        Assert.assertEquals((Object)orig.getPath(), (Object)clone.getPath());
        Assert.assertEquals((Object)orig.getAttribute("attrib"), (Object)clone.getAttribute("attrib"));
        int[] expected = orig.getPorts();
        int[] clones = clone.getPorts();
        Assert.assertNotNull((Object)expected);
        Assert.assertNotNull((Object)clones);
        Assert.assertEquals((long)expected.length, (long)clones.length);
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals((long)expected[i], (long)clones[i]);
        }
    }
}

