/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.cookie;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;
import org.apache.http.Header;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.MalformedCookieException;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.impl.cookie.NetscapeDraftSpec;
import org.apache.http.message.BasicHeader;
import org.junit.Assert;
import org.junit.Test;

public class TestCookieNetscapeDraft {
    @Test
    public void testParseAbsPath() throws Exception {
        BasicHeader header = new BasicHeader("Set-Cookie", "name1=value1;Path=/path/");
        NetscapeDraftSpec cookiespec = new NetscapeDraftSpec();
        CookieOrigin origin = new CookieOrigin("host", 80, "/path/", true);
        List cookies = cookiespec.parse((Header)header, origin);
        for (int i = 0; i < cookies.size(); ++i) {
            cookiespec.validate((Cookie)cookies.get(i), origin);
        }
        Assert.assertEquals((String)"Found 1 cookies.", (long)1L, (long)cookies.size());
        Assert.assertEquals((String)"Name", (Object)"name1", (Object)((Cookie)cookies.get(0)).getName());
        Assert.assertEquals((String)"Value", (Object)"value1", (Object)((Cookie)cookies.get(0)).getValue());
        Assert.assertEquals((String)"Domain", (Object)"host", (Object)((Cookie)cookies.get(0)).getDomain());
        Assert.assertEquals((String)"Path", (Object)"/path/", (Object)((Cookie)cookies.get(0)).getPath());
    }

    @Test
    public void testParseAbsPath2() throws Exception {
        BasicHeader header = new BasicHeader("Set-Cookie", "name1=value1;Path=/");
        NetscapeDraftSpec cookiespec = new NetscapeDraftSpec();
        CookieOrigin origin = new CookieOrigin("host", 80, "/", true);
        List cookies = cookiespec.parse((Header)header, origin);
        for (int i = 0; i < cookies.size(); ++i) {
            cookiespec.validate((Cookie)cookies.get(i), origin);
        }
        Assert.assertEquals((String)"Found 1 cookies.", (long)1L, (long)cookies.size());
        Assert.assertEquals((String)"Name", (Object)"name1", (Object)((Cookie)cookies.get(0)).getName());
        Assert.assertEquals((String)"Value", (Object)"value1", (Object)((Cookie)cookies.get(0)).getValue());
        Assert.assertEquals((String)"Domain", (Object)"host", (Object)((Cookie)cookies.get(0)).getDomain());
        Assert.assertEquals((String)"Path", (Object)"/", (Object)((Cookie)cookies.get(0)).getPath());
    }

    @Test
    public void testParseRelativePath() throws Exception {
        BasicHeader header = new BasicHeader("Set-Cookie", "name1=value1;Path=whatever");
        NetscapeDraftSpec cookiespec = new NetscapeDraftSpec();
        CookieOrigin origin = new CookieOrigin("host", 80, "whatever", true);
        List cookies = cookiespec.parse((Header)header, origin);
        for (int i = 0; i < cookies.size(); ++i) {
            cookiespec.validate((Cookie)cookies.get(i), origin);
        }
        Assert.assertEquals((String)"Found 1 cookies.", (long)1L, (long)cookies.size());
        Assert.assertEquals((String)"Name", (Object)"name1", (Object)((Cookie)cookies.get(0)).getName());
        Assert.assertEquals((String)"Value", (Object)"value1", (Object)((Cookie)cookies.get(0)).getValue());
        Assert.assertEquals((String)"Domain", (Object)"host", (Object)((Cookie)cookies.get(0)).getDomain());
        Assert.assertEquals((String)"Path", (Object)"whatever", (Object)((Cookie)cookies.get(0)).getPath());
    }

    @Test
    public void testParseWithIllegalNetscapeDomain1() throws Exception {
        BasicHeader header = new BasicHeader("Set-Cookie", "cookie-name=cookie-value; domain=.com");
        NetscapeDraftSpec cookiespec = new NetscapeDraftSpec();
        try {
            CookieOrigin origin = new CookieOrigin("a.com", 80, "/", false);
            List cookies = cookiespec.parse((Header)header, origin);
            for (int i = 0; i < cookies.size(); ++i) {
                cookiespec.validate((Cookie)cookies.get(i), origin);
            }
            Assert.fail((String)"MalformedCookieException exception should have been thrown");
        }
        catch (MalformedCookieException malformedCookieException) {
            // empty catch block
        }
    }

    @Test
    public void testParseWithWrongNetscapeDomain2() throws Exception {
        BasicHeader header = new BasicHeader("Set-Cookie", "cookie-name=cookie-value; domain=.y.z");
        NetscapeDraftSpec cookiespec = new NetscapeDraftSpec();
        try {
            CookieOrigin origin = new CookieOrigin("x.y.z", 80, "/", false);
            List cookies = cookiespec.parse((Header)header, origin);
            for (int i = 0; i < cookies.size(); ++i) {
                cookiespec.validate((Cookie)cookies.get(i), origin);
            }
            Assert.fail((String)"MalformedCookieException exception should have been thrown");
        }
        catch (MalformedCookieException malformedCookieException) {
            // empty catch block
        }
    }

    @Test
    public void testParseVersionIgnored() throws Exception {
        BasicHeader header = new BasicHeader("Set-Cookie", "name1=value1;Path=/path/;Version=1;");
        NetscapeDraftSpec cookiespec = new NetscapeDraftSpec();
        CookieOrigin origin = new CookieOrigin("host", 80, "/path/", true);
        List cookies = cookiespec.parse((Header)header, origin);
        for (int i = 0; i < cookies.size(); ++i) {
            cookiespec.validate((Cookie)cookies.get(i), origin);
        }
        Assert.assertEquals((String)"Found 1 cookies.", (long)1L, (long)cookies.size());
        Cookie cookie = (Cookie)cookies.get(0);
        Assert.assertEquals((String)"Name", (Object)"name1", (Object)cookie.getName());
        Assert.assertEquals((String)"Value", (Object)"value1", (Object)cookie.getValue());
        Assert.assertEquals((String)"Domain", (Object)"host", (Object)cookie.getDomain());
        Assert.assertEquals((String)"Path", (Object)"/path/", (Object)cookie.getPath());
        Assert.assertEquals((long)0L, (long)cookie.getVersion());
    }

    @Test
    public void testNetscapeCookieFormatting() throws Exception {
        BasicHeader header = new BasicHeader("Set-Cookie", "name=value; path=/; domain=.mydomain.com");
        NetscapeDraftSpec cookiespec = new NetscapeDraftSpec();
        CookieOrigin origin = new CookieOrigin("myhost.mydomain.com", 80, "/", false);
        List cookies = cookiespec.parse((Header)header, origin);
        cookiespec.validate((Cookie)cookies.get(0), origin);
        List headers = cookiespec.formatCookies(cookies);
        Assert.assertEquals((long)1L, (long)headers.size());
        Assert.assertEquals((Object)"name=value", (Object)((Header)headers.get(0)).getValue());
    }

    @Test
    public void testNetscapeCookieExpireAttribute() throws Exception {
        NetscapeDraftSpec cookiespec = new NetscapeDraftSpec();
        BasicHeader header = new BasicHeader("Set-Cookie", "name=value; path=/; domain=.mydomain.com; expires=Thu, 01-Jan-2070 00:00:10 GMT; comment=no_comment");
        CookieOrigin origin = new CookieOrigin("myhost.mydomain.com", 80, "/", false);
        List cookies = cookiespec.parse((Header)header, origin);
        cookiespec.validate((Cookie)cookies.get(0), origin);
        Assert.assertNotNull((Object)cookies);
        Assert.assertEquals((long)1L, (long)cookies.size());
        Cookie cookie = (Cookie)cookies.get(0);
        Calendar c = Calendar.getInstance();
        c.setTimeZone(TimeZone.getTimeZone("GMT"));
        c.setTime(cookie.getExpiryDate());
        int year = c.get(1);
        Assert.assertEquals((long)2070L, (long)year);
    }

    @Test
    public void testNetscapeCookieExpireAttributeTwoDigitYear() throws Exception {
        NetscapeDraftSpec cookiespec = new NetscapeDraftSpec();
        BasicHeader header = new BasicHeader("Set-Cookie", "name=value; path=/; domain=.mydomain.com; expires=Thursday, 01-Jan-70 00:00:10 GMT; comment=no_comment");
        CookieOrigin origin = new CookieOrigin("myhost.mydomain.com", 80, "/", false);
        List cookies = cookiespec.parse((Header)header, origin);
        cookiespec.validate((Cookie)cookies.get(0), origin);
        Assert.assertNotNull((Object)cookies);
        Assert.assertEquals((long)1L, (long)cookies.size());
        Cookie cookie = (Cookie)cookies.get(0);
        Calendar c = Calendar.getInstance();
        c.setTimeZone(TimeZone.getTimeZone("GMT"));
        c.setTime(cookie.getExpiryDate());
        int year = c.get(1);
        Assert.assertEquals((long)2070L, (long)year);
    }

    @Test
    public void testNetscapeCookieInvalidExpireAttribute() throws Exception {
        NetscapeDraftSpec cookiespec = new NetscapeDraftSpec();
        CookieOrigin origin = new CookieOrigin("myhost.mydomain.com", 80, "/", false);
        BasicHeader header = new BasicHeader("Set-Cookie", "name=value; path=/; domain=.mydomain.com; expires=Thu 01-Jan-2070 00:00:10 GMT; comment=no_comment");
        try {
            List cookies = cookiespec.parse((Header)header, origin);
            cookiespec.validate((Cookie)cookies.get(0), origin);
            Assert.fail((String)"MalformedCookieException exception should have been thrown");
        }
        catch (MalformedCookieException e) {
            // empty catch block
        }
    }

    @Test
    public void testNetscapeCookieExpireAttributeNoTimeZone() throws Exception {
        NetscapeDraftSpec cookiespec = new NetscapeDraftSpec();
        BasicHeader header = new BasicHeader("Set-Cookie", "name=value; expires=Thu, 01-Jan-2006 00:00:00 ");
        CookieOrigin origin = new CookieOrigin("myhost.mydomain.com", 80, "/", false);
        try {
            cookiespec.parse((Header)header, origin);
            Assert.fail((String)"MalformedCookieException should have been thrown");
        }
        catch (MalformedCookieException ex) {
            // empty catch block
        }
    }

    @Test
    public void testCookieWithComma() throws Exception {
        BasicHeader header = new BasicHeader("Set-Cookie", "a=b,c");
        NetscapeDraftSpec cookiespec = new NetscapeDraftSpec();
        CookieOrigin origin = new CookieOrigin("localhost", 80, "/", false);
        List cookies = cookiespec.parse((Header)header, origin);
        Assert.assertEquals((String)"number of cookies", (long)1L, (long)cookies.size());
        Assert.assertEquals((Object)"a", (Object)((Cookie)cookies.get(0)).getName());
        Assert.assertEquals((Object)"b,c", (Object)((Cookie)cookies.get(0)).getValue());
    }

    @Test
    public void testFormatCookies() throws Exception {
        BasicClientCookie c1 = new BasicClientCookie("name1", "value1");
        c1.setDomain(".whatever.com");
        c1.setAttribute("domain", c1.getDomain());
        c1.setPath("/");
        c1.setAttribute("path", c1.getPath());
        BasicClientCookie c2 = new BasicClientCookie("name2", "value2");
        BasicClientCookie c3 = new BasicClientCookie("name3", null);
        NetscapeDraftSpec cookiespec = new NetscapeDraftSpec();
        ArrayList<BasicClientCookie> cookies = new ArrayList<BasicClientCookie>();
        cookies.add(c1);
        cookies.add(c2);
        cookies.add(c3);
        List headers = cookiespec.formatCookies(cookies);
        Assert.assertNotNull((Object)headers);
        Assert.assertEquals((long)1L, (long)headers.size());
        Assert.assertEquals((Object)"name1=value1; name2=value2; name3", (Object)((Header)headers.get(0)).getValue());
    }

    @Test
    public void testInvalidInput() throws Exception {
        NetscapeDraftSpec cookiespec = new NetscapeDraftSpec();
        try {
            cookiespec.parse(null, null);
            Assert.fail((String)"IllegalArgumentException must have been thrown");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            cookiespec.parse((Header)new BasicHeader("Set-Cookie", "name=value"), null);
            Assert.fail((String)"IllegalArgumentException must have been thrown");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            cookiespec.formatCookies(null);
            Assert.fail((String)"IllegalArgumentException must have been thrown");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            ArrayList cookies = new ArrayList();
            cookiespec.formatCookies(cookies);
            Assert.fail((String)"IllegalArgumentException must have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

