/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.entity;

import org.apache.http.HttpMessage;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolException;
import org.apache.http.ProtocolVersion;
import org.apache.http.impl.entity.DummyHttpMessage;
import org.apache.http.impl.entity.StrictContentLengthStrategy;
import org.junit.Assert;
import org.junit.Test;

public class TestStrictContentLengthStrategy {
    @Test
    public void testEntityWithChunkTransferEncoding() throws Exception {
        StrictContentLengthStrategy lenStrategy = new StrictContentLengthStrategy();
        DummyHttpMessage message = new DummyHttpMessage();
        message.addHeader("Transfer-Encoding", "Chunked");
        Assert.assertEquals((long)-2L, (long)lenStrategy.determineLength((HttpMessage)message));
    }

    @Test
    public void testEntityWithIdentityTransferEncoding() throws Exception {
        StrictContentLengthStrategy lenStrategy = new StrictContentLengthStrategy();
        DummyHttpMessage message = new DummyHttpMessage();
        message.addHeader("Transfer-Encoding", "Identity");
        Assert.assertEquals((long)-1L, (long)lenStrategy.determineLength((HttpMessage)message));
    }

    @Test(expected=ProtocolException.class)
    public void testEntityWithInvalidTransferEncoding() throws Exception {
        StrictContentLengthStrategy lenStrategy = new StrictContentLengthStrategy();
        DummyHttpMessage message = new DummyHttpMessage();
        message.addHeader("Transfer-Encoding", "whatever");
        lenStrategy.determineLength((HttpMessage)message);
    }

    @Test(expected=ProtocolException.class)
    public void testEntityWithInvalidChunkEncodingAndHTTP10() throws Exception {
        StrictContentLengthStrategy lenStrategy = new StrictContentLengthStrategy();
        DummyHttpMessage message = new DummyHttpMessage((ProtocolVersion)HttpVersion.HTTP_1_0);
        message.addHeader("Transfer-Encoding", "chunked");
        lenStrategy.determineLength((HttpMessage)message);
    }

    @Test
    public void testEntityWithContentLength() throws Exception {
        StrictContentLengthStrategy lenStrategy = new StrictContentLengthStrategy();
        DummyHttpMessage message = new DummyHttpMessage();
        message.addHeader("Content-Length", "100");
        Assert.assertEquals((long)100L, (long)lenStrategy.determineLength((HttpMessage)message));
    }

    @Test(expected=ProtocolException.class)
    public void testEntityWithInvalidContentLength() throws Exception {
        StrictContentLengthStrategy lenStrategy = new StrictContentLengthStrategy();
        DummyHttpMessage message = new DummyHttpMessage();
        message.addHeader("Content-Length", "whatever");
        lenStrategy.determineLength((HttpMessage)message);
    }

    @Test(expected=ProtocolException.class)
    public void testEntityWithNegativeContentLength() throws Exception {
        StrictContentLengthStrategy lenStrategy = new StrictContentLengthStrategy();
        DummyHttpMessage message = new DummyHttpMessage();
        message.addHeader("Content-Length", "-10");
        lenStrategy.determineLength((HttpMessage)message);
    }

    @Test
    public void testEntityNoContentDelimiter() throws Exception {
        StrictContentLengthStrategy lenStrategy = new StrictContentLengthStrategy();
        DummyHttpMessage message = new DummyHttpMessage();
        Assert.assertEquals((long)-1L, (long)lenStrategy.determineLength((HttpMessage)message));
    }
}

