/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import org.apache.http.ConnectionClosedException;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.MalformedChunkCodingException;
import org.apache.http.MessageConstraintException;
import org.apache.http.TruncatedChunkException;
import org.apache.http.config.MessageConstraints;
import org.apache.http.impl.SessionInputBufferMock;
import org.apache.http.impl.SessionOutputBufferMock;
import org.apache.http.impl.io.ChunkedInputStream;
import org.apache.http.impl.io.ChunkedOutputStream;
import org.apache.http.impl.io.TimeoutByteArrayInputStream;
import org.apache.http.io.SessionInputBuffer;
import org.apache.http.io.SessionOutputBuffer;
import org.junit.Assert;
import org.junit.Test;

public class TestChunkCoding {
    private static final String CHUNKED_INPUT = "10;key=\"value\"\r\n1234567890123456\r\n5\r\n12345\r\n0\r\nFooter1: abcde\r\nFooter2: fghij\r\n";
    private static final String CHUNKED_RESULT = "123456789012345612345";

    @Test
    public void testConstructors() throws Exception {
        try {
            new ChunkedInputStream((SessionInputBuffer)null);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        new MalformedChunkCodingException();
        new MalformedChunkCodingException("");
    }

    @Test
    public void testChunkedInputStreamLargeBuffer() throws IOException {
        int len;
        ChunkedInputStream in = new ChunkedInputStream((SessionInputBuffer)new SessionInputBufferMock(CHUNKED_INPUT, Consts.ISO_8859_1));
        byte[] buffer = new byte[300];
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        while ((len = in.read(buffer)) > 0) {
            out.write(buffer, 0, len);
        }
        Assert.assertEquals((long)-1L, (long)in.read(buffer));
        Assert.assertEquals((long)-1L, (long)in.read(buffer));
        in.close();
        String result = new String(out.toByteArray(), Consts.ISO_8859_1);
        Assert.assertEquals((Object)result, (Object)CHUNKED_RESULT);
        Header[] footers = in.getFooters();
        Assert.assertNotNull((Object)footers);
        Assert.assertEquals((long)2L, (long)footers.length);
        Assert.assertEquals((Object)"Footer1", (Object)footers[0].getName());
        Assert.assertEquals((Object)"abcde", (Object)footers[0].getValue());
        Assert.assertEquals((Object)"Footer2", (Object)footers[1].getName());
        Assert.assertEquals((Object)"fghij", (Object)footers[1].getValue());
    }

    @Test
    public void testChunkedInputStreamSmallBuffer() throws IOException {
        int len;
        ChunkedInputStream in = new ChunkedInputStream((SessionInputBuffer)new SessionInputBufferMock(CHUNKED_INPUT, Consts.ISO_8859_1));
        byte[] buffer = new byte[7];
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        while ((len = in.read(buffer)) > 0) {
            out.write(buffer, 0, len);
        }
        Assert.assertEquals((long)-1L, (long)in.read(buffer));
        Assert.assertEquals((long)-1L, (long)in.read(buffer));
        in.close();
        Header[] footers = in.getFooters();
        Assert.assertNotNull((Object)footers);
        Assert.assertEquals((long)2L, (long)footers.length);
        Assert.assertEquals((Object)"Footer1", (Object)footers[0].getName());
        Assert.assertEquals((Object)"abcde", (Object)footers[0].getValue());
        Assert.assertEquals((Object)"Footer2", (Object)footers[1].getName());
        Assert.assertEquals((Object)"fghij", (Object)footers[1].getValue());
    }

    @Test
    public void testChunkedInputStreamOneByteRead() throws IOException {
        int ch;
        String s = "5\r\n01234\r\n5\r\n56789\r\n0\r\n";
        ChunkedInputStream in = new ChunkedInputStream((SessionInputBuffer)new SessionInputBufferMock("5\r\n01234\r\n5\r\n56789\r\n0\r\n", Consts.ISO_8859_1));
        int i = 48;
        while ((ch = in.read()) != -1) {
            Assert.assertEquals((long)i, (long)ch);
            ++i;
        }
        Assert.assertEquals((long)-1L, (long)in.read());
        Assert.assertEquals((long)-1L, (long)in.read());
        in.close();
    }

    @Test
    public void testAvailable() throws IOException {
        String s = "5\r\n12345\r\n0\r\n";
        ChunkedInputStream in = new ChunkedInputStream((SessionInputBuffer)new SessionInputBufferMock("5\r\n12345\r\n0\r\n", Consts.ISO_8859_1));
        Assert.assertEquals((long)0L, (long)in.available());
        in.read();
        Assert.assertEquals((long)4L, (long)in.available());
        in.close();
    }

    @Test
    public void testChunkedInputStreamClose() throws IOException {
        String s = "5\r\n01234\r\n5\r\n56789\r\n0\r\n";
        ChunkedInputStream in = new ChunkedInputStream((SessionInputBuffer)new SessionInputBufferMock("5\r\n01234\r\n5\r\n56789\r\n0\r\n", Consts.ISO_8859_1));
        in.close();
        in.close();
        try {
            in.read();
            Assert.fail((String)"IOException should have been thrown");
        }
        catch (IOException ex) {
            // empty catch block
        }
        byte[] tmp = new byte[10];
        try {
            in.read(tmp);
            Assert.fail((String)"IOException should have been thrown");
        }
        catch (IOException ex) {
            // empty catch block
        }
        try {
            in.read(tmp, 0, tmp.length);
            Assert.fail((String)"IOException should have been thrown");
        }
        catch (IOException ex) {
            // empty catch block
        }
    }

    @Test
    public void testChunkedOutputStreamClose() throws IOException {
        ChunkedOutputStream out = new ChunkedOutputStream(2048, (SessionOutputBuffer)new SessionOutputBufferMock());
        out.close();
        out.close();
        try {
            out.write(new byte[]{1, 2, 3});
            Assert.fail((String)"IOException should have been thrown");
        }
        catch (IOException ex) {
            // empty catch block
        }
        try {
            out.write(1);
            Assert.fail((String)"IOException should have been thrown");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test(expected=ConnectionClosedException.class)
    public void testChunkedInputStreamNoClosingChunk() throws IOException {
        String s = "5\r\n01234\r\n";
        ChunkedInputStream in = new ChunkedInputStream((SessionInputBuffer)new SessionInputBufferMock("5\r\n01234\r\n", Consts.ISO_8859_1));
        byte[] tmp = new byte[5];
        Assert.assertEquals((long)5L, (long)in.read(tmp));
        in.read();
        in.close();
    }

    @Test(expected=MalformedChunkCodingException.class)
    public void testCorruptChunkedInputStreamTruncatedCRLF() throws IOException {
        String s = "5\r\n01234";
        ChunkedInputStream in = new ChunkedInputStream((SessionInputBuffer)new SessionInputBufferMock("5\r\n01234", Consts.ISO_8859_1));
        byte[] tmp = new byte[5];
        Assert.assertEquals((long)5L, (long)in.read(tmp));
        in.read();
        in.close();
    }

    @Test(expected=MalformedChunkCodingException.class)
    public void testCorruptChunkedInputStreamMissingCRLF() throws IOException {
        int len;
        String s = "5\r\n012345\r\n56789\r\n0\r\n";
        ChunkedInputStream in = new ChunkedInputStream((SessionInputBuffer)new SessionInputBufferMock("5\r\n012345\r\n56789\r\n0\r\n", Consts.ISO_8859_1));
        byte[] buffer = new byte[300];
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        while ((len = in.read(buffer)) > 0) {
            out.write(buffer, 0, len);
        }
        in.close();
    }

    @Test(expected=MalformedChunkCodingException.class)
    public void testCorruptChunkedInputStreamMissingLF() throws IOException {
        String s = "5\r01234\r\n5\r\n56789\r\n0\r\n";
        ChunkedInputStream in = new ChunkedInputStream((SessionInputBuffer)new SessionInputBufferMock("5\r01234\r\n5\r\n56789\r\n0\r\n", Consts.ISO_8859_1));
        in.read();
        in.close();
    }

    @Test(expected=MalformedChunkCodingException.class)
    public void testCorruptChunkedInputStreamInvalidSize() throws IOException {
        String s = "whatever\r\n01234\r\n5\r\n56789\r\n0\r\n";
        ChunkedInputStream in = new ChunkedInputStream((SessionInputBuffer)new SessionInputBufferMock("whatever\r\n01234\r\n5\r\n56789\r\n0\r\n", Consts.ISO_8859_1));
        in.read();
        in.close();
    }

    @Test(expected=MalformedChunkCodingException.class)
    public void testCorruptChunkedInputStreamNegativeSize() throws IOException {
        String s = "-5\r\n01234\r\n5\r\n56789\r\n0\r\n";
        ChunkedInputStream in = new ChunkedInputStream((SessionInputBuffer)new SessionInputBufferMock("-5\r\n01234\r\n5\r\n56789\r\n0\r\n", Consts.ISO_8859_1));
        in.read();
        in.close();
    }

    @Test(expected=TruncatedChunkException.class)
    public void testCorruptChunkedInputStreamTruncatedChunk() throws IOException {
        String s = "3\r\n12";
        ChunkedInputStream in = new ChunkedInputStream((SessionInputBuffer)new SessionInputBufferMock("3\r\n12", Consts.ISO_8859_1));
        byte[] buffer = new byte[300];
        Assert.assertEquals((long)2L, (long)in.read(buffer));
        in.read(buffer);
        in.close();
    }

    @Test(expected=MalformedChunkCodingException.class)
    public void testCorruptChunkedInputStreamInvalidFooter() throws IOException {
        String s = "1\r\n0\r\n0\r\nstuff\r\n";
        ChunkedInputStream in = new ChunkedInputStream((SessionInputBuffer)new SessionInputBufferMock("1\r\n0\r\n0\r\nstuff\r\n", Consts.ISO_8859_1));
        in.read();
        in.read();
        in.close();
    }

    @Test
    public void testCorruptChunkedInputStreamClose() throws IOException {
        String s = "whatever\r\n01234\r\n5\r\n56789\r\n0\r\n";
        ChunkedInputStream in = new ChunkedInputStream((SessionInputBuffer)new SessionInputBufferMock("whatever\r\n01234\r\n5\r\n56789\r\n0\r\n", Consts.ISO_8859_1));
        try {
            in.read();
            Assert.fail((String)"MalformedChunkCodingException expected");
        }
        catch (MalformedChunkCodingException malformedChunkCodingException) {
            // empty catch block
        }
        in.close();
    }

    @Test
    public void testEmptyChunkedInputStream() throws IOException {
        int len;
        String input = "0\r\n";
        ChunkedInputStream in = new ChunkedInputStream((SessionInputBuffer)new SessionInputBufferMock("0\r\n", Consts.ISO_8859_1));
        byte[] buffer = new byte[300];
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        while ((len = in.read(buffer)) > 0) {
            out.write(buffer, 0, len);
        }
        Assert.assertEquals((long)0L, (long)out.size());
        in.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTooLongChunkHeader() throws IOException {
        String input = "5; and some very looooong commend\r\n12345\r\n0\r\n";
        ChunkedInputStream in1 = new ChunkedInputStream((SessionInputBuffer)new SessionInputBufferMock("5; and some very looooong commend\r\n12345\r\n0\r\n", MessageConstraints.DEFAULT, Consts.ISO_8859_1));
        byte[] buffer = new byte[300];
        Assert.assertEquals((long)5L, (long)in1.read(buffer));
        in1.close();
        ChunkedInputStream in2 = new ChunkedInputStream((SessionInputBuffer)new SessionInputBufferMock("5; and some very looooong commend\r\n12345\r\n0\r\n", MessageConstraints.lineLen((int)10), Consts.ISO_8859_1));
        try {
            in2.read(buffer);
            Assert.fail((String)"MessageConstraintException expected");
        }
        catch (MessageConstraintException ex) {
        }
        finally {
            try {
                in2.close();
            }
            catch (MessageConstraintException ex) {}
        }
    }

    @Test
    public void testChunkedConsistence() throws IOException {
        String input = "76126;27823abcd;:q38a-\nkjc\rk%1ad\tkh/asdui\r\njkh+?\\suweb";
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        ChunkedOutputStream out = new ChunkedOutputStream(2048, (SessionOutputBuffer)new SessionOutputBufferMock(buffer));
        out.write("76126;27823abcd;:q38a-\nkjc\rk%1ad\tkh/asdui\r\njkh+?\\suweb".getBytes(Consts.ISO_8859_1));
        out.flush();
        out.close();
        out.close();
        buffer.close();
        ChunkedInputStream in = new ChunkedInputStream((SessionInputBuffer)new SessionInputBufferMock(buffer.toByteArray()));
        byte[] d = new byte[10];
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        int len = 0;
        while ((len = in.read(d)) > 0) {
            result.write(d, 0, len);
        }
        String output = new String(result.toByteArray(), Consts.ISO_8859_1);
        Assert.assertEquals((Object)"76126;27823abcd;:q38a-\nkjc\rk%1ad\tkh/asdui\r\njkh+?\\suweb", (Object)output);
        in.close();
    }

    @Test
    public void testChunkedOutputStream() throws IOException {
        SessionOutputBufferMock buffer = new SessionOutputBufferMock();
        ChunkedOutputStream out = new ChunkedOutputStream(2, (SessionOutputBuffer)buffer);
        out.write(49);
        out.write(50);
        out.write(51);
        out.write(52);
        out.finish();
        out.close();
        byte[] rawdata = buffer.getData();
        Assert.assertEquals((long)19L, (long)rawdata.length);
        Assert.assertEquals((long)50L, (long)rawdata[0]);
        Assert.assertEquals((long)13L, (long)rawdata[1]);
        Assert.assertEquals((long)10L, (long)rawdata[2]);
        Assert.assertEquals((long)49L, (long)rawdata[3]);
        Assert.assertEquals((long)50L, (long)rawdata[4]);
        Assert.assertEquals((long)13L, (long)rawdata[5]);
        Assert.assertEquals((long)10L, (long)rawdata[6]);
        Assert.assertEquals((long)50L, (long)rawdata[7]);
        Assert.assertEquals((long)13L, (long)rawdata[8]);
        Assert.assertEquals((long)10L, (long)rawdata[9]);
        Assert.assertEquals((long)51L, (long)rawdata[10]);
        Assert.assertEquals((long)52L, (long)rawdata[11]);
        Assert.assertEquals((long)13L, (long)rawdata[12]);
        Assert.assertEquals((long)10L, (long)rawdata[13]);
        Assert.assertEquals((long)48L, (long)rawdata[14]);
        Assert.assertEquals((long)13L, (long)rawdata[15]);
        Assert.assertEquals((long)10L, (long)rawdata[16]);
        Assert.assertEquals((long)13L, (long)rawdata[17]);
        Assert.assertEquals((long)10L, (long)rawdata[18]);
    }

    @Test
    public void testChunkedOutputStreamLargeChunk() throws IOException {
        SessionOutputBufferMock buffer = new SessionOutputBufferMock();
        ChunkedOutputStream out = new ChunkedOutputStream(2, (SessionOutputBuffer)buffer);
        out.write(new byte[]{49, 50, 51, 52});
        out.finish();
        out.close();
        byte[] rawdata = buffer.getData();
        Assert.assertEquals((long)14L, (long)rawdata.length);
        Assert.assertEquals((long)52L, (long)rawdata[0]);
        Assert.assertEquals((long)13L, (long)rawdata[1]);
        Assert.assertEquals((long)10L, (long)rawdata[2]);
        Assert.assertEquals((long)49L, (long)rawdata[3]);
        Assert.assertEquals((long)50L, (long)rawdata[4]);
        Assert.assertEquals((long)51L, (long)rawdata[5]);
        Assert.assertEquals((long)52L, (long)rawdata[6]);
        Assert.assertEquals((long)13L, (long)rawdata[7]);
        Assert.assertEquals((long)10L, (long)rawdata[8]);
        Assert.assertEquals((long)48L, (long)rawdata[9]);
        Assert.assertEquals((long)13L, (long)rawdata[10]);
        Assert.assertEquals((long)10L, (long)rawdata[11]);
        Assert.assertEquals((long)13L, (long)rawdata[12]);
        Assert.assertEquals((long)10L, (long)rawdata[13]);
    }

    @Test
    public void testChunkedOutputStreamSmallChunk() throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        ChunkedOutputStream out = new ChunkedOutputStream(2, (SessionOutputBuffer)new SessionOutputBufferMock(buffer));
        out.write(49);
        out.finish();
        out.close();
        byte[] rawdata = buffer.toByteArray();
        Assert.assertEquals((long)11L, (long)rawdata.length);
        Assert.assertEquals((long)49L, (long)rawdata[0]);
        Assert.assertEquals((long)13L, (long)rawdata[1]);
        Assert.assertEquals((long)10L, (long)rawdata[2]);
        Assert.assertEquals((long)49L, (long)rawdata[3]);
        Assert.assertEquals((long)13L, (long)rawdata[4]);
        Assert.assertEquals((long)10L, (long)rawdata[5]);
        Assert.assertEquals((long)48L, (long)rawdata[6]);
        Assert.assertEquals((long)13L, (long)rawdata[7]);
        Assert.assertEquals((long)10L, (long)rawdata[8]);
        Assert.assertEquals((long)13L, (long)rawdata[9]);
        Assert.assertEquals((long)10L, (long)rawdata[10]);
    }

    @Test
    public void testResumeOnSocketTimeoutInData() throws IOException {
        String s = "5\r\n01234\r\n5\r\n5\u00006789\r\na\r\n0123\u0000456789\r\n0\r\n";
        SessionInputBufferMock sessbuf = new SessionInputBufferMock(new TimeoutByteArrayInputStream("5\r\n01234\r\n5\r\n5\u00006789\r\na\r\n0123\u0000456789\r\n0\r\n".getBytes(Consts.ISO_8859_1)), 16);
        ChunkedInputStream in = new ChunkedInputStream((SessionInputBuffer)sessbuf);
        byte[] tmp = new byte[3];
        int bytesRead = 0;
        int timeouts = 0;
        int i = 0;
        while (i != -1) {
            try {
                i = in.read(tmp);
                if (i <= 0) continue;
                bytesRead += i;
            }
            catch (InterruptedIOException ex) {
                ++timeouts;
            }
        }
        Assert.assertEquals((long)20L, (long)bytesRead);
        Assert.assertEquals((long)2L, (long)timeouts);
        in.close();
    }

    @Test
    public void testResumeOnSocketTimeoutInChunk() throws IOException {
        String s = "5\u0000\r\u0000\n\u000001234\r\n\u00005\r\n56789\r\na\r\n0123456789\r\n\u00000\r\n";
        SessionInputBufferMock sessbuf = new SessionInputBufferMock(new TimeoutByteArrayInputStream("5\u0000\r\u0000\n\u000001234\r\n\u00005\r\n56789\r\na\r\n0123456789\r\n\u00000\r\n".getBytes(Consts.ISO_8859_1)), 16);
        ChunkedInputStream in = new ChunkedInputStream((SessionInputBuffer)sessbuf);
        byte[] tmp = new byte[3];
        int bytesRead = 0;
        int timeouts = 0;
        int i = 0;
        while (i != -1) {
            try {
                i = in.read(tmp);
                if (i <= 0) continue;
                bytesRead += i;
            }
            catch (InterruptedIOException ex) {
                ++timeouts;
            }
        }
        Assert.assertEquals((long)20L, (long)bytesRead);
        Assert.assertEquals((long)5L, (long)timeouts);
        in.close();
    }

    @Test
    public void testHugeChunk() throws IOException {
        ChunkedInputStream in = new ChunkedInputStream((SessionInputBuffer)new SessionInputBufferMock("1234567890abcdef\r\n01234567", Consts.ISO_8859_1));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        for (int i = 0; i < 8; ++i) {
            out.write(in.read());
        }
        String result = new String(out.toByteArray(), Consts.ISO_8859_1);
        Assert.assertEquals((Object)"01234567", (Object)result);
    }
}

