/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.io;

import java.io.ByteArrayOutputStream;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import org.apache.http.Consts;
import org.apache.http.MessageConstraintException;
import org.apache.http.config.MessageConstraints;
import org.apache.http.impl.SessionInputBufferMock;
import org.apache.http.impl.SessionOutputBufferMock;
import org.apache.http.io.HttpTransportMetrics;
import org.apache.http.util.CharArrayBuffer;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestSessionInOutBuffers {
    static final int[] SWISS_GERMAN_HELLO = new int[]{71, 114, 252, 101, 122, 105, 95, 122, 228, 109, 228};
    static final int[] RUSSIAN_HELLO = new int[]{1042, 1089, 1077, 1084, 95, 1087, 1088, 1080, 1074, 1077, 1090};

    @Test
    public void testBasicBufferProperties() throws Exception {
        SessionInputBufferMock inBuffer = new SessionInputBufferMock(new byte[]{1, 2, 3});
        Assert.assertEquals((long)16L, (long)inBuffer.capacity());
        Assert.assertEquals((long)16L, (long)inBuffer.available());
        Assert.assertEquals((long)0L, (long)inBuffer.length());
        inBuffer.read();
        Assert.assertEquals((long)14L, (long)inBuffer.available());
        Assert.assertEquals((long)2L, (long)inBuffer.length());
        SessionOutputBufferMock outbuffer = new SessionOutputBufferMock();
        Assert.assertEquals((long)16L, (long)outbuffer.capacity());
        Assert.assertEquals((long)16L, (long)outbuffer.available());
        Assert.assertEquals((long)0L, (long)outbuffer.length());
        outbuffer.write(new byte[]{1, 2, 3});
        Assert.assertEquals((long)13L, (long)outbuffer.available());
        Assert.assertEquals((long)3L, (long)outbuffer.length());
    }

    @Test
    public void testBasicReadWriteLine() throws Exception {
        String[] teststrs = new String[5];
        teststrs[0] = "Hello";
        teststrs[1] = "This string should be much longer than the size of the output buffer which is only 16 bytes for this test";
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < 15; ++i) {
            buffer.append("123456789 ");
        }
        buffer.append("and stuff like that");
        teststrs[2] = buffer.toString();
        teststrs[3] = "";
        teststrs[4] = "And goodbye";
        CharArrayBuffer chbuffer = new CharArrayBuffer(16);
        SessionOutputBufferMock outbuffer = new SessionOutputBufferMock();
        for (String teststr : teststrs) {
            chbuffer.clear();
            chbuffer.append(teststr);
            outbuffer.writeLine(chbuffer);
        }
        outbuffer.writeLine(null);
        outbuffer.writeLine(null);
        outbuffer.flush();
        HttpTransportMetrics tmetrics = outbuffer.getMetrics();
        long bytesWritten = tmetrics.getBytesTransferred();
        long expected = 0L;
        for (String teststr : teststrs) {
            expected += (long)(teststr.length() + 2);
        }
        Assert.assertEquals((long)expected, (long)bytesWritten);
        SessionInputBufferMock inBuffer = new SessionInputBufferMock(outbuffer.getData());
        for (String teststr : teststrs) {
            Assert.assertEquals((Object)teststr, (Object)inBuffer.readLine());
        }
        Assert.assertNull((Object)inBuffer.readLine());
        Assert.assertNull((Object)inBuffer.readLine());
        tmetrics = inBuffer.getMetrics();
        long bytesRead = tmetrics.getBytesTransferred();
        Assert.assertEquals((long)expected, (long)bytesRead);
    }

    @Test
    public void testComplexReadWriteLine() throws Exception {
        SessionOutputBufferMock outbuffer = new SessionOutputBufferMock();
        outbuffer.write(new byte[]{97, 10});
        outbuffer.write(new byte[]{13, 10});
        outbuffer.write(new byte[]{13, 13, 10});
        outbuffer.write(new byte[]{10});
        outbuffer.write(null);
        outbuffer.write(null, 0, 12);
        outbuffer.flush();
        long bytesWritten = outbuffer.getMetrics().getBytesTransferred();
        Assert.assertEquals((long)8L, (long)bytesWritten);
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < 14; ++i) {
            buffer.append("a");
        }
        String s1 = buffer.toString();
        buffer.append("\r\n");
        outbuffer.write(buffer.toString().getBytes(Consts.ASCII));
        outbuffer.flush();
        bytesWritten = outbuffer.getMetrics().getBytesTransferred();
        Assert.assertEquals((long)24L, (long)bytesWritten);
        buffer.setLength(0);
        for (int i = 0; i < 15; ++i) {
            buffer.append("a");
        }
        String s2 = buffer.toString();
        buffer.append("\r\n");
        outbuffer.write(buffer.toString().getBytes(Consts.ASCII));
        outbuffer.flush();
        bytesWritten = outbuffer.getMetrics().getBytesTransferred();
        Assert.assertEquals((long)41L, (long)bytesWritten);
        buffer.setLength(0);
        for (int i = 0; i < 16; ++i) {
            buffer.append("a");
        }
        String s3 = buffer.toString();
        buffer.append("\r\n");
        outbuffer.write(buffer.toString().getBytes(Consts.ASCII));
        outbuffer.flush();
        bytesWritten = outbuffer.getMetrics().getBytesTransferred();
        Assert.assertEquals((long)59L, (long)bytesWritten);
        outbuffer.write(new byte[]{97});
        outbuffer.flush();
        bytesWritten = outbuffer.getMetrics().getBytesTransferred();
        Assert.assertEquals((long)60L, (long)bytesWritten);
        SessionInputBufferMock inBuffer = new SessionInputBufferMock(outbuffer.getData());
        Assert.assertEquals((Object)"a", (Object)inBuffer.readLine());
        Assert.assertEquals((Object)"", (Object)inBuffer.readLine());
        Assert.assertEquals((Object)"\r", (Object)inBuffer.readLine());
        Assert.assertEquals((Object)"", (Object)inBuffer.readLine());
        Assert.assertEquals((Object)s1, (Object)inBuffer.readLine());
        Assert.assertEquals((Object)s2, (Object)inBuffer.readLine());
        Assert.assertEquals((Object)s3, (Object)inBuffer.readLine());
        Assert.assertEquals((Object)"a", (Object)inBuffer.readLine());
        Assert.assertNull((Object)inBuffer.readLine());
        Assert.assertNull((Object)inBuffer.readLine());
        long bytesRead = inBuffer.getMetrics().getBytesTransferred();
        Assert.assertEquals((long)bytesWritten, (long)bytesRead);
    }

    @Test
    public void testBasicReadWriteLineLargeBuffer() throws Exception {
        String[] teststrs = new String[5];
        teststrs[0] = "Hello";
        teststrs[1] = "This string should be much longer than the size of the output buffer which is only 16 bytes for this test";
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < 15; ++i) {
            buffer.append("123456789 ");
        }
        buffer.append("and stuff like that");
        teststrs[2] = buffer.toString();
        teststrs[3] = "";
        teststrs[4] = "And goodbye";
        CharArrayBuffer chbuffer = new CharArrayBuffer(16);
        SessionOutputBufferMock outbuffer = new SessionOutputBufferMock();
        for (String teststr : teststrs) {
            chbuffer.clear();
            chbuffer.append(teststr);
            outbuffer.writeLine(chbuffer);
        }
        outbuffer.writeLine(null);
        outbuffer.writeLine(null);
        outbuffer.flush();
        long bytesWritten = outbuffer.getMetrics().getBytesTransferred();
        long expected = 0L;
        for (String teststr : teststrs) {
            expected += (long)(teststr.length() + 2);
        }
        Assert.assertEquals((long)expected, (long)bytesWritten);
        SessionInputBufferMock inBuffer = new SessionInputBufferMock(outbuffer.getData(), 1024);
        for (String teststr : teststrs) {
            Assert.assertEquals((Object)teststr, (Object)inBuffer.readLine());
        }
        Assert.assertNull((Object)inBuffer.readLine());
        Assert.assertNull((Object)inBuffer.readLine());
        long bytesRead = inBuffer.getMetrics().getBytesTransferred();
        Assert.assertEquals((long)expected, (long)bytesRead);
    }

    @Test
    public void testReadWriteBytes() throws Exception {
        int readLen;
        int remaining;
        int chunk;
        byte[] out = new byte[40];
        for (int i = 0; i < out.length; ++i) {
            out[i] = (byte)(48 + i);
        }
        SessionOutputBufferMock outbuffer = new SessionOutputBufferMock();
        int off = 0;
        for (remaining = out.length; remaining > 0; remaining -= chunk) {
            chunk = 10;
            if (chunk > remaining) {
                chunk = remaining;
            }
            outbuffer.write(out, off, chunk);
            off += chunk;
        }
        outbuffer.flush();
        long bytesWritten = outbuffer.getMetrics().getBytesTransferred();
        Assert.assertEquals((long)out.length, (long)bytesWritten);
        byte[] tmp = outbuffer.getData();
        Assert.assertEquals((long)out.length, (long)tmp.length);
        for (int i = 0; i < out.length; ++i) {
            Assert.assertEquals((long)out[i], (long)tmp[i]);
        }
        SessionInputBufferMock inBuffer = new SessionInputBufferMock(tmp);
        Assert.assertEquals((long)0L, (long)inBuffer.read(null, 0, 10));
        Assert.assertEquals((long)0L, (long)inBuffer.read(null));
        long bytesRead = inBuffer.getMetrics().getBytesTransferred();
        Assert.assertEquals((long)0L, (long)bytesRead);
        byte[] in = new byte[40];
        off = 0;
        for (remaining = in.length; remaining > 0; remaining -= readLen) {
            int chunk2 = 10;
            if (chunk2 > remaining) {
                chunk2 = remaining;
            }
            if ((readLen = inBuffer.read(in, off, chunk2)) == -1) break;
            off += readLen;
        }
        for (int i = 0; i < out.length; ++i) {
            Assert.assertEquals((long)out[i], (long)in[i]);
        }
        Assert.assertEquals((long)-1L, (long)inBuffer.read(tmp));
        Assert.assertEquals((long)-1L, (long)inBuffer.read(tmp));
        bytesRead = inBuffer.getMetrics().getBytesTransferred();
        Assert.assertEquals((long)out.length, (long)bytesRead);
    }

    @Test
    public void testReadWriteByte() throws Exception {
        int i;
        byte[] out = new byte[40];
        for (int i2 = 0; i2 < out.length; ++i2) {
            out[i2] = (byte)(120 + i2);
        }
        SessionOutputBufferMock outbuffer = new SessionOutputBufferMock();
        for (byte element : out) {
            outbuffer.write(element);
        }
        outbuffer.flush();
        long bytesWritten = outbuffer.getMetrics().getBytesTransferred();
        Assert.assertEquals((long)out.length, (long)bytesWritten);
        byte[] tmp = outbuffer.getData();
        Assert.assertEquals((long)out.length, (long)tmp.length);
        for (int i3 = 0; i3 < out.length; ++i3) {
            Assert.assertEquals((long)out[i3], (long)tmp[i3]);
        }
        SessionInputBufferMock inBuffer = new SessionInputBufferMock(tmp);
        byte[] in = new byte[40];
        for (i = 0; i < in.length; ++i) {
            in[i] = (byte)inBuffer.read();
        }
        for (i = 0; i < out.length; ++i) {
            Assert.assertEquals((long)out[i], (long)in[i]);
        }
        Assert.assertEquals((long)-1L, (long)inBuffer.read());
        Assert.assertEquals((long)-1L, (long)inBuffer.read());
        long bytesRead = inBuffer.getMetrics().getBytesTransferred();
        Assert.assertEquals((long)out.length, (long)bytesRead);
    }

    @Test
    public void testWriteSmallFragmentBuffering() throws Exception {
        ByteArrayOutputStream outStream = (ByteArrayOutputStream)Mockito.spy((Object)new ByteArrayOutputStream());
        SessionOutputBufferMock outbuffer = new SessionOutputBufferMock(outStream, 16, 16, null);
        outbuffer.write(1);
        outbuffer.write(2);
        outbuffer.write(new byte[]{1, 2});
        outbuffer.write(new byte[]{3, 4});
        outbuffer.flush();
        ((ByteArrayOutputStream)Mockito.verify((Object)outStream, (VerificationMode)Mockito.times((int)1))).write((byte[])Matchers.any(), Matchers.anyInt(), Matchers.anyInt());
        ((ByteArrayOutputStream)Mockito.verify((Object)outStream, (VerificationMode)Mockito.never())).write(Matchers.anyInt());
    }

    @Test
    public void testWriteSmallFragmentNoBuffering() throws Exception {
        ByteArrayOutputStream outStream = (ByteArrayOutputStream)Mockito.spy((Object)new ByteArrayOutputStream());
        SessionOutputBufferMock outbuffer = new SessionOutputBufferMock(outStream, 16, 0, null);
        outbuffer.write(1);
        outbuffer.write(2);
        outbuffer.write(new byte[]{1, 2});
        outbuffer.write(new byte[]{3, 4});
        ((ByteArrayOutputStream)Mockito.verify((Object)outStream, (VerificationMode)Mockito.times((int)2))).write((byte[])Matchers.any(), Matchers.anyInt(), Matchers.anyInt());
        ((ByteArrayOutputStream)Mockito.verify((Object)outStream, (VerificationMode)Mockito.times((int)2))).write(Matchers.anyInt());
    }

    @Test
    public void testLineLimit() throws Exception {
        String s = "a very looooooooooooooooooooooooooooooooooooooooooong line\r\n";
        byte[] tmp = "a very looooooooooooooooooooooooooooooooooooooooooong line\r\n".getBytes(Consts.ASCII);
        SessionInputBufferMock inBuffer1 = new SessionInputBufferMock(tmp, 5, MessageConstraints.DEFAULT);
        Assert.assertNotNull((Object)inBuffer1.readLine());
        long bytesRead = inBuffer1.getMetrics().getBytesTransferred();
        Assert.assertEquals((long)60L, (long)bytesRead);
        SessionInputBufferMock inBuffer2 = new SessionInputBufferMock(tmp, 5, MessageConstraints.lineLen((int)15));
        try {
            inBuffer2.readLine();
            Assert.fail((String)"MessageConstraintException expected");
        }
        catch (MessageConstraintException ex) {
            // empty catch block
        }
    }

    @Test
    public void testLineLimit2() throws Exception {
        String s = "just a line\r\n";
        byte[] tmp = "just a line\r\n".getBytes(Consts.ASCII);
        SessionInputBufferMock inBuffer1 = new SessionInputBufferMock(tmp, 25, MessageConstraints.DEFAULT);
        Assert.assertNotNull((Object)inBuffer1.readLine());
        long bytesRead = inBuffer1.getMetrics().getBytesTransferred();
        Assert.assertEquals((long)13L, (long)bytesRead);
        SessionInputBufferMock inBuffer2 = new SessionInputBufferMock(tmp, 25, MessageConstraints.lineLen((int)10));
        try {
            inBuffer2.readLine();
            Assert.fail((String)"MessageConstraintException expected");
        }
        catch (MessageConstraintException ex) {
            // empty catch block
        }
    }

    @Test
    public void testLineLimit3() throws Exception {
        String s = "012345678\r\nblaaaaaaaaaaaaaaaaaah";
        byte[] tmp = "012345678\r\nblaaaaaaaaaaaaaaaaaah".getBytes(Consts.ASCII);
        SessionInputBufferMock inBuffer1 = new SessionInputBufferMock(tmp, 10, MessageConstraints.lineLen((int)20));
        Assert.assertEquals((Object)"012345678", (Object)inBuffer1.readLine());
    }

    @Test
    public void testReadLineFringeCase1() throws Exception {
        String s = "abc\r\n";
        byte[] tmp = "abc\r\n".getBytes(Consts.ASCII);
        SessionInputBufferMock inBuffer1 = new SessionInputBufferMock(tmp, 128);
        Assert.assertEquals((long)97L, (long)inBuffer1.read());
        Assert.assertEquals((long)98L, (long)inBuffer1.read());
        Assert.assertEquals((long)99L, (long)inBuffer1.read());
        Assert.assertEquals((long)13L, (long)inBuffer1.read());
        Assert.assertEquals((Object)"", (Object)inBuffer1.readLine());
    }

    private static String constructString(int[] unicodeChars) {
        StringBuilder buffer = new StringBuilder();
        if (unicodeChars != null) {
            for (int unicodeChar : unicodeChars) {
                buffer.append((char)unicodeChar);
            }
        }
        return buffer.toString();
    }

    @Test
    public void testMultibyteCodedReadWriteLine() throws Exception {
        String s1 = TestSessionInOutBuffers.constructString(SWISS_GERMAN_HELLO);
        String s2 = TestSessionInOutBuffers.constructString(RUSSIAN_HELLO);
        String s3 = "Like hello and stuff";
        SessionOutputBufferMock outbuffer = new SessionOutputBufferMock(Consts.UTF_8);
        CharArrayBuffer chbuffer = new CharArrayBuffer(16);
        for (int i = 0; i < 10; ++i) {
            chbuffer.clear();
            chbuffer.append(s1);
            outbuffer.writeLine(chbuffer);
            chbuffer.clear();
            chbuffer.append(s2);
            outbuffer.writeLine(chbuffer);
            chbuffer.clear();
            chbuffer.append("Like hello and stuff");
            outbuffer.writeLine(chbuffer);
        }
        outbuffer.flush();
        long bytesWritten = outbuffer.getMetrics().getBytesTransferred();
        long expected = (s1.getBytes(Consts.UTF_8).length + 2 + (s2.getBytes(Consts.UTF_8).length + 2) + ("Like hello and stuff".getBytes(Consts.UTF_8).length + 2)) * 10;
        Assert.assertEquals((long)expected, (long)bytesWritten);
        SessionInputBufferMock inBuffer = new SessionInputBufferMock(outbuffer.getData(), Consts.UTF_8);
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals((Object)s1, (Object)inBuffer.readLine());
            Assert.assertEquals((Object)s2, (Object)inBuffer.readLine());
            Assert.assertEquals((Object)"Like hello and stuff", (Object)inBuffer.readLine());
        }
        Assert.assertNull((Object)inBuffer.readLine());
        Assert.assertNull((Object)inBuffer.readLine());
        long bytesRead = inBuffer.getMetrics().getBytesTransferred();
        Assert.assertEquals((long)expected, (long)bytesRead);
    }

    @Test
    public void testMultibyteCodedReadWriteLongLine() throws Exception {
        String s1 = TestSessionInOutBuffers.constructString(SWISS_GERMAN_HELLO);
        String s2 = TestSessionInOutBuffers.constructString(RUSSIAN_HELLO);
        String s3 = "Like hello and stuff";
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < 1024; ++i) {
            buf.append(s1).append(s2).append("Like hello and stuff");
        }
        String s = buf.toString();
        SessionOutputBufferMock outbuffer = new SessionOutputBufferMock(Consts.UTF_8);
        CharArrayBuffer chbuffer = new CharArrayBuffer(16);
        chbuffer.append(s);
        outbuffer.writeLine(chbuffer);
        outbuffer.flush();
        SessionInputBufferMock inBuffer = new SessionInputBufferMock(outbuffer.getData(), Consts.UTF_8);
        Assert.assertEquals((Object)s, (Object)inBuffer.readLine());
    }

    @Test
    public void testNonAsciiReadWriteLine() throws Exception {
        int i;
        String s1 = TestSessionInOutBuffers.constructString(SWISS_GERMAN_HELLO);
        SessionOutputBufferMock outbuffer = new SessionOutputBufferMock(Consts.ISO_8859_1);
        CharArrayBuffer chbuffer = new CharArrayBuffer(16);
        for (i = 0; i < 5; ++i) {
            chbuffer.clear();
            chbuffer.append(s1);
            outbuffer.writeLine(chbuffer);
        }
        for (i = 0; i < 5; ++i) {
            outbuffer.writeLine(s1);
        }
        chbuffer.clear();
        outbuffer.writeLine(chbuffer);
        outbuffer.flush();
        long bytesWritten = outbuffer.getMetrics().getBytesTransferred();
        long expected = (s1.toString().getBytes(Consts.ISO_8859_1).length + 2) * 10 + 2;
        Assert.assertEquals((long)expected, (long)bytesWritten);
        SessionInputBufferMock inBuffer = new SessionInputBufferMock(outbuffer.getData(), Consts.ISO_8859_1);
        CharArrayBuffer buf = new CharArrayBuffer(64);
        for (int i2 = 0; i2 < 10; ++i2) {
            buf.clear();
            int readLen = inBuffer.readLine(buf);
            Assert.assertEquals((long)readLen, (long)SWISS_GERMAN_HELLO.length);
            Assert.assertEquals((Object)s1, (Object)buf.toString());
        }
        buf.clear();
        Assert.assertEquals((Object)"", (Object)inBuffer.readLine());
        Assert.assertNull((Object)inBuffer.readLine());
        Assert.assertNull((Object)inBuffer.readLine());
        long bytesRead = inBuffer.getMetrics().getBytesTransferred();
        Assert.assertEquals((long)expected, (long)bytesRead);
    }

    @Test(expected=CharacterCodingException.class)
    public void testUnmappableInputActionReport() throws Exception {
        String s = "This text contains a circumflex \u0302 !!!";
        CharsetEncoder encoder = Consts.ISO_8859_1.newEncoder();
        encoder.onMalformedInput(CodingErrorAction.IGNORE);
        encoder.onUnmappableCharacter(CodingErrorAction.REPORT);
        SessionOutputBufferMock outbuf = new SessionOutputBufferMock(encoder);
        outbuf.writeLine("This text contains a circumflex \u0302 !!!");
    }

    @Test
    public void testUnmappableInputActionReplace() throws Exception {
        String s = "This text contains a circumflex \u0302 !!!";
        CharsetEncoder encoder = Consts.ISO_8859_1.newEncoder();
        encoder.onMalformedInput(CodingErrorAction.IGNORE);
        encoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
        SessionOutputBufferMock outbuf = new SessionOutputBufferMock(encoder);
        outbuf.writeLine("This text contains a circumflex \u0302 !!!");
        outbuf.flush();
        String result = new String(outbuf.getData(), "ISO-8859-1");
        Assert.assertEquals((Object)"This text contains a circumflex ? !!!\r\n", (Object)result);
    }

    @Test
    public void testUnmappableInputActionIgnore() throws Exception {
        String s = "This text contains a circumflex \u0302 !!!";
        CharsetEncoder encoder = Consts.ISO_8859_1.newEncoder();
        encoder.onMalformedInput(CodingErrorAction.IGNORE);
        encoder.onUnmappableCharacter(CodingErrorAction.IGNORE);
        SessionOutputBufferMock outbuf = new SessionOutputBufferMock(encoder);
        outbuf.writeLine("This text contains a circumflex \u0302 !!!");
        outbuf.flush();
        String result = new String(outbuf.getData(), "ISO-8859-1");
        Assert.assertEquals((Object)"This text contains a circumflex  !!!\r\n", (Object)result);
    }

    @Test(expected=CharacterCodingException.class)
    public void testMalformedInputActionReport() throws Exception {
        byte[] tmp = TestSessionInOutBuffers.constructString(SWISS_GERMAN_HELLO).getBytes(Consts.ISO_8859_1);
        CharsetDecoder decoder = Consts.UTF_8.newDecoder();
        decoder.onMalformedInput(CodingErrorAction.REPORT);
        decoder.onUnmappableCharacter(CodingErrorAction.IGNORE);
        SessionInputBufferMock inBuffer = new SessionInputBufferMock(tmp, decoder);
        inBuffer.readLine();
    }

    @Test
    public void testMalformedInputActionReplace() throws Exception {
        byte[] tmp = TestSessionInOutBuffers.constructString(SWISS_GERMAN_HELLO).getBytes(Consts.ISO_8859_1);
        CharsetDecoder decoder = Consts.UTF_8.newDecoder();
        decoder.onMalformedInput(CodingErrorAction.REPLACE);
        decoder.onUnmappableCharacter(CodingErrorAction.IGNORE);
        SessionInputBufferMock inBuffer = new SessionInputBufferMock(tmp, decoder);
        String s = inBuffer.readLine();
        Assert.assertEquals((Object)"Gr\ufffdezi_z\ufffdm\ufffd", (Object)s);
    }

    @Test
    public void testMalformedInputActionIgnore() throws Exception {
        byte[] tmp = TestSessionInOutBuffers.constructString(SWISS_GERMAN_HELLO).getBytes(Consts.ISO_8859_1);
        CharsetDecoder decoder = Consts.UTF_8.newDecoder();
        decoder.onMalformedInput(CodingErrorAction.IGNORE);
        decoder.onUnmappableCharacter(CodingErrorAction.IGNORE);
        SessionInputBufferMock inBuffer = new SessionInputBufferMock(tmp, decoder);
        String s = inBuffer.readLine();
        Assert.assertEquals((Object)"Grezi_zm", (Object)s);
    }

    @Test
    public void testInvalidCharArrayBuffer() throws Exception {
        SessionInputBufferMock inBuffer = new SessionInputBufferMock(new byte[0]);
        try {
            inBuffer.readLine(null);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException ex) {
            long bytesRead = inBuffer.getMetrics().getBytesTransferred();
            Assert.assertEquals((long)0L, (long)bytesRead);
        }
    }
}

