/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.pool;

import java.net.ServerSocket;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;
import org.apache.http.HttpClientConnection;
import org.apache.http.HttpHost;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.SocketConfig;
import org.apache.http.impl.pool.BasicConnFactory;
import org.apache.http.impl.pool.BasicConnPool;
import org.apache.http.impl.pool.BasicPoolEntry;
import org.apache.http.pool.ConnFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestBasicConnPool {
    private BasicConnFactory connFactory;
    private BasicConnPool pool;
    private HttpHost host;
    private HttpClientConnection conn;
    private ServerSocket server;
    private int serverPort;
    private int sslServerPort;

    @Before
    public void setUp() throws Exception {
        this.server = new ServerSocket(0);
        this.serverPort = this.server.getLocalPort();
        SSLServerSocket sslServer = (SSLServerSocket)SSLServerSocketFactory.getDefault().createServerSocket(0);
        this.sslServerPort = sslServer.getLocalPort();
        SocketConfig sconfig = SocketConfig.custom().setSoTimeout(100).build();
        this.connFactory = new BasicConnFactory(sconfig, ConnectionConfig.DEFAULT);
        this.pool = new BasicConnPool((ConnFactory)this.connFactory);
    }

    @After
    public void tearDown() throws Exception {
        this.server.close();
        if (this.conn != null) {
            this.conn.close();
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullConstructor2() throws Exception {
        new BasicConnPool((ConnFactory)((BasicConnFactory)null));
    }

    @Test
    public void testHttpCreateConnection() throws Exception {
        this.host = new HttpHost("localhost", this.serverPort, "http");
        this.conn = this.connFactory.create(this.host);
        Assert.assertTrue((boolean)this.conn.isOpen());
        Assert.assertEquals((long)100L, (long)this.conn.getSocketTimeout());
    }

    @Test
    public void testHttpsCreateConnection() throws Exception {
        SocketConfig sconfig = SocketConfig.custom().setSoTimeout(100).build();
        this.connFactory = new BasicConnFactory(null, (SSLSocketFactory)SSLSocketFactory.getDefault(), 0, sconfig, ConnectionConfig.DEFAULT);
        this.host = new HttpHost("localhost", this.sslServerPort, "https");
        this.conn = this.connFactory.create(this.host);
        Assert.assertTrue((boolean)this.conn.isOpen());
        Assert.assertEquals((long)100L, (long)this.conn.getSocketTimeout());
    }

    @Test
    public void testHttpCreateEntry() throws Exception {
        this.host = new HttpHost("localhost", this.serverPort, "http");
        this.conn = this.connFactory.create(this.host);
        BasicPoolEntry entry = this.pool.createEntry(this.host, this.conn);
        Assert.assertEquals((Object)this.conn, (Object)entry.getConnection());
        Assert.assertEquals((Object)"localhost", (Object)((HttpHost)entry.getRoute()).getHostName());
        entry.close();
    }
}

