/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.message;

import org.apache.http.Header;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.message.AbstractHttpMessage;
import org.apache.http.message.BasicHeader;
import org.junit.Assert;
import org.junit.Test;

public class TestAbstractMessage {
    @Test
    public void testBasicProperties() {
        TestHttpMessage message = new TestHttpMessage();
        Assert.assertNotNull((Object)message.headerIterator());
        Header[] headers = message.getAllHeaders();
        Assert.assertNotNull((Object)headers);
        Assert.assertEquals((long)0L, (long)headers.length);
    }

    @Test
    public void testBasicHeaderOps() {
        TestHttpMessage message = new TestHttpMessage();
        Assert.assertFalse((boolean)message.containsHeader("whatever"));
        message.addHeader("name", "1");
        message.addHeader("name", "2");
        Header[] headers = message.getAllHeaders();
        Assert.assertNotNull((Object)headers);
        Assert.assertEquals((long)2L, (long)headers.length);
        Header h = message.getFirstHeader("name");
        Assert.assertNotNull((Object)h);
        Assert.assertEquals((Object)"1", (Object)h.getValue());
        message.setHeader("name", "3");
        h = message.getFirstHeader("name");
        Assert.assertNotNull((Object)h);
        Assert.assertEquals((Object)"3", (Object)h.getValue());
        h = message.getLastHeader("name");
        Assert.assertNotNull((Object)h);
        Assert.assertEquals((Object)"2", (Object)h.getValue());
        message.addHeader(null);
        message.setHeader(null);
        headers = message.getHeaders("name");
        Assert.assertNotNull((Object)headers);
        Assert.assertEquals((long)2L, (long)headers.length);
        Assert.assertEquals((Object)"3", (Object)headers[0].getValue());
        Assert.assertEquals((Object)"2", (Object)headers[1].getValue());
        message.addHeader("name", "4");
        headers[1] = new BasicHeader("name", "5");
        message.setHeaders(headers);
        headers = message.getHeaders("name");
        Assert.assertNotNull((Object)headers);
        Assert.assertEquals((long)2L, (long)headers.length);
        Assert.assertEquals((Object)"3", (Object)headers[0].getValue());
        Assert.assertEquals((Object)"5", (Object)headers[1].getValue());
        message.setHeader("whatever", null);
        message.removeHeaders("name");
        message.removeHeaders(null);
        headers = message.getAllHeaders();
        Assert.assertNotNull((Object)headers);
        Assert.assertEquals((long)1L, (long)headers.length);
        Assert.assertEquals(null, (Object)headers[0].getValue());
        message.removeHeader(message.getFirstHeader("whatever"));
        headers = message.getAllHeaders();
        Assert.assertNotNull((Object)headers);
        Assert.assertEquals((long)0L, (long)headers.length);
    }

    @Test
    public void testInvalidInput() {
        TestHttpMessage message = new TestHttpMessage();
        try {
            message.addHeader(null, null);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            message.setHeader(null, null);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    static class TestHttpMessage
    extends AbstractHttpMessage {
        private final ProtocolVersion ver;

        public TestHttpMessage(ProtocolVersion ver) {
            this.ver = ver != null ? ver : HttpVersion.HTTP_1_1;
        }

        public TestHttpMessage() {
            this((ProtocolVersion)HttpVersion.HTTP_1_1);
        }

        public ProtocolVersion getProtocolVersion() {
            return this.ver;
        }
    }
}

