/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.message;

import java.util.NoSuchElementException;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HeaderIterator;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicHeaderElementIterator;
import org.apache.http.message.BasicHeaderIterator;
import org.junit.Assert;
import org.junit.Test;

public class TestBasicHeaderElementIterator {
    @Test
    public void testMultiHeader() {
        Header[] headers = new Header[]{new BasicHeader("Name", "value0"), new BasicHeader("Name", "value1")};
        BasicHeaderElementIterator hei = new BasicHeaderElementIterator((HeaderIterator)new BasicHeaderIterator(headers, "Name"));
        Assert.assertTrue((boolean)hei.hasNext());
        HeaderElement elem = hei.nextElement();
        Assert.assertEquals((String)"The two header values must be equal", (Object)"value0", (Object)elem.getName());
        Assert.assertTrue((boolean)hei.hasNext());
        elem = hei.nextElement();
        Assert.assertEquals((String)"The two header values must be equal", (Object)"value1", (Object)elem.getName());
        Assert.assertFalse((boolean)hei.hasNext());
        try {
            hei.next();
            Assert.fail((String)"NoSuchElementException should have been thrown");
        }
        catch (NoSuchElementException ex) {
            // empty catch block
        }
        Assert.assertFalse((boolean)hei.hasNext());
        try {
            hei.next();
            Assert.fail((String)"NoSuchElementException should have been thrown");
        }
        catch (NoSuchElementException ex) {
            // empty catch block
        }
    }

    @Test
    public void testMultiHeaderSameLine() {
        Header[] headers = new Header[]{new BasicHeader("name", "value0,value1"), new BasicHeader("nAme", "cookie1=1,cookie2=2")};
        BasicHeaderElementIterator hei = new BasicHeaderElementIterator((HeaderIterator)new BasicHeaderIterator(headers, "Name"));
        HeaderElement elem = hei.nextElement();
        Assert.assertEquals((String)"The two header values must be equal", (Object)"value0", (Object)elem.getName());
        elem = hei.nextElement();
        Assert.assertEquals((String)"The two header values must be equal", (Object)"value1", (Object)elem.getName());
        elem = hei.nextElement();
        Assert.assertEquals((String)"The two header values must be equal", (Object)"cookie1", (Object)elem.getName());
        Assert.assertEquals((String)"The two header values must be equal", (Object)"1", (Object)elem.getValue());
        elem = hei.nextElement();
        Assert.assertEquals((String)"The two header values must be equal", (Object)"cookie2", (Object)elem.getName());
        Assert.assertEquals((String)"The two header values must be equal", (Object)"2", (Object)elem.getValue());
    }

    @Test
    public void testFringeCases() {
        Header[] headers = new Header[]{new BasicHeader("Name", null), new BasicHeader("Name", "    "), new BasicHeader("Name", ",,,")};
        BasicHeaderElementIterator hei = new BasicHeaderElementIterator((HeaderIterator)new BasicHeaderIterator(headers, "Name"));
        Assert.assertFalse((boolean)hei.hasNext());
        try {
            hei.next();
            Assert.fail((String)"NoSuchElementException should have been thrown");
        }
        catch (NoSuchElementException ex) {
            // empty catch block
        }
        Assert.assertFalse((boolean)hei.hasNext());
        try {
            hei.next();
            Assert.fail((String)"NoSuchElementException should have been thrown");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }
}

