/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.message;

import org.apache.http.HeaderElement;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicHeaderElement;
import org.apache.http.message.BasicHeaderValueFormatter;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.message.HeaderValueFormatter;
import org.junit.Assert;
import org.junit.Test;

public class TestBasicHeaderValueFormatter {
    @Test
    public void testNVPFormatting() throws Exception {
        BasicNameValuePair param1 = new BasicNameValuePair("param", "regular_stuff");
        BasicNameValuePair param2 = new BasicNameValuePair("param", "this\\that");
        BasicNameValuePair param3 = new BasicNameValuePair("param", "this,that");
        BasicNameValuePair param4 = new BasicNameValuePair("param", "quote marks (\") must be escaped");
        BasicNameValuePair param5 = new BasicNameValuePair("param", "back slash (\\) must be escaped too");
        BasicNameValuePair param6 = new BasicNameValuePair("param", "values with\tblanks must always be quoted");
        BasicNameValuePair param7 = new BasicNameValuePair("param", null);
        Assert.assertEquals((Object)"param=regular_stuff", (Object)BasicHeaderValueFormatter.formatNameValuePair((NameValuePair)param1, (boolean)false, null));
        Assert.assertEquals((Object)"param=\"this\\\\that\"", (Object)BasicHeaderValueFormatter.formatNameValuePair((NameValuePair)param2, (boolean)false, null));
        Assert.assertEquals((Object)"param=\"this,that\"", (Object)BasicHeaderValueFormatter.formatNameValuePair((NameValuePair)param3, (boolean)false, null));
        Assert.assertEquals((Object)"param=\"quote marks (\\\") must be escaped\"", (Object)BasicHeaderValueFormatter.formatNameValuePair((NameValuePair)param4, (boolean)false, null));
        Assert.assertEquals((Object)"param=\"back slash (\\\\) must be escaped too\"", (Object)BasicHeaderValueFormatter.formatNameValuePair((NameValuePair)param5, (boolean)false, null));
        Assert.assertEquals((Object)"param=\"values with\tblanks must always be quoted\"", (Object)BasicHeaderValueFormatter.formatNameValuePair((NameValuePair)param6, (boolean)false, null));
        Assert.assertEquals((Object)"param", (Object)BasicHeaderValueFormatter.formatNameValuePair((NameValuePair)param7, (boolean)false, null));
        Assert.assertEquals((Object)"param=\"regular_stuff\"", (Object)BasicHeaderValueFormatter.formatNameValuePair((NameValuePair)param1, (boolean)true, null));
        Assert.assertEquals((Object)"param=\"this\\\\that\"", (Object)BasicHeaderValueFormatter.formatNameValuePair((NameValuePair)param2, (boolean)true, null));
        Assert.assertEquals((Object)"param=\"this,that\"", (Object)BasicHeaderValueFormatter.formatNameValuePair((NameValuePair)param3, (boolean)true, null));
        Assert.assertEquals((Object)"param=\"quote marks (\\\") must be escaped\"", (Object)BasicHeaderValueFormatter.formatNameValuePair((NameValuePair)param4, (boolean)true, null));
        Assert.assertEquals((Object)"param=\"back slash (\\\\) must be escaped too\"", (Object)BasicHeaderValueFormatter.formatNameValuePair((NameValuePair)param5, (boolean)true, null));
        Assert.assertEquals((Object)"param=\"values with\tblanks must always be quoted\"", (Object)BasicHeaderValueFormatter.formatNameValuePair((NameValuePair)param6, (boolean)true, null));
        Assert.assertEquals((Object)"param", (Object)BasicHeaderValueFormatter.formatNameValuePair((NameValuePair)param7, (boolean)false, null));
    }

    @Test
    public void testParamsFormatting() throws Exception {
        BasicNameValuePair param1 = new BasicNameValuePair("param", "regular_stuff");
        BasicNameValuePair param2 = new BasicNameValuePair("param", "this\\that");
        BasicNameValuePair param3 = new BasicNameValuePair("param", "this,that");
        NameValuePair[] params = new NameValuePair[]{param1, param2, param3};
        Assert.assertEquals((Object)"param=regular_stuff; param=\"this\\\\that\"; param=\"this,that\"", (Object)BasicHeaderValueFormatter.formatParameters((NameValuePair[])params, (boolean)false, null));
        Assert.assertEquals((Object)"param=\"regular_stuff\"; param=\"this\\\\that\"; param=\"this,that\"", (Object)BasicHeaderValueFormatter.formatParameters((NameValuePair[])params, (boolean)true, null));
    }

    @Test
    public void testHEFormatting() throws Exception {
        BasicNameValuePair param1 = new BasicNameValuePair("param", "regular_stuff");
        BasicNameValuePair param2 = new BasicNameValuePair("param", "this\\that");
        BasicNameValuePair param3 = new BasicNameValuePair("param", "this,that");
        BasicNameValuePair param4 = new BasicNameValuePair("param", null);
        NameValuePair[] params = new NameValuePair[]{param1, param2, param3, param4};
        BasicHeaderElement element = new BasicHeaderElement("name", "value", params);
        Assert.assertEquals((Object)"name=value; param=regular_stuff; param=\"this\\\\that\"; param=\"this,that\"; param", (Object)BasicHeaderValueFormatter.formatHeaderElement((HeaderElement)element, (boolean)false, null));
    }

    @Test
    public void testElementsFormatting() throws Exception {
        BasicNameValuePair param1 = new BasicNameValuePair("param", "regular_stuff");
        BasicNameValuePair param2 = new BasicNameValuePair("param", "this\\that");
        BasicNameValuePair param3 = new BasicNameValuePair("param", "this,that");
        BasicNameValuePair param4 = new BasicNameValuePair("param", null);
        BasicHeaderElement element1 = new BasicHeaderElement("name1", "value1", new NameValuePair[]{param1});
        BasicHeaderElement element2 = new BasicHeaderElement("name2", "value2", new NameValuePair[]{param2});
        BasicHeaderElement element3 = new BasicHeaderElement("name3", "value3", new NameValuePair[]{param3});
        BasicHeaderElement element4 = new BasicHeaderElement("name4", "value4", new NameValuePair[]{param4});
        BasicHeaderElement element5 = new BasicHeaderElement("name5", null);
        HeaderElement[] elements = new HeaderElement[]{element1, element2, element3, element4, element5};
        Assert.assertEquals((Object)"name1=value1; param=regular_stuff, name2=value2; param=\"this\\\\that\", name3=value3; param=\"this,that\", name4=value4; param, name5", (Object)BasicHeaderValueFormatter.formatElements((HeaderElement[])elements, (boolean)false, null));
    }

    @Test
    public void testInvalidHEArguments() throws Exception {
        try {
            BasicHeaderValueFormatter.formatHeaderElement((HeaderElement)null, (boolean)false, (HeaderValueFormatter)BasicHeaderValueFormatter.INSTANCE);
            Assert.fail((String)"IllegalArgumentException should habe been thrown");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            BasicHeaderValueFormatter.formatElements((HeaderElement[])null, (boolean)false, (HeaderValueFormatter)BasicHeaderValueFormatter.INSTANCE);
            Assert.fail((String)"IllegalArgumentException should habe been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testInvalidNVArguments() throws Exception {
        try {
            BasicHeaderValueFormatter.formatNameValuePair((NameValuePair)null, (boolean)true, null);
            Assert.fail((String)"IllegalArgumentException should habe been thrown");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            BasicHeaderValueFormatter.formatParameters((NameValuePair[])null, (boolean)true, (HeaderValueFormatter)BasicHeaderValueFormatter.INSTANCE);
            Assert.fail((String)"IllegalArgumentException should habe been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

