/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.message;

import org.apache.http.HeaderElement;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicHeaderValueParser;
import org.apache.http.message.ParserCursor;
import org.apache.http.util.CharArrayBuffer;
import org.junit.Assert;
import org.junit.Test;

public class TestBasicHeaderValueParser {
    @Test
    public void testParseHeaderElements() throws Exception {
        String headerValue = "name1 = value1; name2; name3=\"value3\" , name4=value4; name5=value5, name6= ; name7 = value7; name8 = \" value8\"";
        HeaderElement[] elements = BasicHeaderValueParser.parseElements((String)"name1 = value1; name2; name3=\"value3\" , name4=value4; name5=value5, name6= ; name7 = value7; name8 = \" value8\"", null);
        Assert.assertEquals((long)3L, (long)elements.length);
        Assert.assertEquals((Object)"name1", (Object)elements[0].getName());
        Assert.assertEquals((Object)"value1", (Object)elements[0].getValue());
        Assert.assertEquals((long)2L, (long)elements[0].getParameters().length);
        Assert.assertEquals((Object)"name2", (Object)elements[0].getParameters()[0].getName());
        Assert.assertEquals(null, (Object)elements[0].getParameters()[0].getValue());
        Assert.assertEquals((Object)"name3", (Object)elements[0].getParameters()[1].getName());
        Assert.assertEquals((Object)"value3", (Object)elements[0].getParameters()[1].getValue());
        Assert.assertEquals((Object)"name4", (Object)elements[1].getName());
        Assert.assertEquals((Object)"value4", (Object)elements[1].getValue());
        Assert.assertEquals((long)1L, (long)elements[1].getParameters().length);
        Assert.assertEquals((Object)"name5", (Object)elements[1].getParameters()[0].getName());
        Assert.assertEquals((Object)"value5", (Object)elements[1].getParameters()[0].getValue());
        Assert.assertEquals((Object)"name6", (Object)elements[2].getName());
        Assert.assertEquals((Object)"", (Object)elements[2].getValue());
        Assert.assertEquals((long)2L, (long)elements[2].getParameters().length);
        Assert.assertEquals((Object)"name7", (Object)elements[2].getParameters()[0].getName());
        Assert.assertEquals((Object)"value7", (Object)elements[2].getParameters()[0].getValue());
        Assert.assertEquals((Object)"name8", (Object)elements[2].getParameters()[1].getName());
        Assert.assertEquals((Object)" value8", (Object)elements[2].getParameters()[1].getValue());
    }

    @Test
    public void testParseHEEscaped() {
        String s = "test1 =  \"\\\"stuff\\\"\", test2= \"\\\\\", test3 = \"stuff, stuff\"";
        HeaderElement[] elements = BasicHeaderValueParser.parseElements((String)"test1 =  \"\\\"stuff\\\"\", test2= \"\\\\\", test3 = \"stuff, stuff\"", null);
        Assert.assertEquals((long)3L, (long)elements.length);
        Assert.assertEquals((Object)"test1", (Object)elements[0].getName());
        Assert.assertEquals((Object)"\"stuff\"", (Object)elements[0].getValue());
        Assert.assertEquals((Object)"test2", (Object)elements[1].getName());
        Assert.assertEquals((Object)"\\", (Object)elements[1].getValue());
        Assert.assertEquals((Object)"test3", (Object)elements[2].getName());
        Assert.assertEquals((Object)"stuff, stuff", (Object)elements[2].getValue());
    }

    @Test
    public void testHEFringeCase1() throws Exception {
        String headerValue = "name1 = value1,";
        HeaderElement[] elements = BasicHeaderValueParser.parseElements((String)"name1 = value1,", null);
        Assert.assertEquals((String)"Number of elements", (long)1L, (long)elements.length);
    }

    @Test
    public void testHEFringeCase2() throws Exception {
        String headerValue = "name1 = value1, ";
        HeaderElement[] elements = BasicHeaderValueParser.parseElements((String)"name1 = value1, ", null);
        Assert.assertEquals((String)"Number of elements", (long)1L, (long)elements.length);
    }

    @Test
    public void testHEFringeCase3() throws Exception {
        String headerValue = ",, ,, ,";
        HeaderElement[] elements = BasicHeaderValueParser.parseElements((String)",, ,, ,", null);
        Assert.assertEquals((String)"Number of elements", (long)0L, (long)elements.length);
    }

    @Test
    public void testNVParseUsingCursor() {
        BasicHeaderValueParser parser = BasicHeaderValueParser.INSTANCE;
        String s = "test";
        CharArrayBuffer buffer = new CharArrayBuffer(16);
        buffer.append(s);
        ParserCursor cursor = new ParserCursor(0, s.length());
        NameValuePair param = parser.parseNameValuePair(buffer, cursor);
        Assert.assertEquals((Object)"test", (Object)param.getName());
        Assert.assertEquals(null, (Object)param.getValue());
        Assert.assertEquals((long)s.length(), (long)cursor.getPos());
        Assert.assertTrue((boolean)cursor.atEnd());
        s = "test;";
        buffer = new CharArrayBuffer(16);
        buffer.append(s);
        cursor = new ParserCursor(0, s.length());
        param = parser.parseNameValuePair(buffer, cursor);
        Assert.assertEquals((Object)"test", (Object)param.getName());
        Assert.assertEquals(null, (Object)param.getValue());
        Assert.assertEquals((long)s.length(), (long)cursor.getPos());
        Assert.assertTrue((boolean)cursor.atEnd());
        s = "test  ,12";
        buffer = new CharArrayBuffer(16);
        buffer.append(s);
        cursor = new ParserCursor(0, s.length());
        param = parser.parseNameValuePair(buffer, cursor);
        Assert.assertEquals((Object)"test", (Object)param.getName());
        Assert.assertEquals(null, (Object)param.getValue());
        Assert.assertEquals((long)(s.length() - 2), (long)cursor.getPos());
        Assert.assertFalse((boolean)cursor.atEnd());
        s = "test=stuff";
        buffer = new CharArrayBuffer(16);
        buffer.append(s);
        cursor = new ParserCursor(0, s.length());
        param = parser.parseNameValuePair(buffer, cursor);
        Assert.assertEquals((Object)"test", (Object)param.getName());
        Assert.assertEquals((Object)"stuff", (Object)param.getValue());
        Assert.assertEquals((long)s.length(), (long)cursor.getPos());
        Assert.assertTrue((boolean)cursor.atEnd());
        s = "   test  =   stuff ";
        buffer = new CharArrayBuffer(16);
        buffer.append(s);
        cursor = new ParserCursor(0, s.length());
        param = parser.parseNameValuePair(buffer, cursor);
        Assert.assertEquals((Object)"test", (Object)param.getName());
        Assert.assertEquals((Object)"stuff", (Object)param.getValue());
        Assert.assertEquals((long)s.length(), (long)cursor.getPos());
        Assert.assertTrue((boolean)cursor.atEnd());
        s = "   test  =   stuff ;1234";
        buffer = new CharArrayBuffer(16);
        buffer.append(s);
        cursor = new ParserCursor(0, s.length());
        param = parser.parseNameValuePair(buffer, cursor);
        Assert.assertEquals((Object)"test", (Object)param.getName());
        Assert.assertEquals((Object)"stuff", (Object)param.getValue());
        Assert.assertEquals((long)(s.length() - 4), (long)cursor.getPos());
        Assert.assertFalse((boolean)cursor.atEnd());
        s = "test  = \"stuff\"";
        buffer = new CharArrayBuffer(16);
        buffer.append(s);
        cursor = new ParserCursor(0, s.length());
        param = parser.parseNameValuePair(buffer, cursor);
        Assert.assertEquals((Object)"test", (Object)param.getName());
        Assert.assertEquals((Object)"stuff", (Object)param.getValue());
        s = "test  = \"  stuff\\\"\"";
        buffer = new CharArrayBuffer(16);
        buffer.append(s);
        cursor = new ParserCursor(0, s.length());
        param = parser.parseNameValuePair(buffer, cursor);
        Assert.assertEquals((Object)"test", (Object)param.getName());
        Assert.assertEquals((Object)"  stuff\"", (Object)param.getValue());
        s = "  test";
        buffer = new CharArrayBuffer(16);
        buffer.append(s);
        cursor = new ParserCursor(0, s.length());
        param = parser.parseNameValuePair(buffer, cursor);
        Assert.assertEquals((Object)"test", (Object)param.getName());
        Assert.assertEquals(null, (Object)param.getValue());
        s = "  ";
        buffer = new CharArrayBuffer(16);
        buffer.append(s);
        cursor = new ParserCursor(0, s.length());
        param = parser.parseNameValuePair(buffer, cursor);
        Assert.assertEquals((Object)"", (Object)param.getName());
        Assert.assertEquals(null, (Object)param.getValue());
        s = " = stuff ";
        buffer = new CharArrayBuffer(16);
        buffer.append(s);
        cursor = new ParserCursor(0, s.length());
        param = parser.parseNameValuePair(buffer, cursor);
        Assert.assertEquals((Object)"", (Object)param.getName());
        Assert.assertEquals((Object)"stuff", (Object)param.getValue());
    }

    @Test
    public void testNVParse() {
        String s = "test";
        NameValuePair param = BasicHeaderValueParser.parseNameValuePair((String)s, null);
        Assert.assertEquals((Object)"test", (Object)param.getName());
        Assert.assertEquals(null, (Object)param.getValue());
        s = "test=stuff";
        param = BasicHeaderValueParser.parseNameValuePair((String)s, null);
        Assert.assertEquals((Object)"test", (Object)param.getName());
        Assert.assertEquals((Object)"stuff", (Object)param.getValue());
        s = "   test  =   stuff ";
        param = BasicHeaderValueParser.parseNameValuePair((String)s, null);
        Assert.assertEquals((Object)"test", (Object)param.getName());
        Assert.assertEquals((Object)"stuff", (Object)param.getValue());
        s = "test  = \"stuff\"";
        param = BasicHeaderValueParser.parseNameValuePair((String)s, null);
        Assert.assertEquals((Object)"test", (Object)param.getName());
        Assert.assertEquals((Object)"stuff", (Object)param.getValue());
        s = "test  = \"  stuff\\\"\"";
        param = BasicHeaderValueParser.parseNameValuePair((String)s, null);
        Assert.assertEquals((Object)"test", (Object)param.getName());
        Assert.assertEquals((Object)"  stuff\"", (Object)param.getValue());
        s = "  test";
        param = BasicHeaderValueParser.parseNameValuePair((String)s, null);
        Assert.assertEquals((Object)"test", (Object)param.getName());
        Assert.assertEquals(null, (Object)param.getValue());
        s = "  ";
        param = BasicHeaderValueParser.parseNameValuePair((String)s, null);
        Assert.assertEquals((Object)"", (Object)param.getName());
        Assert.assertEquals(null, (Object)param.getValue());
        s = " = stuff ";
        param = BasicHeaderValueParser.parseNameValuePair((String)s, null);
        Assert.assertEquals((Object)"", (Object)param.getName());
        Assert.assertEquals((Object)"stuff", (Object)param.getValue());
    }

    @Test
    public void testNVParseAllWithCursor() {
        BasicHeaderValueParser parser = BasicHeaderValueParser.INSTANCE;
        String s = "test; test1 =  stuff   ; test2 =  \"stuff; stuff\"; test3=\"stuff";
        CharArrayBuffer buffer = new CharArrayBuffer(16);
        buffer.append(s);
        ParserCursor cursor = new ParserCursor(0, s.length());
        NameValuePair[] params = parser.parseParameters(buffer, cursor);
        Assert.assertEquals((Object)"test", (Object)params[0].getName());
        Assert.assertEquals(null, (Object)params[0].getValue());
        Assert.assertEquals((Object)"test1", (Object)params[1].getName());
        Assert.assertEquals((Object)"stuff", (Object)params[1].getValue());
        Assert.assertEquals((Object)"test2", (Object)params[2].getName());
        Assert.assertEquals((Object)"stuff; stuff", (Object)params[2].getValue());
        Assert.assertEquals((Object)"test3", (Object)params[3].getName());
        Assert.assertEquals((Object)"stuff", (Object)params[3].getValue());
        Assert.assertEquals((long)s.length(), (long)cursor.getPos());
        Assert.assertTrue((boolean)cursor.atEnd());
        s = "test; test1 =  stuff   ; test2 =  \"stuff; stuff\"; test3=\"stuff\",123";
        buffer = new CharArrayBuffer(16);
        buffer.append(s);
        cursor = new ParserCursor(0, s.length());
        params = parser.parseParameters(buffer, cursor);
        Assert.assertEquals((Object)"test", (Object)params[0].getName());
        Assert.assertEquals(null, (Object)params[0].getValue());
        Assert.assertEquals((Object)"test1", (Object)params[1].getName());
        Assert.assertEquals((Object)"stuff", (Object)params[1].getValue());
        Assert.assertEquals((Object)"test2", (Object)params[2].getName());
        Assert.assertEquals((Object)"stuff; stuff", (Object)params[2].getValue());
        Assert.assertEquals((Object)"test3", (Object)params[3].getName());
        Assert.assertEquals((Object)"stuff", (Object)params[3].getValue());
        Assert.assertEquals((long)(s.length() - 3), (long)cursor.getPos());
        Assert.assertFalse((boolean)cursor.atEnd());
        s = "  ";
        buffer = new CharArrayBuffer(16);
        buffer.append(s);
        cursor = new ParserCursor(0, s.length());
        params = parser.parseParameters(buffer, cursor);
        Assert.assertEquals((long)0L, (long)params.length);
    }

    @Test
    public void testNVParseAll() {
        String s = "test; test1 =  stuff   ; test2 =  \"stuff; stuff\"; test3=\"stuff";
        NameValuePair[] params = BasicHeaderValueParser.parseParameters((String)s, null);
        Assert.assertEquals((Object)"test", (Object)params[0].getName());
        Assert.assertEquals(null, (Object)params[0].getValue());
        Assert.assertEquals((Object)"test1", (Object)params[1].getName());
        Assert.assertEquals((Object)"stuff", (Object)params[1].getValue());
        Assert.assertEquals((Object)"test2", (Object)params[2].getName());
        Assert.assertEquals((Object)"stuff; stuff", (Object)params[2].getValue());
        Assert.assertEquals((Object)"test3", (Object)params[3].getName());
        Assert.assertEquals((Object)"stuff", (Object)params[3].getValue());
        s = "  ";
        params = BasicHeaderValueParser.parseParameters((String)s, null);
        Assert.assertEquals((long)0L, (long)params.length);
    }

    @Test
    public void testNVParseEscaped() {
        String s = "test1 =  \"\\\"stuff\\\"\"; test2= \"\\\\\"; test3 = \"stuff; stuff\"";
        NameValuePair[] params = BasicHeaderValueParser.parseParameters((String)"test1 =  \"\\\"stuff\\\"\"; test2= \"\\\\\"; test3 = \"stuff; stuff\"", null);
        Assert.assertEquals((long)3L, (long)params.length);
        Assert.assertEquals((Object)"test1", (Object)params[0].getName());
        Assert.assertEquals((Object)"\"stuff\"", (Object)params[0].getValue());
        Assert.assertEquals((Object)"test2", (Object)params[1].getName());
        Assert.assertEquals((Object)"\\", (Object)params[1].getValue());
        Assert.assertEquals((Object)"test3", (Object)params[2].getName());
        Assert.assertEquals((Object)"stuff; stuff", (Object)params[2].getValue());
    }
}

