/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.message;

import org.apache.http.Header;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.RequestLine;
import org.apache.http.StatusLine;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicLineFormatter;
import org.apache.http.message.BasicRequestLine;
import org.apache.http.message.BasicStatusLine;
import org.apache.http.message.LineFormatter;
import org.apache.http.util.CharArrayBuffer;
import org.junit.Assert;
import org.junit.Test;

public class TestBasicLineFormatter {
    @Test
    public void testHttpVersionFormatting() throws Exception {
        String s = BasicLineFormatter.formatProtocolVersion((ProtocolVersion)HttpVersion.HTTP_1_1, null);
        Assert.assertEquals((Object)"HTTP/1.1", (Object)s);
    }

    @Test
    public void testHttpVersionFormattingInvalidInput() throws Exception {
        try {
            BasicLineFormatter.formatProtocolVersion(null, (LineFormatter)BasicLineFormatter.INSTANCE);
            Assert.fail((String)"IllegalArgumentException should habe been thrown");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            BasicLineFormatter.INSTANCE.appendProtocolVersion(new CharArrayBuffer(10), (ProtocolVersion)((HttpVersion)null));
            Assert.fail((String)"IllegalArgumentException should habe been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testRLFormatting() throws Exception {
        BasicRequestLine requestline = new BasicRequestLine("GET", "/stuff", (ProtocolVersion)HttpVersion.HTTP_1_1);
        String s = BasicLineFormatter.formatRequestLine((RequestLine)requestline, null);
        Assert.assertEquals((Object)"GET /stuff HTTP/1.1", (Object)s);
    }

    @Test
    public void testRLFormattingInvalidInput() throws Exception {
        try {
            BasicLineFormatter.formatRequestLine(null, (LineFormatter)BasicLineFormatter.INSTANCE);
            Assert.fail((String)"IllegalArgumentException should habe been thrown");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            BasicLineFormatter.INSTANCE.formatRequestLine(new CharArrayBuffer(10), (RequestLine)null);
            Assert.fail((String)"IllegalArgumentException should habe been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testSLFormatting() throws Exception {
        BasicStatusLine statusline = new BasicStatusLine((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        String s = BasicLineFormatter.formatStatusLine((StatusLine)statusline, null);
        Assert.assertEquals((Object)"HTTP/1.1 200 OK", (Object)s);
        statusline = new BasicStatusLine((ProtocolVersion)HttpVersion.HTTP_1_1, 200, null);
        s = BasicLineFormatter.formatStatusLine((StatusLine)statusline, null);
        Assert.assertEquals((Object)"HTTP/1.1 200 ", (Object)s);
    }

    @Test
    public void testSLFormattingInvalidInput() throws Exception {
        try {
            BasicLineFormatter.formatStatusLine(null, (LineFormatter)BasicLineFormatter.INSTANCE);
            Assert.fail((String)"IllegalArgumentException should habe been thrown");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            BasicLineFormatter.INSTANCE.formatStatusLine(new CharArrayBuffer(10), (StatusLine)null);
            Assert.fail((String)"IllegalArgumentException should habe been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testHeaderFormatting() throws Exception {
        BasicHeader header1 = new BasicHeader("name", "value");
        String s = BasicLineFormatter.formatHeader((Header)header1, null);
        Assert.assertEquals((Object)"name: value", (Object)s);
        BasicHeader header2 = new BasicHeader("name", null);
        s = BasicLineFormatter.formatHeader((Header)header2, null);
        Assert.assertEquals((Object)"name: ", (Object)s);
    }

    @Test
    public void testHeaderFormattingInvalidInput() throws Exception {
        try {
            BasicLineFormatter.formatHeader(null, (LineFormatter)BasicLineFormatter.INSTANCE);
            Assert.fail((String)"IllegalArgumentException should habe been thrown");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            BasicLineFormatter.INSTANCE.formatHeader(new CharArrayBuffer(10), (Header)null);
            Assert.fail((String)"IllegalArgumentException should habe been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testHeaderFormattingRequestSplitting() throws Exception {
        BasicHeader header = new BasicHeader("Host", "apache.org\r\nOops: oops");
        String s = BasicLineFormatter.formatHeader((Header)header, null);
        Assert.assertFalse((boolean)s.contains("\n"));
        Assert.assertEquals((Object)"Host: apache.org  Oops: oops", (Object)s);
    }
}

