/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.message;

import org.apache.http.HttpEntity;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.apache.http.message.BasicHttpRequest;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.message.BasicStatusLine;
import org.junit.Assert;
import org.junit.Test;

public class TestBasicMessages {
    @Test
    public void testDefaultResponseConstructors() {
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_0, 400, "Bad Request");
        Assert.assertNotNull((Object)response.getProtocolVersion());
        Assert.assertEquals((Object)HttpVersion.HTTP_1_0, (Object)response.getProtocolVersion());
        Assert.assertEquals((long)400L, (long)response.getStatusLine().getStatusCode());
        response = new BasicHttpResponse((StatusLine)new BasicStatusLine((ProtocolVersion)HttpVersion.HTTP_1_1, 500, "whatever"));
        Assert.assertNotNull((Object)response.getProtocolVersion());
        Assert.assertEquals((Object)HttpVersion.HTTP_1_1, (Object)response.getProtocolVersion());
        Assert.assertEquals((long)500L, (long)response.getStatusLine().getStatusCode());
        Assert.assertEquals((Object)"whatever", (Object)response.getStatusLine().getReasonPhrase());
    }

    @Test
    public void testSetResponseStatus() {
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        Assert.assertNotNull((Object)response.getProtocolVersion());
        Assert.assertNotNull((Object)response.getStatusLine());
        Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_0, 400, "Bad Request");
        Assert.assertNotNull((Object)response.getProtocolVersion());
        Assert.assertEquals((Object)HttpVersion.HTTP_1_0, (Object)response.getProtocolVersion());
        Assert.assertEquals((long)400L, (long)response.getStatusLine().getStatusCode());
        response = new BasicHttpResponse((StatusLine)new BasicStatusLine((ProtocolVersion)HttpVersion.HTTP_1_1, 500, "whatever"));
        Assert.assertNotNull((Object)response.getProtocolVersion());
        Assert.assertEquals((Object)HttpVersion.HTTP_1_1, (Object)response.getProtocolVersion());
        Assert.assertEquals((long)500L, (long)response.getStatusLine().getStatusCode());
        Assert.assertEquals((Object)"whatever", (Object)response.getStatusLine().getReasonPhrase());
        response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        try {
            response.setStatusCode(-23);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        try {
            response.setStatusLine(null);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testSetResponseEntity() {
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        Assert.assertNull((Object)response.getEntity());
        BasicHttpEntity entity = new BasicHttpEntity();
        response.setEntity((HttpEntity)entity);
        Assert.assertTrue((entity == response.getEntity() ? 1 : 0) != 0);
    }

    @Test
    public void testDefaultRequestConstructors() {
        BasicHttpRequest request = new BasicHttpRequest("WHATEVER", "/");
        Assert.assertNotNull((Object)request.getProtocolVersion());
        Assert.assertEquals((Object)"WHATEVER", (Object)request.getRequestLine().getMethod());
        Assert.assertEquals((Object)"/", (Object)request.getRequestLine().getUri());
        request = new BasicHttpRequest("GET", "/", (ProtocolVersion)HttpVersion.HTTP_1_0);
        Assert.assertEquals((Object)HttpVersion.HTTP_1_0, (Object)request.getProtocolVersion());
        Assert.assertEquals((Object)"GET", (Object)request.getRequestLine().getMethod());
        Assert.assertEquals((Object)"/", (Object)request.getRequestLine().getUri());
        try {
            new BasicHttpRequest(null, null);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            new BasicHttpRequest("GET", null);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            new BasicHttpRequest(null);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testDefaultEntityEnclosingRequestConstructors() {
        BasicHttpEntityEnclosingRequest request = new BasicHttpEntityEnclosingRequest("GET", "/");
        Assert.assertNotNull((Object)request.getProtocolVersion());
        Assert.assertEquals((Object)"GET", (Object)request.getRequestLine().getMethod());
        Assert.assertEquals((Object)"/", (Object)request.getRequestLine().getUri());
        request = new BasicHttpEntityEnclosingRequest("GET", "/", (ProtocolVersion)HttpVersion.HTTP_1_0);
        Assert.assertEquals((Object)HttpVersion.HTTP_1_0, (Object)request.getProtocolVersion());
        Assert.assertEquals((Object)"GET", (Object)request.getRequestLine().getMethod());
        Assert.assertEquals((Object)"/", (Object)request.getRequestLine().getUri());
    }

    @Test
    public void testSetRequestEntity() {
        BasicHttpEntityEnclosingRequest request = new BasicHttpEntityEnclosingRequest("GET", "/");
        Assert.assertNull((Object)request.getEntity());
        BasicHttpEntity entity = new BasicHttpEntity();
        request.setEntity((HttpEntity)entity);
        Assert.assertTrue((entity == request.getEntity() ? 1 : 0) != 0);
    }

    @Test
    public void testExpectContinue() {
        BasicHttpEntityEnclosingRequest request = new BasicHttpEntityEnclosingRequest("GET", "/");
        Assert.assertFalse((boolean)request.expectContinue());
        request.addHeader("Expect", "100-Continue");
        Assert.assertTrue((boolean)request.expectContinue());
    }
}

