/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.message;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.http.HeaderElement;
import org.apache.http.message.BasicHeader;
import org.junit.Assert;
import org.junit.Test;

public class TestHeader {
    @Test
    public void testBasicConstructor() {
        BasicHeader header = new BasicHeader("name", "value");
        Assert.assertEquals((Object)"name", (Object)header.getName());
        Assert.assertEquals((Object)"value", (Object)header.getValue());
    }

    @Test
    public void testBasicConstructorNullValue() {
        BasicHeader header = new BasicHeader("name", null);
        Assert.assertEquals((Object)"name", (Object)header.getName());
        Assert.assertEquals(null, (Object)header.getValue());
    }

    @Test
    public void testInvalidName() {
        try {
            new BasicHeader(null, null);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testToString() {
        BasicHeader header1 = new BasicHeader("name1", "value1");
        Assert.assertEquals((Object)"name1: value1", (Object)header1.toString());
        BasicHeader header2 = new BasicHeader("name2", null);
        Assert.assertEquals((Object)"name2: ", (Object)header2.toString());
    }

    @Test
    public void testHeaderElements() {
        BasicHeader header = new BasicHeader("name", "element1 = value1, element2; param1 = value1, element3");
        HeaderElement[] elements = header.getElements();
        Assert.assertNotNull((Object)elements);
        Assert.assertEquals((long)3L, (long)elements.length);
        Assert.assertEquals((Object)"element1", (Object)elements[0].getName());
        Assert.assertEquals((Object)"value1", (Object)elements[0].getValue());
        Assert.assertEquals((Object)"element2", (Object)elements[1].getName());
        Assert.assertEquals(null, (Object)elements[1].getValue());
        Assert.assertEquals((Object)"element3", (Object)elements[2].getName());
        Assert.assertEquals(null, (Object)elements[2].getValue());
        Assert.assertEquals((long)1L, (long)elements[1].getParameters().length);
        header = new BasicHeader("name", null);
        elements = header.getElements();
        Assert.assertNotNull((Object)elements);
        Assert.assertEquals((long)0L, (long)elements.length);
    }

    @Test
    public void testCloning() throws Exception {
        BasicHeader orig = new BasicHeader("name1", "value1");
        BasicHeader clone = (BasicHeader)orig.clone();
        Assert.assertEquals((Object)orig.getName(), (Object)clone.getName());
        Assert.assertEquals((Object)orig.getValue(), (Object)clone.getValue());
    }

    @Test
    public void testSerialization() throws Exception {
        BasicHeader orig = new BasicHeader("name1", "value1");
        ByteArrayOutputStream outbuffer = new ByteArrayOutputStream();
        ObjectOutputStream outStream = new ObjectOutputStream(outbuffer);
        outStream.writeObject(orig);
        outStream.close();
        byte[] raw = outbuffer.toByteArray();
        ByteArrayInputStream inBuffer = new ByteArrayInputStream(raw);
        ObjectInputStream inStream = new ObjectInputStream(inBuffer);
        BasicHeader clone = (BasicHeader)inStream.readObject();
        Assert.assertEquals((Object)orig.getName(), (Object)clone.getName());
        Assert.assertEquals((Object)orig.getValue(), (Object)clone.getValue());
    }
}

