/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.message;

import org.apache.http.message.BasicNameValuePair;
import org.junit.Assert;
import org.junit.Test;

public class TestNameValuePair {
    @Test
    public void testConstructor() {
        BasicNameValuePair param = new BasicNameValuePair("name", "value");
        Assert.assertEquals((Object)"name", (Object)param.getName());
        Assert.assertEquals((Object)"value", (Object)param.getValue());
    }

    @Test
    public void testInvalidName() {
        try {
            new BasicNameValuePair(null, null);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testHashCode() {
        BasicNameValuePair param1 = new BasicNameValuePair("name1", "value1");
        BasicNameValuePair param2 = new BasicNameValuePair("name2", "value2");
        BasicNameValuePair param3 = new BasicNameValuePair("name1", "value1");
        Assert.assertTrue((param1.hashCode() != param2.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((param1.hashCode() == param3.hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void testEquals() {
        BasicNameValuePair param1 = new BasicNameValuePair("name1", "value1");
        BasicNameValuePair param2 = new BasicNameValuePair("name2", "value2");
        BasicNameValuePair param3 = new BasicNameValuePair("name1", "value1");
        Assert.assertFalse((boolean)param1.equals(param2));
        Assert.assertFalse((boolean)param1.equals(null));
        Assert.assertFalse((boolean)param1.equals("name1 = value1"));
        Assert.assertTrue((boolean)param1.equals(param1));
        Assert.assertTrue((boolean)param2.equals(param2));
        Assert.assertTrue((boolean)param1.equals(param3));
    }

    @Test
    public void testToString() {
        BasicNameValuePair param1 = new BasicNameValuePair("name1", "value1");
        Assert.assertEquals((Object)"name1=value1", (Object)param1.toString());
        BasicNameValuePair param2 = new BasicNameValuePair("name1", null);
        Assert.assertEquals((Object)"name1", (Object)param2.toString());
    }

    @Test
    public void testCloning() throws Exception {
        BasicNameValuePair orig = new BasicNameValuePair("name1", "value1");
        BasicNameValuePair clone = (BasicNameValuePair)orig.clone();
        Assert.assertEquals((Object)orig, (Object)clone);
    }
}

