/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.message;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.message.BasicRequestLine;
import org.junit.Assert;
import org.junit.Test;

public class TestRequestLine {
    @Test
    public void testConstructor() {
        BasicRequestLine requestline = new BasicRequestLine("GET", "/stuff", (ProtocolVersion)HttpVersion.HTTP_1_1);
        Assert.assertEquals((Object)"GET", (Object)requestline.getMethod());
        Assert.assertEquals((Object)"/stuff", (Object)requestline.getUri());
        Assert.assertEquals((Object)HttpVersion.HTTP_1_1, (Object)requestline.getProtocolVersion());
    }

    @Test
    public void testConstructorInvalidInput() {
        try {
            new BasicRequestLine(null, "/stuff", (ProtocolVersion)HttpVersion.HTTP_1_1);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            new BasicRequestLine("GET", null, (ProtocolVersion)HttpVersion.HTTP_1_1);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            new BasicRequestLine("GET", "/stuff", (ProtocolVersion)((HttpVersion)null));
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testCloning() throws Exception {
        BasicRequestLine orig = new BasicRequestLine("GET", "/stuff", (ProtocolVersion)HttpVersion.HTTP_1_1);
        BasicRequestLine clone = (BasicRequestLine)orig.clone();
        Assert.assertEquals((Object)orig.getMethod(), (Object)clone.getMethod());
        Assert.assertEquals((Object)orig.getUri(), (Object)clone.getUri());
        Assert.assertEquals((Object)orig.getProtocolVersion(), (Object)clone.getProtocolVersion());
    }

    @Test
    public void testSerialization() throws Exception {
        BasicRequestLine orig = new BasicRequestLine("GET", "/stuff", (ProtocolVersion)HttpVersion.HTTP_1_1);
        ByteArrayOutputStream outbuffer = new ByteArrayOutputStream();
        ObjectOutputStream outStream = new ObjectOutputStream(outbuffer);
        outStream.writeObject(orig);
        outStream.close();
        byte[] raw = outbuffer.toByteArray();
        ByteArrayInputStream inBuffer = new ByteArrayInputStream(raw);
        ObjectInputStream inStream = new ObjectInputStream(inBuffer);
        BasicRequestLine clone = (BasicRequestLine)inStream.readObject();
        Assert.assertEquals((Object)orig.getMethod(), (Object)clone.getMethod());
        Assert.assertEquals((Object)orig.getUri(), (Object)clone.getUri());
        Assert.assertEquals((Object)orig.getProtocolVersion(), (Object)clone.getProtocolVersion());
    }
}

