/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.message;

import org.apache.http.message.ParserCursor;
import org.apache.http.message.TokenParser;
import org.apache.http.util.CharArrayBuffer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestTokenParser {
    private TokenParser parser;

    @Before
    public void setUp() throws Exception {
        this.parser = new TokenParser();
    }

    private static CharArrayBuffer createBuffer(String value) {
        if (value == null) {
            return null;
        }
        CharArrayBuffer buffer = new CharArrayBuffer(value.length());
        buffer.append(value);
        return buffer;
    }

    @Test
    public void testBasicTokenParsing() throws Exception {
        String s = "   raw: \" some stuff \"";
        CharArrayBuffer raw = TestTokenParser.createBuffer("   raw: \" some stuff \"");
        ParserCursor cursor = new ParserCursor(0, "   raw: \" some stuff \"".length());
        this.parser.skipWhiteSpace(raw, cursor);
        Assert.assertFalse((boolean)cursor.atEnd());
        Assert.assertEquals((long)3L, (long)cursor.getPos());
        StringBuilder strbuf1 = new StringBuilder();
        this.parser.copyContent(raw, cursor, TokenParser.INIT_BITSET((int[])new int[]{58}), strbuf1);
        Assert.assertFalse((boolean)cursor.atEnd());
        Assert.assertEquals((long)6L, (long)cursor.getPos());
        Assert.assertEquals((Object)"raw", (Object)strbuf1.toString());
        Assert.assertEquals((long)58L, (long)raw.charAt(cursor.getPos()));
        cursor.updatePos(cursor.getPos() + 1);
        this.parser.skipWhiteSpace(raw, cursor);
        Assert.assertFalse((boolean)cursor.atEnd());
        Assert.assertEquals((long)8L, (long)cursor.getPos());
        StringBuilder strbuf2 = new StringBuilder();
        this.parser.copyQuotedContent(raw, cursor, strbuf2);
        Assert.assertTrue((boolean)cursor.atEnd());
        Assert.assertEquals((Object)" some stuff ", (Object)strbuf2.toString());
        this.parser.copyQuotedContent(raw, cursor, strbuf2);
        Assert.assertTrue((boolean)cursor.atEnd());
        this.parser.skipWhiteSpace(raw, cursor);
        Assert.assertTrue((boolean)cursor.atEnd());
    }

    @Test
    public void testTokenParsingWithQuotedPairs() throws Exception {
        String s = "raw: \"\\\"some\\stuff\\\\\"";
        CharArrayBuffer raw = TestTokenParser.createBuffer("raw: \"\\\"some\\stuff\\\\\"");
        ParserCursor cursor = new ParserCursor(0, "raw: \"\\\"some\\stuff\\\\\"".length());
        this.parser.skipWhiteSpace(raw, cursor);
        Assert.assertFalse((boolean)cursor.atEnd());
        Assert.assertEquals((long)0L, (long)cursor.getPos());
        StringBuilder strbuf1 = new StringBuilder();
        this.parser.copyContent(raw, cursor, TokenParser.INIT_BITSET((int[])new int[]{58}), strbuf1);
        Assert.assertFalse((boolean)cursor.atEnd());
        Assert.assertEquals((Object)"raw", (Object)strbuf1.toString());
        Assert.assertEquals((long)58L, (long)raw.charAt(cursor.getPos()));
        cursor.updatePos(cursor.getPos() + 1);
        this.parser.skipWhiteSpace(raw, cursor);
        Assert.assertFalse((boolean)cursor.atEnd());
        StringBuilder strbuf2 = new StringBuilder();
        this.parser.copyQuotedContent(raw, cursor, strbuf2);
        Assert.assertTrue((boolean)cursor.atEnd());
        Assert.assertEquals((Object)"\"some\\stuff\\", (Object)strbuf2.toString());
    }

    @Test
    public void testTokenParsingIncompleteQuote() throws Exception {
        String s = "\"stuff and more stuff  ";
        CharArrayBuffer raw = TestTokenParser.createBuffer("\"stuff and more stuff  ");
        ParserCursor cursor = new ParserCursor(0, "\"stuff and more stuff  ".length());
        StringBuilder strbuf1 = new StringBuilder();
        this.parser.copyQuotedContent(raw, cursor, strbuf1);
        Assert.assertEquals((Object)"stuff and more stuff  ", (Object)strbuf1.toString());
    }

    @Test
    public void testTokenParsingTokensWithUnquotedBlanks() throws Exception {
        String s = "  stuff and   \tsome\tmore  stuff  ;";
        CharArrayBuffer raw = TestTokenParser.createBuffer("  stuff and   \tsome\tmore  stuff  ;");
        ParserCursor cursor = new ParserCursor(0, "  stuff and   \tsome\tmore  stuff  ;".length());
        String result = this.parser.parseToken(raw, cursor, TokenParser.INIT_BITSET((int[])new int[]{59}));
        Assert.assertEquals((Object)"stuff and some more stuff", (Object)result);
    }

    @Test
    public void testTokenParsingMixedValuesAndQuotedValues() throws Exception {
        String s = "  stuff and    \" some more \"   \"stuff  ;";
        CharArrayBuffer raw = TestTokenParser.createBuffer("  stuff and    \" some more \"   \"stuff  ;");
        ParserCursor cursor = new ParserCursor(0, "  stuff and    \" some more \"   \"stuff  ;".length());
        String result = this.parser.parseValue(raw, cursor, TokenParser.INIT_BITSET((int[])new int[]{59}));
        Assert.assertEquals((Object)"stuff and  some more  stuff  ;", (Object)result);
    }

    @Test
    public void testTokenParsingMixedValuesAndQuotedValues2() throws Exception {
        String s = "stuff\"more\"stuff;";
        CharArrayBuffer raw = TestTokenParser.createBuffer("stuff\"more\"stuff;");
        ParserCursor cursor = new ParserCursor(0, "stuff\"more\"stuff;".length());
        String result = this.parser.parseValue(raw, cursor, TokenParser.INIT_BITSET((int[])new int[]{59}));
        Assert.assertEquals((Object)"stuffmorestuff", (Object)result);
    }

    @Test
    public void testTokenParsingEscapedQuotes() throws Exception {
        String s = "stuff\"\\\"more\\\"\"stuff;";
        CharArrayBuffer raw = TestTokenParser.createBuffer("stuff\"\\\"more\\\"\"stuff;");
        ParserCursor cursor = new ParserCursor(0, "stuff\"\\\"more\\\"\"stuff;".length());
        String result = this.parser.parseValue(raw, cursor, TokenParser.INIT_BITSET((int[])new int[]{59}));
        Assert.assertEquals((Object)"stuff\"more\"stuff", (Object)result);
    }

    @Test
    public void testTokenParsingEscapedDelimiter() throws Exception {
        String s = "stuff\"\\\"more\\\";\"stuff;";
        CharArrayBuffer raw = TestTokenParser.createBuffer("stuff\"\\\"more\\\";\"stuff;");
        ParserCursor cursor = new ParserCursor(0, "stuff\"\\\"more\\\";\"stuff;".length());
        String result = this.parser.parseValue(raw, cursor, TokenParser.INIT_BITSET((int[])new int[]{59}));
        Assert.assertEquals((Object)"stuff\"more\";stuff", (Object)result);
    }

    @Test
    public void testTokenParsingEscapedSlash() throws Exception {
        String s = "stuff\"\\\"more\\\";\\\\\"stuff;";
        CharArrayBuffer raw = TestTokenParser.createBuffer("stuff\"\\\"more\\\";\\\\\"stuff;");
        ParserCursor cursor = new ParserCursor(0, "stuff\"\\\"more\\\";\\\\\"stuff;".length());
        String result = this.parser.parseValue(raw, cursor, TokenParser.INIT_BITSET((int[])new int[]{59}));
        Assert.assertEquals((Object)"stuff\"more\";\\stuff", (Object)result);
    }

    @Test
    public void testTokenParsingSlashOutsideQuotes() throws Exception {
        String s = "stuff\\; more stuff;";
        CharArrayBuffer raw = TestTokenParser.createBuffer("stuff\\; more stuff;");
        ParserCursor cursor = new ParserCursor(0, "stuff\\; more stuff;".length());
        String result = this.parser.parseValue(raw, cursor, TokenParser.INIT_BITSET((int[])new int[]{59}));
        Assert.assertEquals((Object)"stuff\\", (Object)result);
    }
}

