/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.pool;

import java.io.IOException;
import java.util.concurrent.Future;
import org.apache.http.HttpConnection;
import org.apache.http.pool.PoolEntry;
import org.apache.http.pool.RouteSpecificPool;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestRouteSpecificPool {
    private static final String ROUTE = "whatever";

    @Test
    public void testEmptyPool() throws Exception {
        LocalRoutePool pool = new LocalRoutePool();
        Assert.assertEquals((Object)ROUTE, (Object)pool.getRoute());
        Assert.assertEquals((long)0L, (long)pool.getAllocatedCount());
        Assert.assertEquals((long)0L, (long)pool.getAvailableCount());
        Assert.assertEquals((long)0L, (long)pool.getLeasedCount());
        Assert.assertEquals((long)0L, (long)pool.getPendingCount());
        Assert.assertNull((Object)pool.getLastUsed());
        Assert.assertEquals((Object)"[route: whatever][leased: 0][available: 0][pending: 0]", (Object)pool.toString());
    }

    @Test
    public void testAdd() throws Exception {
        LocalRoutePool pool = new LocalRoutePool();
        HttpConnection conn = (HttpConnection)Mockito.mock(HttpConnection.class);
        PoolEntry entry = pool.add(conn);
        Assert.assertEquals((long)1L, (long)pool.getAllocatedCount());
        Assert.assertEquals((long)0L, (long)pool.getAvailableCount());
        Assert.assertEquals((long)1L, (long)pool.getLeasedCount());
        Assert.assertEquals((long)0L, (long)pool.getPendingCount());
        Assert.assertNotNull((Object)entry);
        Assert.assertSame((Object)conn, (Object)entry.getConnection());
    }

    @Test
    public void testLeaseRelease() throws Exception {
        LocalRoutePool pool = new LocalRoutePool();
        HttpConnection conn1 = (HttpConnection)Mockito.mock(HttpConnection.class);
        LocalPoolEntry entry1 = (LocalPoolEntry)pool.add(conn1);
        HttpConnection conn2 = (HttpConnection)Mockito.mock(HttpConnection.class);
        LocalPoolEntry entry2 = (LocalPoolEntry)pool.add(conn2);
        HttpConnection conn3 = (HttpConnection)Mockito.mock(HttpConnection.class);
        LocalPoolEntry entry3 = (LocalPoolEntry)pool.add(conn3);
        Assert.assertNotNull((Object)((Object)entry1));
        Assert.assertNotNull((Object)((Object)entry2));
        Assert.assertNotNull((Object)((Object)entry3));
        Assert.assertEquals((long)3L, (long)pool.getAllocatedCount());
        Assert.assertEquals((long)0L, (long)pool.getAvailableCount());
        Assert.assertEquals((long)3L, (long)pool.getLeasedCount());
        Assert.assertEquals((long)0L, (long)pool.getPendingCount());
        pool.free(entry1, true);
        pool.free(entry2, false);
        pool.free(entry3, true);
        Assert.assertEquals((long)2L, (long)pool.getAllocatedCount());
        Assert.assertEquals((long)2L, (long)pool.getAvailableCount());
        Assert.assertEquals((long)0L, (long)pool.getLeasedCount());
        Assert.assertEquals((long)0L, (long)pool.getPendingCount());
        Assert.assertSame((Object)((Object)entry1), (Object)pool.getLastUsed());
        Assert.assertNotNull((Object)pool.getFree(null));
        Assert.assertNotNull((Object)pool.getFree(null));
        Assert.assertNull((Object)pool.getFree(null));
        Assert.assertEquals((long)2L, (long)pool.getAllocatedCount());
        Assert.assertEquals((long)0L, (long)pool.getAvailableCount());
        Assert.assertEquals((long)2L, (long)pool.getLeasedCount());
        Assert.assertEquals((long)0L, (long)pool.getPendingCount());
    }

    @Test
    public void testLeaseOrder() throws Exception {
        LocalRoutePool pool = new LocalRoutePool();
        HttpConnection conn1 = (HttpConnection)Mockito.mock(HttpConnection.class);
        LocalPoolEntry entry1 = (LocalPoolEntry)pool.add(conn1);
        HttpConnection conn2 = (HttpConnection)Mockito.mock(HttpConnection.class);
        LocalPoolEntry entry2 = (LocalPoolEntry)pool.add(conn2);
        HttpConnection conn3 = (HttpConnection)Mockito.mock(HttpConnection.class);
        LocalPoolEntry entry3 = (LocalPoolEntry)pool.add(conn3);
        Assert.assertNotNull((Object)((Object)entry1));
        Assert.assertNotNull((Object)((Object)entry2));
        Assert.assertNotNull((Object)((Object)entry3));
        Assert.assertEquals((long)3L, (long)pool.getAllocatedCount());
        Assert.assertEquals((long)0L, (long)pool.getAvailableCount());
        Assert.assertEquals((long)3L, (long)pool.getLeasedCount());
        Assert.assertEquals((long)0L, (long)pool.getPendingCount());
        pool.free(entry1, true);
        pool.free(entry2, true);
        pool.free(entry3, true);
        Assert.assertSame((Object)((Object)entry1), (Object)pool.getLastUsed());
        Assert.assertSame((Object)((Object)entry3), (Object)pool.getFree(null));
        Assert.assertSame((Object)((Object)entry2), (Object)pool.getFree(null));
        Assert.assertSame((Object)((Object)entry1), (Object)pool.getFree(null));
    }

    @Test
    public void testLeaseReleaseStateful() throws Exception {
        LocalRoutePool pool = new LocalRoutePool();
        HttpConnection conn1 = (HttpConnection)Mockito.mock(HttpConnection.class);
        LocalPoolEntry entry1 = (LocalPoolEntry)pool.add(conn1);
        HttpConnection conn2 = (HttpConnection)Mockito.mock(HttpConnection.class);
        LocalPoolEntry entry2 = (LocalPoolEntry)pool.add(conn2);
        HttpConnection conn3 = (HttpConnection)Mockito.mock(HttpConnection.class);
        LocalPoolEntry entry3 = (LocalPoolEntry)pool.add(conn3);
        Assert.assertNotNull((Object)((Object)entry1));
        Assert.assertNotNull((Object)((Object)entry2));
        Assert.assertNotNull((Object)((Object)entry3));
        Assert.assertEquals((long)3L, (long)pool.getAllocatedCount());
        Assert.assertEquals((long)0L, (long)pool.getAvailableCount());
        Assert.assertEquals((long)3L, (long)pool.getLeasedCount());
        Assert.assertEquals((long)0L, (long)pool.getPendingCount());
        entry2.setState(Boolean.FALSE);
        pool.free(entry1, true);
        pool.free(entry2, true);
        pool.free(entry3, true);
        Assert.assertSame((Object)((Object)entry2), (Object)pool.getFree(Boolean.FALSE));
        Assert.assertSame((Object)((Object)entry3), (Object)pool.getFree(Boolean.FALSE));
        Assert.assertSame((Object)((Object)entry1), (Object)pool.getFree(null));
        Assert.assertSame(null, (Object)pool.getFree(null));
        entry1.setState(Boolean.TRUE);
        entry2.setState(Boolean.FALSE);
        entry3.setState(Boolean.TRUE);
        pool.free(entry1, true);
        pool.free(entry2, true);
        pool.free(entry3, true);
        Assert.assertSame(null, (Object)pool.getFree(null));
        Assert.assertSame((Object)((Object)entry2), (Object)pool.getFree(Boolean.FALSE));
        Assert.assertSame(null, (Object)pool.getFree(Boolean.FALSE));
        Assert.assertSame((Object)((Object)entry3), (Object)pool.getFree(Boolean.TRUE));
        Assert.assertSame((Object)((Object)entry1), (Object)pool.getFree(Boolean.TRUE));
        Assert.assertSame(null, (Object)pool.getFree(Boolean.TRUE));
    }

    @Test(expected=IllegalStateException.class)
    public void testReleaseInvalidEntry() throws Exception {
        LocalRoutePool pool = new LocalRoutePool();
        HttpConnection conn = (HttpConnection)Mockito.mock(HttpConnection.class);
        LocalPoolEntry entry = new LocalPoolEntry(ROUTE, conn);
        pool.free(entry, true);
    }

    @Test
    public void testRemove() throws Exception {
        LocalRoutePool pool = new LocalRoutePool();
        HttpConnection conn1 = (HttpConnection)Mockito.mock(HttpConnection.class);
        LocalPoolEntry entry1 = (LocalPoolEntry)pool.add(conn1);
        HttpConnection conn2 = (HttpConnection)Mockito.mock(HttpConnection.class);
        LocalPoolEntry entry2 = (LocalPoolEntry)pool.add(conn2);
        HttpConnection conn3 = (HttpConnection)Mockito.mock(HttpConnection.class);
        LocalPoolEntry entry3 = (LocalPoolEntry)pool.add(conn3);
        Assert.assertNotNull((Object)((Object)entry1));
        Assert.assertNotNull((Object)((Object)entry2));
        Assert.assertNotNull((Object)((Object)entry3));
        Assert.assertEquals((long)3L, (long)pool.getAllocatedCount());
        Assert.assertEquals((long)0L, (long)pool.getAvailableCount());
        Assert.assertEquals((long)3L, (long)pool.getLeasedCount());
        Assert.assertEquals((long)0L, (long)pool.getPendingCount());
        Assert.assertTrue((boolean)pool.remove(entry2));
        Assert.assertFalse((boolean)pool.remove(entry2));
        Assert.assertEquals((long)2L, (long)pool.getAllocatedCount());
        Assert.assertEquals((long)0L, (long)pool.getAvailableCount());
        Assert.assertEquals((long)2L, (long)pool.getLeasedCount());
        Assert.assertEquals((long)0L, (long)pool.getPendingCount());
        pool.free(entry1, true);
        pool.free(entry3, true);
        Assert.assertEquals((long)2L, (long)pool.getAllocatedCount());
        Assert.assertEquals((long)2L, (long)pool.getAvailableCount());
        Assert.assertEquals((long)0L, (long)pool.getLeasedCount());
        Assert.assertEquals((long)0L, (long)pool.getPendingCount());
        Assert.assertTrue((boolean)pool.remove(entry1));
        Assert.assertTrue((boolean)pool.remove(entry3));
        Assert.assertEquals((long)0L, (long)pool.getAllocatedCount());
        Assert.assertEquals((long)0L, (long)pool.getAvailableCount());
        Assert.assertEquals((long)0L, (long)pool.getLeasedCount());
        Assert.assertEquals((long)0L, (long)pool.getPendingCount());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testReleaseInvalid() throws Exception {
        LocalRoutePool pool = new LocalRoutePool();
        pool.free(null, true);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRemoveInvalid() throws Exception {
        LocalRoutePool pool = new LocalRoutePool();
        pool.remove(null);
    }

    @Test
    public void testWaitingThreadQueuing() throws Exception {
        LocalRoutePool pool = new LocalRoutePool();
        Future future1 = (Future)Mockito.mock(Future.class);
        Future future2 = (Future)Mockito.mock(Future.class);
        Assert.assertEquals((long)0L, (long)pool.getPendingCount());
        pool.queue(future1);
        Assert.assertEquals((long)1L, (long)pool.getPendingCount());
        pool.queue(null);
        Assert.assertEquals((long)1L, (long)pool.getPendingCount());
        pool.queue(future2);
        Assert.assertEquals((long)2L, (long)pool.getPendingCount());
        Assert.assertSame((Object)future1, (Object)pool.nextPending());
        pool.unqueue(future1);
        Assert.assertEquals((long)1L, (long)pool.getPendingCount());
        Assert.assertSame((Object)future2, (Object)pool.nextPending());
        pool.unqueue(null);
        Assert.assertEquals((long)0L, (long)pool.getPendingCount());
        pool.unqueue(future2);
        Assert.assertNull((Object)pool.nextPending());
    }

    @Test
    public void testShutdown() throws Exception {
        LocalRoutePool pool = new LocalRoutePool();
        HttpConnection conn1 = (HttpConnection)Mockito.mock(HttpConnection.class);
        LocalPoolEntry entry1 = (LocalPoolEntry)pool.add(conn1);
        HttpConnection conn2 = (HttpConnection)Mockito.mock(HttpConnection.class);
        LocalPoolEntry entry2 = (LocalPoolEntry)pool.add(conn2);
        Future future1 = (Future)Mockito.mock(Future.class);
        pool.queue(future1);
        Assert.assertNotNull((Object)((Object)entry1));
        Assert.assertNotNull((Object)((Object)entry2));
        pool.free(entry1, true);
        Assert.assertEquals((long)2L, (long)pool.getAllocatedCount());
        Assert.assertEquals((long)1L, (long)pool.getAvailableCount());
        Assert.assertEquals((long)1L, (long)pool.getLeasedCount());
        Assert.assertEquals((long)1L, (long)pool.getPendingCount());
        pool.shutdown();
        Assert.assertEquals((long)0L, (long)pool.getAllocatedCount());
        Assert.assertEquals((long)0L, (long)pool.getAvailableCount());
        Assert.assertEquals((long)0L, (long)pool.getLeasedCount());
        Assert.assertEquals((long)0L, (long)pool.getPendingCount());
        ((Future)Mockito.verify((Object)future1)).cancel(true);
        ((HttpConnection)Mockito.verify((Object)conn2)).close();
        ((HttpConnection)Mockito.verify((Object)conn1)).close();
    }

    static class LocalRoutePool
    extends RouteSpecificPool<String, HttpConnection, LocalPoolEntry> {
        public LocalRoutePool() {
            super((Object)TestRouteSpecificPool.ROUTE);
        }

        protected LocalPoolEntry createEntry(HttpConnection conn) {
            return new LocalPoolEntry((String)this.getRoute(), conn);
        }
    }

    static class LocalPoolEntry
    extends PoolEntry<String, HttpConnection> {
        public LocalPoolEntry(String route, HttpConnection conn) {
            super(null, (Object)route, (Object)conn);
        }

        public void close() {
            try {
                ((HttpConnection)this.getConnection()).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public boolean isClosed() {
            return !((HttpConnection)this.getConnection()).isOpen();
        }
    }
}

