/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.protocol;

import java.io.IOException;
import org.apache.http.HttpClientConnection;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolException;
import org.apache.http.ProtocolVersion;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.apache.http.message.BasicHttpRequest;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpCoreContext;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpRequestExecutor;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestHttpRequestExecutor {
    @Test
    public void testInvalidInput() throws Exception {
        HttpRequestExecutor executor;
        HttpCoreContext context = HttpCoreContext.create();
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        HttpClientConnection conn = (HttpClientConnection)Mockito.mock(HttpClientConnection.class);
        HttpProcessor httprocessor = (HttpProcessor)Mockito.mock(HttpProcessor.class);
        try {
            executor = new HttpRequestExecutor();
            executor.execute(null, conn, (HttpContext)context);
            Assert.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            executor = new HttpRequestExecutor();
            executor.execute((HttpRequest)request, null, (HttpContext)context);
            Assert.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            executor = new HttpRequestExecutor();
            executor.execute((HttpRequest)request, conn, null);
            Assert.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            executor = new HttpRequestExecutor();
            executor.doSendRequest(null, conn, (HttpContext)context);
            Assert.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            executor = new HttpRequestExecutor();
            executor.doSendRequest((HttpRequest)request, null, (HttpContext)context);
            Assert.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            executor = new HttpRequestExecutor();
            executor.doSendRequest((HttpRequest)request, conn, null);
            Assert.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            executor = new HttpRequestExecutor();
            executor.doReceiveResponse(null, conn, (HttpContext)context);
            Assert.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            executor = new HttpRequestExecutor();
            executor.doReceiveResponse((HttpRequest)request, null, (HttpContext)context);
            Assert.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            executor = new HttpRequestExecutor();
            executor.doReceiveResponse((HttpRequest)request, conn, null);
            Assert.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            executor = new HttpRequestExecutor();
            executor.preProcess(null, httprocessor, (HttpContext)context);
            Assert.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            executor = new HttpRequestExecutor();
            executor.preProcess((HttpRequest)request, null, (HttpContext)context);
            Assert.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            executor = new HttpRequestExecutor();
            executor.preProcess((HttpRequest)request, httprocessor, null);
            Assert.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            executor = new HttpRequestExecutor();
            executor.postProcess(null, httprocessor, (HttpContext)context);
            Assert.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            executor = new HttpRequestExecutor();
            executor.postProcess((HttpResponse)response, null, (HttpContext)context);
            Assert.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            executor = new HttpRequestExecutor();
            executor.postProcess((HttpResponse)response, httprocessor, null);
            Assert.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
    }

    @Test
    public void testBasicExecution() throws Exception {
        HttpProcessor httprocessor = (HttpProcessor)Mockito.mock(HttpProcessor.class);
        HttpClientConnection conn = (HttpClientConnection)Mockito.mock(HttpClientConnection.class);
        HttpRequestExecutor executor = new HttpRequestExecutor();
        HttpCoreContext context = HttpCoreContext.create();
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        executor.preProcess((HttpRequest)request, httprocessor, (HttpContext)context);
        ((HttpProcessor)Mockito.verify((Object)httprocessor)).process((HttpRequest)request, (HttpContext)context);
        Mockito.when((Object)conn.receiveResponseHeader()).thenReturn((Object)new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK"));
        HttpResponse response = executor.execute((HttpRequest)request, conn, (HttpContext)context);
        ((HttpClientConnection)Mockito.verify((Object)conn)).sendRequestHeader((HttpRequest)request);
        ((HttpClientConnection)Mockito.verify((Object)conn)).flush();
        ((HttpClientConnection)Mockito.verify((Object)conn)).receiveResponseHeader();
        ((HttpClientConnection)Mockito.verify((Object)conn)).receiveResponseEntity(response);
        executor.postProcess(response, httprocessor, (HttpContext)context);
        ((HttpProcessor)Mockito.verify((Object)httprocessor)).process(response, (HttpContext)context);
        Assert.assertSame((Object)conn, (Object)context.getConnection());
        Assert.assertSame((Object)request, (Object)context.getRequest());
        Assert.assertSame((Object)response, (Object)context.getResponse());
    }

    @Test
    public void testExecutionSkipIntermediateResponses() throws Exception {
        HttpProcessor httprocessor = (HttpProcessor)Mockito.mock(HttpProcessor.class);
        HttpClientConnection conn = (HttpClientConnection)Mockito.mock(HttpClientConnection.class);
        HttpRequestExecutor executor = new HttpRequestExecutor();
        HttpCoreContext context = HttpCoreContext.create();
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        executor.preProcess((HttpRequest)request, httprocessor, (HttpContext)context);
        ((HttpProcessor)Mockito.verify((Object)httprocessor)).process((HttpRequest)request, (HttpContext)context);
        Mockito.when((Object)conn.receiveResponseHeader()).thenReturn((Object)new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 100, "OK"), (Object[])new HttpResponse[]{new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 101, "OK"), new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 102, "OK"), new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK")});
        HttpResponse response = executor.execute((HttpRequest)request, conn, (HttpContext)context);
        ((HttpClientConnection)Mockito.verify((Object)conn)).sendRequestHeader((HttpRequest)request);
        ((HttpClientConnection)Mockito.verify((Object)conn)).flush();
        ((HttpClientConnection)Mockito.verify((Object)conn, (VerificationMode)Mockito.times((int)4))).receiveResponseHeader();
        ((HttpClientConnection)Mockito.verify((Object)conn, (VerificationMode)Mockito.times((int)1))).receiveResponseEntity(response);
        executor.postProcess(response, httprocessor, (HttpContext)context);
        ((HttpProcessor)Mockito.verify((Object)httprocessor)).process(response, (HttpContext)context);
        Assert.assertSame((Object)conn, (Object)context.getConnection());
        Assert.assertSame((Object)request, (Object)context.getRequest());
        Assert.assertSame((Object)response, (Object)context.getResponse());
    }

    @Test
    public void testExecutionNoResponseBody() throws Exception {
        HttpProcessor httprocessor = (HttpProcessor)Mockito.mock(HttpProcessor.class);
        HttpClientConnection conn = (HttpClientConnection)Mockito.mock(HttpClientConnection.class);
        HttpRequestExecutor executor = new HttpRequestExecutor();
        HttpCoreContext context = HttpCoreContext.create();
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        executor.preProcess((HttpRequest)request, httprocessor, (HttpContext)context);
        ((HttpProcessor)Mockito.verify((Object)httprocessor)).process((HttpRequest)request, (HttpContext)context);
        Mockito.when((Object)conn.receiveResponseHeader()).thenReturn((Object)new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 204, "OK"));
        HttpResponse response = executor.execute((HttpRequest)request, conn, (HttpContext)context);
        ((HttpClientConnection)Mockito.verify((Object)conn)).sendRequestHeader((HttpRequest)request);
        ((HttpClientConnection)Mockito.verify((Object)conn)).flush();
        ((HttpClientConnection)Mockito.verify((Object)conn)).receiveResponseHeader();
        ((HttpClientConnection)Mockito.verify((Object)conn, (VerificationMode)Mockito.never())).receiveResponseEntity(response);
        executor.postProcess(response, httprocessor, (HttpContext)context);
        ((HttpProcessor)Mockito.verify((Object)httprocessor)).process(response, (HttpContext)context);
    }

    @Test
    public void testExecutionHead() throws Exception {
        HttpProcessor httprocessor = (HttpProcessor)Mockito.mock(HttpProcessor.class);
        HttpClientConnection conn = (HttpClientConnection)Mockito.mock(HttpClientConnection.class);
        HttpRequestExecutor executor = new HttpRequestExecutor();
        HttpCoreContext context = HttpCoreContext.create();
        BasicHttpRequest request = new BasicHttpRequest("HEAD", "/");
        executor.preProcess((HttpRequest)request, httprocessor, (HttpContext)context);
        ((HttpProcessor)Mockito.verify((Object)httprocessor)).process((HttpRequest)request, (HttpContext)context);
        Mockito.when((Object)conn.receiveResponseHeader()).thenReturn((Object)new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK"));
        HttpResponse response = executor.execute((HttpRequest)request, conn, (HttpContext)context);
        ((HttpClientConnection)Mockito.verify((Object)conn)).sendRequestHeader((HttpRequest)request);
        ((HttpClientConnection)Mockito.verify((Object)conn)).flush();
        ((HttpClientConnection)Mockito.verify((Object)conn)).receiveResponseHeader();
        ((HttpClientConnection)Mockito.verify((Object)conn, (VerificationMode)Mockito.never())).receiveResponseEntity(response);
        executor.postProcess(response, httprocessor, (HttpContext)context);
        ((HttpProcessor)Mockito.verify((Object)httprocessor)).process(response, (HttpContext)context);
    }

    @Test
    public void testExecutionEntityEnclosingRequest() throws Exception {
        HttpProcessor httprocessor = (HttpProcessor)Mockito.mock(HttpProcessor.class);
        HttpClientConnection conn = (HttpClientConnection)Mockito.mock(HttpClientConnection.class);
        HttpRequestExecutor executor = new HttpRequestExecutor();
        HttpCoreContext context = HttpCoreContext.create();
        BasicHttpEntityEnclosingRequest request = new BasicHttpEntityEnclosingRequest("POST", "/");
        HttpEntity entity = (HttpEntity)Mockito.mock(HttpEntity.class);
        request.setEntity(entity);
        executor.preProcess((HttpRequest)request, httprocessor, (HttpContext)context);
        ((HttpProcessor)Mockito.verify((Object)httprocessor)).process((HttpRequest)request, (HttpContext)context);
        Mockito.when((Object)conn.receiveResponseHeader()).thenReturn((Object)new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK"));
        HttpResponse response = executor.execute((HttpRequest)request, conn, (HttpContext)context);
        ((HttpClientConnection)Mockito.verify((Object)conn)).sendRequestHeader((HttpRequest)request);
        ((HttpClientConnection)Mockito.verify((Object)conn)).sendRequestEntity((HttpEntityEnclosingRequest)request);
        ((HttpClientConnection)Mockito.verify((Object)conn)).flush();
        ((HttpClientConnection)Mockito.verify((Object)conn)).receiveResponseHeader();
        ((HttpClientConnection)Mockito.verify((Object)conn)).receiveResponseEntity(response);
        executor.postProcess(response, httprocessor, (HttpContext)context);
        ((HttpProcessor)Mockito.verify((Object)httprocessor)).process(response, (HttpContext)context);
    }

    @Test
    public void testExecutionEntityEnclosingRequestWithExpectContinueSuccess() throws Exception {
        HttpProcessor httprocessor = (HttpProcessor)Mockito.mock(HttpProcessor.class);
        HttpClientConnection conn = (HttpClientConnection)Mockito.mock(HttpClientConnection.class);
        HttpRequestExecutor executor = new HttpRequestExecutor();
        HttpCoreContext context = HttpCoreContext.create();
        BasicHttpEntityEnclosingRequest request = new BasicHttpEntityEnclosingRequest("POST", "/");
        request.addHeader("Expect", "100-continue");
        HttpEntity entity = (HttpEntity)Mockito.mock(HttpEntity.class);
        request.setEntity(entity);
        executor.preProcess((HttpRequest)request, httprocessor, (HttpContext)context);
        ((HttpProcessor)Mockito.verify((Object)httprocessor)).process((HttpRequest)request, (HttpContext)context);
        Mockito.when((Object)conn.receiveResponseHeader()).thenReturn((Object)new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 100, "Continue"), (Object[])new HttpResponse[]{new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK")});
        Mockito.when((Object)conn.isResponseAvailable(Matchers.anyInt())).thenReturn((Object)Boolean.TRUE);
        HttpResponse response = executor.execute((HttpRequest)request, conn, (HttpContext)context);
        ((HttpClientConnection)Mockito.verify((Object)conn)).sendRequestHeader((HttpRequest)request);
        ((HttpClientConnection)Mockito.verify((Object)conn)).sendRequestEntity((HttpEntityEnclosingRequest)request);
        ((HttpClientConnection)Mockito.verify((Object)conn, (VerificationMode)Mockito.times((int)2))).flush();
        ((HttpClientConnection)Mockito.verify((Object)conn)).isResponseAvailable(3000);
        ((HttpClientConnection)Mockito.verify((Object)conn, (VerificationMode)Mockito.times((int)2))).receiveResponseHeader();
        ((HttpClientConnection)Mockito.verify((Object)conn)).receiveResponseEntity(response);
        executor.postProcess(response, httprocessor, (HttpContext)context);
        ((HttpProcessor)Mockito.verify((Object)httprocessor)).process(response, (HttpContext)context);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)context.isRequestSent());
    }

    @Test
    public void testExecutionEntityEnclosingRequestWithExpectContinueFailure() throws Exception {
        HttpProcessor httprocessor = (HttpProcessor)Mockito.mock(HttpProcessor.class);
        HttpClientConnection conn = (HttpClientConnection)Mockito.mock(HttpClientConnection.class);
        HttpRequestExecutor executor = new HttpRequestExecutor();
        HttpCoreContext context = HttpCoreContext.create();
        BasicHttpEntityEnclosingRequest request = new BasicHttpEntityEnclosingRequest("POST", "/");
        request.addHeader("Expect", "100-continue");
        HttpEntity entity = (HttpEntity)Mockito.mock(HttpEntity.class);
        request.setEntity(entity);
        executor.preProcess((HttpRequest)request, httprocessor, (HttpContext)context);
        ((HttpProcessor)Mockito.verify((Object)httprocessor)).process((HttpRequest)request, (HttpContext)context);
        Mockito.when((Object)conn.receiveResponseHeader()).thenReturn((Object)new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 402, "OK"));
        Mockito.when((Object)conn.isResponseAvailable(Matchers.anyInt())).thenReturn((Object)Boolean.TRUE);
        HttpResponse response = executor.execute((HttpRequest)request, conn, (HttpContext)context);
        ((HttpClientConnection)Mockito.verify((Object)conn)).sendRequestHeader((HttpRequest)request);
        ((HttpClientConnection)Mockito.verify((Object)conn, (VerificationMode)Mockito.never())).sendRequestEntity((HttpEntityEnclosingRequest)request);
        ((HttpClientConnection)Mockito.verify((Object)conn, (VerificationMode)Mockito.times((int)2))).flush();
        ((HttpClientConnection)Mockito.verify((Object)conn)).isResponseAvailable(3000);
        ((HttpClientConnection)Mockito.verify((Object)conn)).receiveResponseHeader();
        ((HttpClientConnection)Mockito.verify((Object)conn)).receiveResponseEntity(response);
        executor.postProcess(response, httprocessor, (HttpContext)context);
        ((HttpProcessor)Mockito.verify((Object)httprocessor)).process(response, (HttpContext)context);
    }

    @Test
    public void testExecutionEntityEnclosingRequestUnsupportedIntermediateResponse() throws Exception {
        HttpProcessor httprocessor = (HttpProcessor)Mockito.mock(HttpProcessor.class);
        HttpClientConnection conn = (HttpClientConnection)Mockito.mock(HttpClientConnection.class);
        HttpRequestExecutor executor = new HttpRequestExecutor();
        HttpCoreContext context = HttpCoreContext.create();
        BasicHttpEntityEnclosingRequest request = new BasicHttpEntityEnclosingRequest("POST", "/");
        request.addHeader("Expect", "100-continue");
        HttpEntity entity = (HttpEntity)Mockito.mock(HttpEntity.class);
        request.setEntity(entity);
        executor.preProcess((HttpRequest)request, httprocessor, (HttpContext)context);
        ((HttpProcessor)Mockito.verify((Object)httprocessor)).process((HttpRequest)request, (HttpContext)context);
        Mockito.when((Object)conn.receiveResponseHeader()).thenReturn((Object)new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 101, "OK"));
        Mockito.when((Object)conn.isResponseAvailable(Matchers.anyInt())).thenReturn((Object)Boolean.TRUE);
        try {
            executor.execute((HttpRequest)request, conn, (HttpContext)context);
            Assert.fail((String)"ProtocolException should have been thrown");
        }
        catch (ProtocolException ex) {
            ((HttpClientConnection)Mockito.verify((Object)conn)).close();
            Assert.assertEquals((Object)Boolean.FALSE, (Object)context.isRequestSent());
        }
    }

    @Test
    public void testExecutionEntityEnclosingRequestWithExpectContinueNoResponse() throws Exception {
        HttpProcessor httprocessor = (HttpProcessor)Mockito.mock(HttpProcessor.class);
        HttpClientConnection conn = (HttpClientConnection)Mockito.mock(HttpClientConnection.class);
        HttpRequestExecutor executor = new HttpRequestExecutor();
        HttpCoreContext context = HttpCoreContext.create();
        BasicHttpEntityEnclosingRequest request = new BasicHttpEntityEnclosingRequest("POST", "/");
        request.addHeader("Expect", "100-continue");
        HttpEntity entity = (HttpEntity)Mockito.mock(HttpEntity.class);
        request.setEntity(entity);
        executor.preProcess((HttpRequest)request, httprocessor, (HttpContext)context);
        ((HttpProcessor)Mockito.verify((Object)httprocessor)).process((HttpRequest)request, (HttpContext)context);
        Mockito.when((Object)conn.receiveResponseHeader()).thenReturn((Object)new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK"));
        Mockito.when((Object)conn.isResponseAvailable(Matchers.anyInt())).thenReturn((Object)Boolean.FALSE);
        HttpResponse response = executor.execute((HttpRequest)request, conn, (HttpContext)context);
        ((HttpClientConnection)Mockito.verify((Object)conn)).sendRequestHeader((HttpRequest)request);
        ((HttpClientConnection)Mockito.verify((Object)conn)).sendRequestEntity((HttpEntityEnclosingRequest)request);
        ((HttpClientConnection)Mockito.verify((Object)conn, (VerificationMode)Mockito.times((int)2))).flush();
        ((HttpClientConnection)Mockito.verify((Object)conn)).isResponseAvailable(3000);
        ((HttpClientConnection)Mockito.verify((Object)conn)).receiveResponseHeader();
        ((HttpClientConnection)Mockito.verify((Object)conn)).receiveResponseEntity(response);
        executor.postProcess(response, httprocessor, (HttpContext)context);
        ((HttpProcessor)Mockito.verify((Object)httprocessor)).process(response, (HttpContext)context);
    }

    @Test
    public void testExecutionIOException() throws Exception {
        HttpClientConnection conn = (HttpClientConnection)Mockito.mock(HttpClientConnection.class);
        HttpRequestExecutor executor = new HttpRequestExecutor();
        HttpCoreContext context = HttpCoreContext.create();
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        ((HttpClientConnection)Mockito.doThrow((Throwable)new IOException("Oopsie")).when((Object)conn)).sendRequestHeader((HttpRequest)request);
        try {
            executor.execute((HttpRequest)request, conn, (HttpContext)context);
            Assert.fail((String)"IOException should have been thrown");
        }
        catch (IOException ex) {
            ((HttpClientConnection)Mockito.verify((Object)conn)).close();
            Assert.assertEquals((Object)Boolean.FALSE, (Object)context.isRequestSent());
        }
    }

    @Test
    public void testExecutionRuntimeException() throws Exception {
        HttpClientConnection conn = (HttpClientConnection)Mockito.mock(HttpClientConnection.class);
        HttpRequestExecutor executor = new HttpRequestExecutor();
        HttpCoreContext context = HttpCoreContext.create();
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        ((HttpClientConnection)Mockito.doThrow((Throwable)new RuntimeException("Oopsie")).when((Object)conn)).receiveResponseHeader();
        try {
            executor.execute((HttpRequest)request, conn, (HttpContext)context);
            Assert.fail((String)"IOException should have been thrown");
        }
        catch (RuntimeException ex) {
            ((HttpClientConnection)Mockito.verify((Object)conn)).close();
            Assert.assertEquals((Object)Boolean.TRUE, (Object)context.isRequestSent());
        }
    }
}

