/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.protocol;

import java.io.InputStream;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseFactory;
import org.apache.http.HttpServerConnection;
import org.apache.http.HttpVersion;
import org.apache.http.MethodNotSupportedException;
import org.apache.http.ProtocolException;
import org.apache.http.ProtocolVersion;
import org.apache.http.UnsupportedHttpVersionException;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.apache.http.message.BasicHttpRequest;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpCoreContext;
import org.apache.http.protocol.HttpExpectationVerifier;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpRequestHandler;
import org.apache.http.protocol.HttpRequestHandlerMapper;
import org.apache.http.protocol.HttpService;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestHttpService {
    @Test
    public void testInvalidInitialization() throws Exception {
        ConnectionReuseStrategy connReuseStrategy = (ConnectionReuseStrategy)Mockito.mock(ConnectionReuseStrategy.class);
        HttpResponseFactory responseFactory = (HttpResponseFactory)Mockito.mock(HttpResponseFactory.class);
        HttpRequestHandlerMapper handlerResolver = (HttpRequestHandlerMapper)Mockito.mock(HttpRequestHandlerMapper.class);
        try {
            new HttpService(null, connReuseStrategy, responseFactory, handlerResolver);
            Assert.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
    }

    @Test
    public void testBasicExecution() throws Exception {
        HttpProcessor httprocessor = (HttpProcessor)Mockito.mock(HttpProcessor.class);
        ConnectionReuseStrategy connReuseStrategy = (ConnectionReuseStrategy)Mockito.mock(ConnectionReuseStrategy.class);
        HttpResponseFactory responseFactory = (HttpResponseFactory)Mockito.mock(HttpResponseFactory.class);
        HttpRequestHandlerMapper handlerResolver = (HttpRequestHandlerMapper)Mockito.mock(HttpRequestHandlerMapper.class);
        HttpService httpservice = new HttpService(httprocessor, connReuseStrategy, responseFactory, handlerResolver);
        HttpCoreContext context = HttpCoreContext.create();
        HttpServerConnection conn = (HttpServerConnection)Mockito.mock(HttpServerConnection.class);
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        Mockito.when((Object)conn.receiveRequestHeader()).thenReturn((Object)request);
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        Mockito.when((Object)responseFactory.newHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, (HttpContext)context)).thenReturn((Object)response);
        Mockito.when((Object)connReuseStrategy.keepAlive((HttpResponse)response, (HttpContext)context)).thenReturn((Object)Boolean.FALSE);
        httpservice.handleRequest(conn, (HttpContext)context);
        Assert.assertEquals((long)501L, (long)response.getStatusLine().getStatusCode());
        Assert.assertSame((Object)conn, (Object)context.getConnection());
        Assert.assertSame((Object)request, (Object)context.getRequest());
        Assert.assertSame((Object)response, (Object)context.getResponse());
        ((HttpProcessor)Mockito.verify((Object)httprocessor)).process((HttpRequest)request, (HttpContext)context);
        ((HttpProcessor)Mockito.verify((Object)httprocessor)).process((HttpResponse)response, (HttpContext)context);
        ((HttpServerConnection)Mockito.verify((Object)conn)).sendResponseHeader((HttpResponse)response);
        ((HttpServerConnection)Mockito.verify((Object)conn)).sendResponseEntity((HttpResponse)response);
        ((HttpServerConnection)Mockito.verify((Object)conn)).flush();
        ((HttpServerConnection)Mockito.verify((Object)conn)).close();
    }

    @Test
    public void testBasicExecutionHTTP10() throws Exception {
        HttpProcessor httprocessor = (HttpProcessor)Mockito.mock(HttpProcessor.class);
        ConnectionReuseStrategy connReuseStrategy = (ConnectionReuseStrategy)Mockito.mock(ConnectionReuseStrategy.class);
        HttpResponseFactory responseFactory = (HttpResponseFactory)Mockito.mock(HttpResponseFactory.class);
        HttpRequestHandlerMapper handlerResolver = (HttpRequestHandlerMapper)Mockito.mock(HttpRequestHandlerMapper.class);
        HttpService httpservice = new HttpService(httprocessor, connReuseStrategy, responseFactory, handlerResolver);
        HttpCoreContext context = HttpCoreContext.create();
        HttpServerConnection conn = (HttpServerConnection)Mockito.mock(HttpServerConnection.class);
        BasicHttpRequest request = new BasicHttpRequest("GET", "/", (ProtocolVersion)HttpVersion.HTTP_1_0);
        Mockito.when((Object)conn.receiveRequestHeader()).thenReturn((Object)request);
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_0, 200, "OK");
        Mockito.when((Object)responseFactory.newHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, (HttpContext)context)).thenReturn((Object)response);
        Mockito.when((Object)connReuseStrategy.keepAlive((HttpResponse)response, (HttpContext)context)).thenReturn((Object)Boolean.FALSE);
        httpservice.handleRequest(conn, (HttpContext)context);
        ((HttpResponseFactory)Mockito.verify((Object)responseFactory)).newHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, (HttpContext)context);
    }

    @Test
    public void testBasicProtocolDowngrade() throws Exception {
        HttpProcessor httprocessor = (HttpProcessor)Mockito.mock(HttpProcessor.class);
        ConnectionReuseStrategy connReuseStrategy = (ConnectionReuseStrategy)Mockito.mock(ConnectionReuseStrategy.class);
        HttpResponseFactory responseFactory = (HttpResponseFactory)Mockito.mock(HttpResponseFactory.class);
        HttpRequestHandlerMapper handlerResolver = (HttpRequestHandlerMapper)Mockito.mock(HttpRequestHandlerMapper.class);
        HttpService httpservice = new HttpService(httprocessor, connReuseStrategy, responseFactory, handlerResolver);
        HttpCoreContext context = HttpCoreContext.create();
        HttpServerConnection conn = (HttpServerConnection)Mockito.mock(HttpServerConnection.class);
        BasicHttpRequest request = new BasicHttpRequest("GET", "/", (ProtocolVersion)new HttpVersion(20, 45));
        Mockito.when((Object)conn.receiveRequestHeader()).thenReturn((Object)request);
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        Mockito.when((Object)responseFactory.newHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, (HttpContext)context)).thenReturn((Object)response);
        Mockito.when((Object)connReuseStrategy.keepAlive((HttpResponse)response, (HttpContext)context)).thenReturn((Object)Boolean.FALSE);
        httpservice.handleRequest(conn, (HttpContext)context);
        ((HttpResponseFactory)Mockito.verify((Object)responseFactory)).newHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, (HttpContext)context);
    }

    @Test
    public void testExecutionEntityEnclosingRequest() throws Exception {
        HttpProcessor httprocessor = (HttpProcessor)Mockito.mock(HttpProcessor.class);
        ConnectionReuseStrategy connReuseStrategy = (ConnectionReuseStrategy)Mockito.mock(ConnectionReuseStrategy.class);
        HttpResponseFactory responseFactory = (HttpResponseFactory)Mockito.mock(HttpResponseFactory.class);
        HttpRequestHandlerMapper handlerResolver = (HttpRequestHandlerMapper)Mockito.mock(HttpRequestHandlerMapper.class);
        HttpService httpservice = new HttpService(httprocessor, connReuseStrategy, responseFactory, handlerResolver);
        HttpCoreContext context = HttpCoreContext.create();
        HttpServerConnection conn = (HttpServerConnection)Mockito.mock(HttpServerConnection.class);
        BasicHttpEntityEnclosingRequest request = new BasicHttpEntityEnclosingRequest("POST", "/");
        InputStream inStream = (InputStream)Mockito.mock(InputStream.class);
        InputStreamEntity entity = new InputStreamEntity(inStream, -1L);
        request.setEntity((HttpEntity)entity);
        Mockito.when((Object)conn.receiveRequestHeader()).thenReturn((Object)request);
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        Mockito.when((Object)responseFactory.newHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, (HttpContext)context)).thenReturn((Object)response);
        Mockito.when((Object)connReuseStrategy.keepAlive((HttpResponse)response, (HttpContext)context)).thenReturn((Object)Boolean.FALSE);
        httpservice.handleRequest(conn, (HttpContext)context);
        Assert.assertEquals((long)501L, (long)response.getStatusLine().getStatusCode());
        Assert.assertSame((Object)conn, (Object)context.getConnection());
        Assert.assertSame((Object)request, (Object)context.getRequest());
        Assert.assertSame((Object)response, (Object)context.getResponse());
        ((HttpServerConnection)Mockito.verify((Object)conn)).receiveRequestEntity((HttpEntityEnclosingRequest)request);
        ((HttpProcessor)Mockito.verify((Object)httprocessor)).process((HttpRequest)request, (HttpContext)context);
        ((InputStream)Mockito.verify((Object)inStream)).close();
        ((HttpProcessor)Mockito.verify((Object)httprocessor)).process((HttpResponse)response, (HttpContext)context);
        ((HttpServerConnection)Mockito.verify((Object)conn)).sendResponseHeader((HttpResponse)response);
        ((HttpServerConnection)Mockito.verify((Object)conn)).sendResponseEntity((HttpResponse)response);
        ((HttpServerConnection)Mockito.verify((Object)conn)).flush();
        ((HttpServerConnection)Mockito.verify((Object)conn)).close();
    }

    @Test
    public void testExecutionEntityEnclosingRequestWithExpectContinue() throws Exception {
        HttpProcessor httprocessor = (HttpProcessor)Mockito.mock(HttpProcessor.class);
        ConnectionReuseStrategy connReuseStrategy = (ConnectionReuseStrategy)Mockito.mock(ConnectionReuseStrategy.class);
        HttpResponseFactory responseFactory = (HttpResponseFactory)Mockito.mock(HttpResponseFactory.class);
        HttpRequestHandlerMapper handlerResolver = (HttpRequestHandlerMapper)Mockito.mock(HttpRequestHandlerMapper.class);
        HttpService httpservice = new HttpService(httprocessor, connReuseStrategy, responseFactory, handlerResolver);
        HttpCoreContext context = HttpCoreContext.create();
        HttpServerConnection conn = (HttpServerConnection)Mockito.mock(HttpServerConnection.class);
        BasicHttpEntityEnclosingRequest request = new BasicHttpEntityEnclosingRequest("POST", "/");
        request.addHeader("Expect", "100-continue");
        InputStream inStream = (InputStream)Mockito.mock(InputStream.class);
        InputStreamEntity entity = new InputStreamEntity(inStream, -1L);
        request.setEntity((HttpEntity)entity);
        Mockito.when((Object)conn.receiveRequestHeader()).thenReturn((Object)request);
        BasicHttpResponse resp100 = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 100, "Continue");
        Mockito.when((Object)responseFactory.newHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 100, (HttpContext)context)).thenReturn((Object)resp100);
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        Mockito.when((Object)responseFactory.newHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, (HttpContext)context)).thenReturn((Object)response);
        Mockito.when((Object)connReuseStrategy.keepAlive((HttpResponse)response, (HttpContext)context)).thenReturn((Object)Boolean.FALSE);
        httpservice.handleRequest(conn, (HttpContext)context);
        Assert.assertEquals((long)501L, (long)response.getStatusLine().getStatusCode());
        Assert.assertSame((Object)conn, (Object)context.getConnection());
        Assert.assertSame((Object)request, (Object)context.getRequest());
        Assert.assertSame((Object)response, (Object)context.getResponse());
        ((HttpServerConnection)Mockito.verify((Object)conn)).sendResponseHeader((HttpResponse)resp100);
        ((HttpServerConnection)Mockito.verify((Object)conn)).receiveRequestEntity((HttpEntityEnclosingRequest)request);
        ((HttpProcessor)Mockito.verify((Object)httprocessor)).process((HttpRequest)request, (HttpContext)context);
        ((InputStream)Mockito.verify((Object)inStream)).close();
        ((HttpProcessor)Mockito.verify((Object)httprocessor)).process((HttpResponse)response, (HttpContext)context);
        ((HttpServerConnection)Mockito.verify((Object)conn)).sendResponseHeader((HttpResponse)response);
        ((HttpServerConnection)Mockito.verify((Object)conn)).sendResponseEntity((HttpResponse)response);
        ((HttpServerConnection)Mockito.verify((Object)conn, (VerificationMode)Mockito.times((int)2))).flush();
        ((HttpServerConnection)Mockito.verify((Object)conn)).close();
    }

    @Test
    public void testExecutionEntityEnclosingRequestCustomExpectationVerifier() throws Exception {
        HttpProcessor httprocessor = (HttpProcessor)Mockito.mock(HttpProcessor.class);
        ConnectionReuseStrategy connReuseStrategy = (ConnectionReuseStrategy)Mockito.mock(ConnectionReuseStrategy.class);
        HttpResponseFactory responseFactory = (HttpResponseFactory)Mockito.mock(HttpResponseFactory.class);
        HttpRequestHandlerMapper handlerResolver = (HttpRequestHandlerMapper)Mockito.mock(HttpRequestHandlerMapper.class);
        HttpExpectationVerifier expectationVerifier = new HttpExpectationVerifier(){

            public void verify(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException {
                response.setStatusCode(401);
            }
        };
        HttpService httpservice = new HttpService(httprocessor, connReuseStrategy, responseFactory, handlerResolver, expectationVerifier);
        HttpCoreContext context = HttpCoreContext.create();
        HttpServerConnection conn = (HttpServerConnection)Mockito.mock(HttpServerConnection.class);
        BasicHttpEntityEnclosingRequest request = new BasicHttpEntityEnclosingRequest("POST", "/");
        request.addHeader("Expect", "100-continue");
        InputStream inStream = (InputStream)Mockito.mock(InputStream.class);
        InputStreamEntity entity = new InputStreamEntity(inStream, -1L);
        request.setEntity((HttpEntity)entity);
        Mockito.when((Object)conn.receiveRequestHeader()).thenReturn((Object)request);
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 100, "Continue");
        Mockito.when((Object)responseFactory.newHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 100, (HttpContext)context)).thenReturn((Object)response);
        Mockito.when((Object)connReuseStrategy.keepAlive((HttpResponse)response, (HttpContext)context)).thenReturn((Object)Boolean.FALSE);
        httpservice.handleRequest(conn, (HttpContext)context);
        Assert.assertSame((Object)conn, (Object)context.getConnection());
        Assert.assertSame((Object)request, (Object)context.getRequest());
        Assert.assertSame((Object)response, (Object)context.getResponse());
        Assert.assertEquals((long)401L, (long)response.getStatusLine().getStatusCode());
        ((HttpServerConnection)Mockito.verify((Object)conn)).sendResponseHeader((HttpResponse)response);
        ((HttpServerConnection)Mockito.verify((Object)conn, (VerificationMode)Mockito.never())).receiveRequestEntity((HttpEntityEnclosingRequest)request);
        ((HttpProcessor)Mockito.verify((Object)httprocessor)).process((HttpResponse)response, (HttpContext)context);
        ((HttpServerConnection)Mockito.verify((Object)conn)).sendResponseHeader((HttpResponse)response);
        ((HttpServerConnection)Mockito.verify((Object)conn)).sendResponseEntity((HttpResponse)response);
        ((HttpServerConnection)Mockito.verify((Object)conn)).flush();
        ((HttpServerConnection)Mockito.verify((Object)conn)).close();
    }

    @Test
    public void testExecutionExceptionInCustomExpectationVerifier() throws Exception {
        HttpProcessor httprocessor = (HttpProcessor)Mockito.mock(HttpProcessor.class);
        ConnectionReuseStrategy connReuseStrategy = (ConnectionReuseStrategy)Mockito.mock(ConnectionReuseStrategy.class);
        HttpResponseFactory responseFactory = (HttpResponseFactory)Mockito.mock(HttpResponseFactory.class);
        HttpExpectationVerifier expectationVerifier = (HttpExpectationVerifier)Mockito.mock(HttpExpectationVerifier.class);
        HttpRequestHandlerMapper handlerResolver = (HttpRequestHandlerMapper)Mockito.mock(HttpRequestHandlerMapper.class);
        HttpService httpservice = new HttpService(httprocessor, connReuseStrategy, responseFactory, handlerResolver, expectationVerifier);
        HttpCoreContext context = HttpCoreContext.create();
        HttpServerConnection conn = (HttpServerConnection)Mockito.mock(HttpServerConnection.class);
        BasicHttpEntityEnclosingRequest request = new BasicHttpEntityEnclosingRequest("POST", "/");
        request.addHeader("Expect", "100-continue");
        InputStream inStream = (InputStream)Mockito.mock(InputStream.class);
        InputStreamEntity entity = new InputStreamEntity(inStream, -1L);
        request.setEntity((HttpEntity)entity);
        Mockito.when((Object)conn.receiveRequestHeader()).thenReturn((Object)request);
        BasicHttpResponse resp100 = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 100, "Continue");
        Mockito.when((Object)responseFactory.newHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 100, (HttpContext)context)).thenReturn((Object)resp100);
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_0, 500, "Oppsie");
        Mockito.when((Object)responseFactory.newHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_0, 500, (HttpContext)context)).thenReturn((Object)response);
        ((HttpExpectationVerifier)Mockito.doThrow((Throwable)new HttpException("Oopsie")).when((Object)expectationVerifier)).verify((HttpRequest)request, (HttpResponse)resp100, (HttpContext)context);
        Mockito.when((Object)connReuseStrategy.keepAlive((HttpResponse)response, (HttpContext)context)).thenReturn((Object)Boolean.FALSE);
        httpservice.handleRequest(conn, (HttpContext)context);
        Assert.assertSame((Object)conn, (Object)context.getConnection());
        Assert.assertSame((Object)request, (Object)context.getRequest());
        Assert.assertSame((Object)response, (Object)context.getResponse());
        Assert.assertEquals((long)500L, (long)response.getStatusLine().getStatusCode());
        ((HttpServerConnection)Mockito.verify((Object)conn)).sendResponseHeader((HttpResponse)response);
        ((HttpServerConnection)Mockito.verify((Object)conn, (VerificationMode)Mockito.never())).receiveRequestEntity((HttpEntityEnclosingRequest)request);
        ((HttpProcessor)Mockito.verify((Object)httprocessor)).process((HttpResponse)response, (HttpContext)context);
        ((HttpServerConnection)Mockito.verify((Object)conn)).sendResponseHeader((HttpResponse)response);
        ((HttpServerConnection)Mockito.verify((Object)conn)).sendResponseEntity((HttpResponse)response);
        ((HttpServerConnection)Mockito.verify((Object)conn)).flush();
        ((HttpServerConnection)Mockito.verify((Object)conn)).close();
    }

    @Test
    public void testMethodNotSupported() throws Exception {
        HttpProcessor httprocessor = (HttpProcessor)Mockito.mock(HttpProcessor.class);
        ConnectionReuseStrategy connReuseStrategy = (ConnectionReuseStrategy)Mockito.mock(ConnectionReuseStrategy.class);
        HttpResponseFactory responseFactory = (HttpResponseFactory)Mockito.mock(HttpResponseFactory.class);
        HttpRequestHandlerMapper handlerResolver = (HttpRequestHandlerMapper)Mockito.mock(HttpRequestHandlerMapper.class);
        HttpRequestHandler requestHandler = (HttpRequestHandler)Mockito.mock(HttpRequestHandler.class);
        HttpService httpservice = new HttpService(httprocessor, connReuseStrategy, responseFactory, handlerResolver);
        HttpCoreContext context = HttpCoreContext.create();
        HttpServerConnection conn = (HttpServerConnection)Mockito.mock(HttpServerConnection.class);
        BasicHttpRequest request = new BasicHttpRequest("whatever", "/");
        Mockito.when((Object)conn.receiveRequestHeader()).thenReturn((Object)request);
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        Mockito.when((Object)responseFactory.newHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, (HttpContext)context)).thenReturn((Object)response);
        BasicHttpResponse error = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_0, 500, "Oppsie");
        Mockito.when((Object)responseFactory.newHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_0, 500, (HttpContext)context)).thenReturn((Object)error);
        Mockito.when((Object)handlerResolver.lookup((HttpRequest)request)).thenReturn((Object)requestHandler);
        ((HttpRequestHandler)Mockito.doThrow((Throwable)new MethodNotSupportedException("whatever")).when((Object)requestHandler)).handle((HttpRequest)request, (HttpResponse)response, (HttpContext)context);
        Mockito.when((Object)connReuseStrategy.keepAlive((HttpResponse)error, (HttpContext)context)).thenReturn((Object)Boolean.FALSE);
        httpservice.handleRequest(conn, (HttpContext)context);
        Assert.assertSame((Object)conn, (Object)context.getConnection());
        Assert.assertSame((Object)request, (Object)context.getRequest());
        Assert.assertSame((Object)error, (Object)context.getResponse());
        Assert.assertEquals((long)501L, (long)error.getStatusLine().getStatusCode());
        ((HttpServerConnection)Mockito.verify((Object)conn)).sendResponseHeader((HttpResponse)error);
        ((HttpProcessor)Mockito.verify((Object)httprocessor)).process((HttpResponse)error, (HttpContext)context);
        ((HttpServerConnection)Mockito.verify((Object)conn)).sendResponseHeader((HttpResponse)error);
        ((HttpServerConnection)Mockito.verify((Object)conn)).sendResponseEntity((HttpResponse)error);
        ((HttpServerConnection)Mockito.verify((Object)conn)).flush();
        ((HttpServerConnection)Mockito.verify((Object)conn)).close();
    }

    @Test
    public void testUnsupportedHttpVersionException() throws Exception {
        HttpProcessor httprocessor = (HttpProcessor)Mockito.mock(HttpProcessor.class);
        ConnectionReuseStrategy connReuseStrategy = (ConnectionReuseStrategy)Mockito.mock(ConnectionReuseStrategy.class);
        HttpResponseFactory responseFactory = (HttpResponseFactory)Mockito.mock(HttpResponseFactory.class);
        HttpRequestHandlerMapper handlerResolver = (HttpRequestHandlerMapper)Mockito.mock(HttpRequestHandlerMapper.class);
        HttpRequestHandler requestHandler = (HttpRequestHandler)Mockito.mock(HttpRequestHandler.class);
        HttpService httpservice = new HttpService(httprocessor, connReuseStrategy, responseFactory, handlerResolver);
        HttpCoreContext context = HttpCoreContext.create();
        HttpServerConnection conn = (HttpServerConnection)Mockito.mock(HttpServerConnection.class);
        BasicHttpRequest request = new BasicHttpRequest("whatever", "/");
        Mockito.when((Object)conn.receiveRequestHeader()).thenReturn((Object)request);
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        Mockito.when((Object)responseFactory.newHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, (HttpContext)context)).thenReturn((Object)response);
        BasicHttpResponse error = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_0, 500, "Oppsie");
        Mockito.when((Object)responseFactory.newHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_0, 500, (HttpContext)context)).thenReturn((Object)error);
        Mockito.when((Object)handlerResolver.lookup((HttpRequest)request)).thenReturn((Object)requestHandler);
        ((HttpRequestHandler)Mockito.doThrow((Throwable)new UnsupportedHttpVersionException()).when((Object)requestHandler)).handle((HttpRequest)request, (HttpResponse)response, (HttpContext)context);
        Mockito.when((Object)connReuseStrategy.keepAlive((HttpResponse)error, (HttpContext)context)).thenReturn((Object)Boolean.FALSE);
        httpservice.handleRequest(conn, (HttpContext)context);
        Assert.assertSame((Object)conn, (Object)context.getConnection());
        Assert.assertSame((Object)request, (Object)context.getRequest());
        Assert.assertSame((Object)error, (Object)context.getResponse());
        Assert.assertEquals((long)505L, (long)error.getStatusLine().getStatusCode());
        ((HttpServerConnection)Mockito.verify((Object)conn)).sendResponseHeader((HttpResponse)error);
        ((HttpProcessor)Mockito.verify((Object)httprocessor)).process((HttpResponse)error, (HttpContext)context);
        ((HttpServerConnection)Mockito.verify((Object)conn)).sendResponseHeader((HttpResponse)error);
        ((HttpServerConnection)Mockito.verify((Object)conn)).sendResponseEntity((HttpResponse)error);
        ((HttpServerConnection)Mockito.verify((Object)conn)).flush();
        ((HttpServerConnection)Mockito.verify((Object)conn)).close();
    }

    @Test
    public void testProtocolException() throws Exception {
        HttpProcessor httprocessor = (HttpProcessor)Mockito.mock(HttpProcessor.class);
        ConnectionReuseStrategy connReuseStrategy = (ConnectionReuseStrategy)Mockito.mock(ConnectionReuseStrategy.class);
        HttpResponseFactory responseFactory = (HttpResponseFactory)Mockito.mock(HttpResponseFactory.class);
        HttpRequestHandlerMapper handlerResolver = (HttpRequestHandlerMapper)Mockito.mock(HttpRequestHandlerMapper.class);
        HttpRequestHandler requestHandler = (HttpRequestHandler)Mockito.mock(HttpRequestHandler.class);
        HttpService httpservice = new HttpService(httprocessor, connReuseStrategy, responseFactory, handlerResolver);
        HttpCoreContext context = HttpCoreContext.create();
        HttpServerConnection conn = (HttpServerConnection)Mockito.mock(HttpServerConnection.class);
        BasicHttpRequest request = new BasicHttpRequest("whatever", "/");
        Mockito.when((Object)conn.receiveRequestHeader()).thenReturn((Object)request);
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        Mockito.when((Object)responseFactory.newHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, (HttpContext)context)).thenReturn((Object)response);
        BasicHttpResponse error = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_0, 500, "Oppsie");
        Mockito.when((Object)responseFactory.newHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_0, 500, (HttpContext)context)).thenReturn((Object)error);
        Mockito.when((Object)handlerResolver.lookup((HttpRequest)request)).thenReturn((Object)requestHandler);
        ((HttpRequestHandler)Mockito.doThrow((Throwable)new ProtocolException("oh, this world is wrong")).when((Object)requestHandler)).handle((HttpRequest)request, (HttpResponse)response, (HttpContext)context);
        Mockito.when((Object)connReuseStrategy.keepAlive((HttpResponse)error, (HttpContext)context)).thenReturn((Object)Boolean.FALSE);
        httpservice.handleRequest(conn, (HttpContext)context);
        Assert.assertSame((Object)conn, (Object)context.getConnection());
        Assert.assertSame((Object)request, (Object)context.getRequest());
        Assert.assertSame((Object)error, (Object)context.getResponse());
        Assert.assertEquals((long)400L, (long)error.getStatusLine().getStatusCode());
        ((HttpServerConnection)Mockito.verify((Object)conn)).sendResponseHeader((HttpResponse)error);
        ((HttpProcessor)Mockito.verify((Object)httprocessor)).process((HttpResponse)error, (HttpContext)context);
        ((HttpServerConnection)Mockito.verify((Object)conn)).sendResponseHeader((HttpResponse)error);
        ((HttpServerConnection)Mockito.verify((Object)conn)).sendResponseEntity((HttpResponse)error);
        ((HttpServerConnection)Mockito.verify((Object)conn)).flush();
        ((HttpServerConnection)Mockito.verify((Object)conn)).close();
    }

    @Test
    public void testConnectionKeepAlive() throws Exception {
        HttpProcessor httprocessor = (HttpProcessor)Mockito.mock(HttpProcessor.class);
        ConnectionReuseStrategy connReuseStrategy = (ConnectionReuseStrategy)Mockito.mock(ConnectionReuseStrategy.class);
        HttpResponseFactory responseFactory = (HttpResponseFactory)Mockito.mock(HttpResponseFactory.class);
        HttpRequestHandlerMapper handlerResolver = (HttpRequestHandlerMapper)Mockito.mock(HttpRequestHandlerMapper.class);
        HttpRequestHandler requestHandler = (HttpRequestHandler)Mockito.mock(HttpRequestHandler.class);
        HttpService httpservice = new HttpService(httprocessor, connReuseStrategy, responseFactory, handlerResolver);
        HttpCoreContext context = HttpCoreContext.create();
        HttpServerConnection conn = (HttpServerConnection)Mockito.mock(HttpServerConnection.class);
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        Mockito.when((Object)conn.receiveRequestHeader()).thenReturn((Object)request);
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        Mockito.when((Object)responseFactory.newHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, (HttpContext)context)).thenReturn((Object)response);
        Mockito.when((Object)handlerResolver.lookup((HttpRequest)request)).thenReturn((Object)requestHandler);
        Mockito.when((Object)connReuseStrategy.keepAlive((HttpResponse)response, (HttpContext)context)).thenReturn((Object)Boolean.TRUE);
        httpservice.handleRequest(conn, (HttpContext)context);
        Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        Assert.assertSame((Object)conn, (Object)context.getConnection());
        Assert.assertSame((Object)request, (Object)context.getRequest());
        Assert.assertSame((Object)response, (Object)context.getResponse());
        ((HttpProcessor)Mockito.verify((Object)httprocessor)).process((HttpRequest)request, (HttpContext)context);
        ((HttpProcessor)Mockito.verify((Object)httprocessor)).process((HttpResponse)response, (HttpContext)context);
        ((HttpServerConnection)Mockito.verify((Object)conn)).sendResponseHeader((HttpResponse)response);
        ((HttpServerConnection)Mockito.verify((Object)conn)).sendResponseEntity((HttpResponse)response);
        ((HttpServerConnection)Mockito.verify((Object)conn)).flush();
        ((HttpServerConnection)Mockito.verify((Object)conn, (VerificationMode)Mockito.never())).close();
    }

    @Test
    public void testNoContentResponse() throws Exception {
        HttpProcessor httprocessor = (HttpProcessor)Mockito.mock(HttpProcessor.class);
        ConnectionReuseStrategy connReuseStrategy = (ConnectionReuseStrategy)Mockito.mock(ConnectionReuseStrategy.class);
        HttpResponseFactory responseFactory = (HttpResponseFactory)Mockito.mock(HttpResponseFactory.class);
        HttpRequestHandlerMapper handlerResolver = (HttpRequestHandlerMapper)Mockito.mock(HttpRequestHandlerMapper.class);
        HttpRequestHandler requestHandler = (HttpRequestHandler)Mockito.mock(HttpRequestHandler.class);
        HttpService httpservice = new HttpService(httprocessor, connReuseStrategy, responseFactory, handlerResolver);
        HttpCoreContext context = HttpCoreContext.create();
        HttpServerConnection conn = (HttpServerConnection)Mockito.mock(HttpServerConnection.class);
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        Mockito.when((Object)conn.receiveRequestHeader()).thenReturn((Object)request);
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 204, "No Content");
        Mockito.when((Object)responseFactory.newHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, (HttpContext)context)).thenReturn((Object)response);
        Mockito.when((Object)handlerResolver.lookup((HttpRequest)request)).thenReturn((Object)requestHandler);
        Mockito.when((Object)connReuseStrategy.keepAlive((HttpResponse)response, (HttpContext)context)).thenReturn((Object)Boolean.TRUE);
        httpservice.handleRequest(conn, (HttpContext)context);
        Assert.assertSame((Object)conn, (Object)context.getConnection());
        Assert.assertSame((Object)request, (Object)context.getRequest());
        ((HttpProcessor)Mockito.verify((Object)httprocessor)).process((HttpResponse)response, (HttpContext)context);
        ((HttpRequestHandler)Mockito.verify((Object)requestHandler)).handle((HttpRequest)request, (HttpResponse)response, (HttpContext)context);
        ((HttpServerConnection)Mockito.verify((Object)conn)).sendResponseHeader((HttpResponse)response);
        ((HttpServerConnection)Mockito.verify((Object)conn, (VerificationMode)Mockito.never())).sendResponseEntity((HttpResponse)Matchers.any());
        ((HttpServerConnection)Mockito.verify((Object)conn)).flush();
        ((HttpServerConnection)Mockito.verify((Object)conn, (VerificationMode)Mockito.never())).close();
    }

    @Test
    public void testResponseToHead() throws Exception {
        HttpProcessor httprocessor = (HttpProcessor)Mockito.mock(HttpProcessor.class);
        ConnectionReuseStrategy connReuseStrategy = (ConnectionReuseStrategy)Mockito.mock(ConnectionReuseStrategy.class);
        HttpResponseFactory responseFactory = (HttpResponseFactory)Mockito.mock(HttpResponseFactory.class);
        HttpRequestHandlerMapper handlerResolver = (HttpRequestHandlerMapper)Mockito.mock(HttpRequestHandlerMapper.class);
        HttpRequestHandler requestHandler = (HttpRequestHandler)Mockito.mock(HttpRequestHandler.class);
        HttpService httpservice = new HttpService(httprocessor, connReuseStrategy, responseFactory, handlerResolver);
        HttpCoreContext context = HttpCoreContext.create();
        HttpServerConnection conn = (HttpServerConnection)Mockito.mock(HttpServerConnection.class);
        BasicHttpRequest request = new BasicHttpRequest("HEAD", "/");
        Mockito.when((Object)conn.receiveRequestHeader()).thenReturn((Object)request);
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        Mockito.when((Object)responseFactory.newHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, (HttpContext)context)).thenReturn((Object)response);
        Mockito.when((Object)handlerResolver.lookup((HttpRequest)request)).thenReturn((Object)requestHandler);
        Mockito.when((Object)connReuseStrategy.keepAlive((HttpResponse)response, (HttpContext)context)).thenReturn((Object)Boolean.TRUE);
        httpservice.handleRequest(conn, (HttpContext)context);
        Assert.assertSame((Object)conn, (Object)context.getConnection());
        Assert.assertSame((Object)request, (Object)context.getRequest());
        ((HttpProcessor)Mockito.verify((Object)httprocessor)).process((HttpResponse)response, (HttpContext)context);
        ((HttpRequestHandler)Mockito.verify((Object)requestHandler)).handle((HttpRequest)request, (HttpResponse)response, (HttpContext)context);
        ((HttpServerConnection)Mockito.verify((Object)conn)).sendResponseHeader((HttpResponse)response);
        ((HttpServerConnection)Mockito.verify((Object)conn, (VerificationMode)Mockito.never())).sendResponseEntity((HttpResponse)Matchers.any());
        ((HttpServerConnection)Mockito.verify((Object)conn)).flush();
        ((HttpServerConnection)Mockito.verify((Object)conn, (VerificationMode)Mockito.never())).close();
    }
}

