/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.protocol;

import java.net.InetAddress;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpInetConnection;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolException;
import org.apache.http.ProtocolVersion;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.apache.http.message.BasicHttpRequest;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpCoreContext;
import org.apache.http.protocol.RequestConnControl;
import org.apache.http.protocol.RequestContent;
import org.apache.http.protocol.RequestDate;
import org.apache.http.protocol.RequestExpectContinue;
import org.apache.http.protocol.RequestTargetHost;
import org.apache.http.protocol.RequestUserAgent;
import org.apache.http.protocol.ResponseConnControl;
import org.apache.http.protocol.ResponseContent;
import org.apache.http.protocol.ResponseDate;
import org.apache.http.protocol.ResponseServer;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestStandardInterceptors {
    @Test
    public void testRequestConnControlGenerated() throws Exception {
        BasicHttpContext context = new BasicHttpContext(null);
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        RequestConnControl interceptor = new RequestConnControl();
        interceptor.process((HttpRequest)request, (HttpContext)context);
        Header header = request.getFirstHeader("Connection");
        Assert.assertNotNull((Object)header);
        Assert.assertEquals((Object)"Keep-Alive", (Object)header.getValue());
    }

    @Test
    public void testRequestConnControlConnectMethod() throws Exception {
        BasicHttpContext context = new BasicHttpContext(null);
        BasicHttpRequest request = new BasicHttpRequest("CONNECT", "/");
        RequestConnControl interceptor = new RequestConnControl();
        interceptor.process((HttpRequest)request, (HttpContext)context);
        Header header = request.getFirstHeader("Connection");
        Assert.assertNull((Object)header);
    }

    @Test
    public void testRequestConnControlCustom() throws Exception {
        BasicHttpContext context = new BasicHttpContext(null);
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        BasicHeader myheader = new BasicHeader("Connection", "Close");
        request.addHeader((Header)myheader);
        RequestConnControl interceptor = new RequestConnControl();
        interceptor.process((HttpRequest)request, (HttpContext)context);
        Header header = request.getFirstHeader("Connection");
        Assert.assertNotNull((Object)header);
        Assert.assertEquals((Object)"Close", (Object)header.getValue());
        Assert.assertTrue((header == myheader ? 1 : 0) != 0);
    }

    @Test
    public void testRequestConnControlInvalidInput() throws Exception {
        RequestConnControl interceptor = new RequestConnControl();
        try {
            interceptor.process(null, null);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testRequestContentProtocolException() throws Exception {
        BasicHttpContext context = new BasicHttpContext(null);
        BasicHttpEntityEnclosingRequest request1 = new BasicHttpEntityEnclosingRequest("POST", "/");
        request1.addHeader((Header)new BasicHeader("Transfer-Encoding", "chunked"));
        BasicHttpEntityEnclosingRequest request2 = new BasicHttpEntityEnclosingRequest("POST", "/");
        request2.addHeader((Header)new BasicHeader("Content-Length", "12"));
        RequestContent interceptor = new RequestContent();
        try {
            interceptor.process((HttpRequest)request1, (HttpContext)context);
            Assert.fail((String)"ProtocolException should have been thrown");
        }
        catch (ProtocolException ex) {
            // empty catch block
        }
        try {
            interceptor.process((HttpRequest)request2, (HttpContext)context);
            Assert.fail((String)"ProtocolException should have been thrown");
        }
        catch (ProtocolException ex) {
            // empty catch block
        }
    }

    @Test
    public void testRequestContentNullEntity() throws Exception {
        BasicHttpContext context = new BasicHttpContext(null);
        BasicHttpEntityEnclosingRequest request = new BasicHttpEntityEnclosingRequest("POST", "/");
        RequestContent interceptor = new RequestContent();
        interceptor.process((HttpRequest)request, (HttpContext)context);
        Header header = request.getFirstHeader("Content-Length");
        Assert.assertNotNull((Object)header);
        Assert.assertEquals((Object)"0", (Object)header.getValue());
        Assert.assertNull((Object)request.getFirstHeader("Transfer-Encoding"));
    }

    @Test
    public void testRequestContentEntityContentLengthDelimitedHTTP11() throws Exception {
        BasicHttpContext context = new BasicHttpContext(null);
        BasicHttpEntityEnclosingRequest request = new BasicHttpEntityEnclosingRequest("POST", "/");
        String s = "whatever";
        StringEntity entity = new StringEntity("whatever", "US-ASCII");
        request.setEntity((HttpEntity)entity);
        RequestContent interceptor = new RequestContent();
        interceptor.process((HttpRequest)request, (HttpContext)context);
        Header header = request.getFirstHeader("Content-Length");
        Assert.assertNotNull((Object)header);
        Assert.assertEquals((long)"whatever".length(), (long)Integer.parseInt(header.getValue()));
        Assert.assertNull((Object)request.getFirstHeader("Transfer-Encoding"));
    }

    @Test
    public void testRequestContentEntityChunkedHTTP11() throws Exception {
        BasicHttpContext context = new BasicHttpContext(null);
        BasicHttpEntityEnclosingRequest request = new BasicHttpEntityEnclosingRequest("POST", "/");
        String s = "whatever";
        StringEntity entity = new StringEntity("whatever", "US-ASCII");
        entity.setChunked(true);
        request.setEntity((HttpEntity)entity);
        RequestContent interceptor = new RequestContent();
        interceptor.process((HttpRequest)request, (HttpContext)context);
        Header header = request.getFirstHeader("Transfer-Encoding");
        Assert.assertNotNull((Object)header);
        Assert.assertEquals((Object)"chunked", (Object)header.getValue());
        Assert.assertNull((Object)request.getFirstHeader("Content-Length"));
    }

    @Test
    public void testRequestContentEntityUnknownLengthHTTP11() throws Exception {
        BasicHttpContext context = new BasicHttpContext(null);
        BasicHttpEntityEnclosingRequest request = new BasicHttpEntityEnclosingRequest("POST", "/");
        BasicHttpEntity entity = new BasicHttpEntity();
        entity.setContentLength(-1L);
        entity.setChunked(false);
        request.setEntity((HttpEntity)entity);
        RequestContent interceptor = new RequestContent();
        interceptor.process((HttpRequest)request, (HttpContext)context);
        Header header = request.getFirstHeader("Transfer-Encoding");
        Assert.assertNotNull((Object)header);
        Assert.assertEquals((Object)"chunked", (Object)header.getValue());
        Assert.assertNull((Object)request.getFirstHeader("Content-Length"));
    }

    @Test
    public void testRequestContentEntityChunkedHTTP10() throws Exception {
        BasicHttpContext context = new BasicHttpContext(null);
        BasicHttpEntityEnclosingRequest request = new BasicHttpEntityEnclosingRequest("POST", "/", (ProtocolVersion)HttpVersion.HTTP_1_0);
        String s = "whatever";
        StringEntity entity = new StringEntity("whatever", "US-ASCII");
        entity.setChunked(true);
        request.setEntity((HttpEntity)entity);
        RequestContent interceptor = new RequestContent();
        try {
            interceptor.process((HttpRequest)request, (HttpContext)context);
            Assert.fail((String)"ProtocolException should have been thrown");
        }
        catch (ProtocolException ex) {
            // empty catch block
        }
    }

    @Test
    public void testRequestContentTypeAndEncoding() throws Exception {
        BasicHttpContext context = new BasicHttpContext(null);
        BasicHttpEntityEnclosingRequest request = new BasicHttpEntityEnclosingRequest("POST", "/");
        BasicHttpEntity entity = new BasicHttpEntity();
        entity.setContentType("whatever");
        entity.setContentEncoding("whatever");
        request.setEntity((HttpEntity)entity);
        RequestContent interceptor = new RequestContent();
        interceptor.process((HttpRequest)request, (HttpContext)context);
        Header h1 = request.getFirstHeader("Content-Type");
        Assert.assertNotNull((Object)h1);
        Assert.assertEquals((Object)"whatever", (Object)h1.getValue());
        Header h2 = request.getFirstHeader("Content-Encoding");
        Assert.assertNotNull((Object)h2);
        Assert.assertEquals((Object)"whatever", (Object)h2.getValue());
    }

    @Test
    public void testRequestContentNullTypeAndEncoding() throws Exception {
        BasicHttpContext context = new BasicHttpContext(null);
        BasicHttpEntityEnclosingRequest request = new BasicHttpEntityEnclosingRequest("POST", "/");
        BasicHttpEntity entity = new BasicHttpEntity();
        request.setEntity((HttpEntity)entity);
        RequestContent interceptor = new RequestContent();
        interceptor.process((HttpRequest)request, (HttpContext)context);
        Assert.assertNull((Object)request.getFirstHeader("Content-Type"));
        Assert.assertNull((Object)request.getFirstHeader("Content-Encoding"));
    }

    @Test
    public void testRequestContentEntityUnknownLengthHTTP10() throws Exception {
        BasicHttpContext context = new BasicHttpContext(null);
        BasicHttpEntityEnclosingRequest request = new BasicHttpEntityEnclosingRequest("POST", "/", (ProtocolVersion)HttpVersion.HTTP_1_0);
        BasicHttpEntity entity = new BasicHttpEntity();
        entity.setContentLength(-1L);
        entity.setChunked(false);
        request.setEntity((HttpEntity)entity);
        RequestContent interceptor = new RequestContent();
        try {
            interceptor.process((HttpRequest)request, (HttpContext)context);
            Assert.fail((String)"ProtocolException should have been thrown");
        }
        catch (ProtocolException ex) {
            // empty catch block
        }
    }

    @Test
    public void testRequestContentInvalidInput() throws Exception {
        RequestContent interceptor = new RequestContent();
        try {
            interceptor.process(null, null);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testRequestContentIgnoreNonenclosingRequests() throws Exception {
        BasicHttpContext context = new BasicHttpContext(null);
        BasicHttpRequest request = new BasicHttpRequest("POST", "/");
        RequestContent interceptor = new RequestContent();
        interceptor.process((HttpRequest)request, (HttpContext)context);
        Assert.assertEquals((long)0L, (long)request.getAllHeaders().length);
    }

    @Test
    public void testRequestContentOverwriteHeaders() throws Exception {
        RequestContent interceptor = new RequestContent(true);
        BasicHttpContext context = new BasicHttpContext(null);
        BasicHttpEntityEnclosingRequest request = new BasicHttpEntityEnclosingRequest("POST", "/");
        request.addHeader((Header)new BasicHeader("Content-Length", "10"));
        request.addHeader((Header)new BasicHeader("Transfer-Encoding", "whatever"));
        interceptor.process((HttpRequest)request, (HttpContext)context);
        Assert.assertEquals((Object)"0", (Object)request.getFirstHeader("Content-Length").getValue());
    }

    @Test
    public void testRequestContentAddHeaders() throws Exception {
        RequestContent interceptor = new RequestContent(true);
        BasicHttpContext context = new BasicHttpContext(null);
        BasicHttpEntityEnclosingRequest request = new BasicHttpEntityEnclosingRequest("POST", "/");
        interceptor.process((HttpRequest)request, (HttpContext)context);
        Assert.assertEquals((Object)"0", (Object)request.getFirstHeader("Content-Length").getValue());
        Assert.assertNull((Object)request.getFirstHeader("Transfer-Encoding"));
    }

    @Test
    public void testRequestExpectContinueGenerated() throws Exception {
        HttpCoreContext context = HttpCoreContext.create();
        BasicHttpEntityEnclosingRequest request = new BasicHttpEntityEnclosingRequest("POST", "/");
        String s = "whatever";
        StringEntity entity = new StringEntity("whatever", "US-ASCII");
        request.setEntity((HttpEntity)entity);
        RequestExpectContinue interceptor = new RequestExpectContinue(true);
        interceptor.process((HttpRequest)request, (HttpContext)context);
        Header header = request.getFirstHeader("Expect");
        Assert.assertNotNull((Object)header);
        Assert.assertEquals((Object)"100-continue", (Object)header.getValue());
    }

    @Test
    public void testRequestExpectContinueHTTP10() throws Exception {
        HttpCoreContext context = HttpCoreContext.create();
        BasicHttpEntityEnclosingRequest request = new BasicHttpEntityEnclosingRequest("POST", "/", (ProtocolVersion)HttpVersion.HTTP_1_0);
        String s = "whatever";
        StringEntity entity = new StringEntity("whatever", "US-ASCII");
        request.setEntity((HttpEntity)entity);
        RequestExpectContinue interceptor = new RequestExpectContinue(true);
        interceptor.process((HttpRequest)request, (HttpContext)context);
        Header header = request.getFirstHeader("Expect");
        Assert.assertNull((Object)header);
    }

    @Test
    public void testRequestExpectContinueZeroContent() throws Exception {
        HttpCoreContext context = HttpCoreContext.create();
        BasicHttpEntityEnclosingRequest request = new BasicHttpEntityEnclosingRequest("POST", "/");
        String s = "";
        StringEntity entity = new StringEntity("", "US-ASCII");
        request.setEntity((HttpEntity)entity);
        RequestExpectContinue interceptor = new RequestExpectContinue(true);
        interceptor.process((HttpRequest)request, (HttpContext)context);
        Header header = request.getFirstHeader("Expect");
        Assert.assertNull((Object)header);
    }

    @Test
    public void testRequestExpectContinueInvalidInput() throws Exception {
        RequestExpectContinue interceptor = new RequestExpectContinue(true);
        try {
            interceptor.process(null, null);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testRequestExpectContinueIgnoreNonenclosingRequests() throws Exception {
        BasicHttpContext context = new BasicHttpContext(null);
        BasicHttpRequest request = new BasicHttpRequest("POST", "/");
        RequestExpectContinue interceptor = new RequestExpectContinue(true);
        interceptor.process((HttpRequest)request, (HttpContext)context);
        Assert.assertEquals((long)0L, (long)request.getAllHeaders().length);
    }

    @Test
    public void testRequestTargetHostGenerated() throws Exception {
        BasicHttpContext context = new BasicHttpContext(null);
        HttpHost host = new HttpHost("somehost", 8080, "http");
        context.setAttribute("http.target_host", (Object)host);
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        RequestTargetHost interceptor = new RequestTargetHost();
        interceptor.process((HttpRequest)request, (HttpContext)context);
        Header header = request.getFirstHeader("Host");
        Assert.assertNotNull((Object)header);
        Assert.assertEquals((Object)"somehost:8080", (Object)header.getValue());
    }

    @Test
    public void testRequestTargetHostFallback() throws Exception {
        BasicHttpContext context = new BasicHttpContext(null);
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        InetAddress address = (InetAddress)Mockito.mock(InetAddress.class);
        Mockito.when((Object)address.getHostName()).thenReturn((Object)"somehost");
        HttpInetConnection conn = (HttpInetConnection)Mockito.mock(HttpInetConnection.class);
        Mockito.when((Object)conn.getRemoteAddress()).thenReturn((Object)address);
        Mockito.when((Object)conn.getRemotePort()).thenReturn((Object)1234);
        context.setAttribute("http.target_host", null);
        context.setAttribute("http.connection", (Object)conn);
        RequestTargetHost interceptor = new RequestTargetHost();
        interceptor.process((HttpRequest)request, (HttpContext)context);
        Header header = request.getFirstHeader("Host");
        Assert.assertNotNull((Object)header);
        Assert.assertEquals((Object)"somehost:1234", (Object)header.getValue());
    }

    @Test(expected=ProtocolException.class)
    public void testRequestTargetHostFallbackFailure() throws Exception {
        BasicHttpContext context = new BasicHttpContext(null);
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        HttpInetConnection conn = (HttpInetConnection)Mockito.mock(HttpInetConnection.class);
        Mockito.when((Object)conn.getRemoteAddress()).thenReturn(null);
        Mockito.when((Object)conn.getRemotePort()).thenReturn((Object)1234);
        context.setAttribute("http.target_host", null);
        context.setAttribute("http.connection", (Object)conn);
        RequestTargetHost interceptor = new RequestTargetHost();
        interceptor.process((HttpRequest)request, (HttpContext)context);
    }

    @Test
    public void testRequestTargetHostNotGenerated() throws Exception {
        BasicHttpContext context = new BasicHttpContext(null);
        HttpHost host = new HttpHost("somehost", 8080, "http");
        context.setAttribute("http.target_host", (Object)host);
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        request.addHeader((Header)new BasicHeader("Host", "whatever"));
        RequestTargetHost interceptor = new RequestTargetHost();
        interceptor.process((HttpRequest)request, (HttpContext)context);
        Header header = request.getFirstHeader("Host");
        Assert.assertNotNull((Object)header);
        Assert.assertEquals((Object)"whatever", (Object)header.getValue());
    }

    @Test
    public void testRequestTargetHostMissingHostHTTP10() throws Exception {
        BasicHttpContext context = new BasicHttpContext(null);
        BasicHttpRequest request = new BasicHttpRequest("GET", "/", (ProtocolVersion)HttpVersion.HTTP_1_0);
        RequestTargetHost interceptor = new RequestTargetHost();
        interceptor.process((HttpRequest)request, (HttpContext)context);
        Header header = request.getFirstHeader("Host");
        Assert.assertNull((Object)header);
    }

    @Test
    public void testRequestTargetHostMissingHostHTTP11() throws Exception {
        BasicHttpContext context = new BasicHttpContext(null);
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        RequestTargetHost interceptor = new RequestTargetHost();
        try {
            interceptor.process((HttpRequest)request, (HttpContext)context);
            Assert.fail((String)"ProtocolException should have been thrown");
        }
        catch (ProtocolException ex) {
            // empty catch block
        }
    }

    @Test
    public void testRequestTargetHostInvalidInput() throws Exception {
        RequestTargetHost interceptor = new RequestTargetHost();
        try {
            interceptor.process(null, null);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            interceptor.process((HttpRequest)new BasicHttpRequest("GET", "/"), null);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testRequestTargetHostConnectHttp11() throws Exception {
        BasicHttpContext context = new BasicHttpContext(null);
        HttpHost host = new HttpHost("somehost", 8080, "http");
        context.setAttribute("http.target_host", (Object)host);
        BasicHttpRequest request = new BasicHttpRequest("CONNECT", "/");
        RequestTargetHost interceptor = new RequestTargetHost();
        interceptor.process((HttpRequest)request, (HttpContext)context);
        Header header = request.getFirstHeader("Host");
        Assert.assertNotNull((Object)header);
        Assert.assertEquals((Object)"somehost:8080", (Object)header.getValue());
    }

    @Test
    public void testRequestTargetHostConnectHttp10() throws Exception {
        BasicHttpContext context = new BasicHttpContext(null);
        HttpHost host = new HttpHost("somehost", 8080, "http");
        context.setAttribute("http.target_host", (Object)host);
        BasicHttpRequest request = new BasicHttpRequest("CONNECT", "/", (ProtocolVersion)HttpVersion.HTTP_1_0);
        RequestTargetHost interceptor = new RequestTargetHost();
        interceptor.process((HttpRequest)request, (HttpContext)context);
        Header header = request.getFirstHeader("Host");
        Assert.assertNull((Object)header);
    }

    @Test
    public void testRequestUserAgentGenerated() throws Exception {
        BasicHttpContext context = new BasicHttpContext(null);
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        RequestUserAgent interceptor = new RequestUserAgent("some agent");
        interceptor.process((HttpRequest)request, (HttpContext)context);
        Header header = request.getFirstHeader("User-Agent");
        Assert.assertNotNull((Object)header);
        Assert.assertEquals((Object)"some agent", (Object)header.getValue());
    }

    @Test
    public void testRequestUserAgentNotGenerated() throws Exception {
        BasicHttpContext context = new BasicHttpContext(null);
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        request.addHeader((Header)new BasicHeader("User-Agent", "whatever"));
        RequestUserAgent interceptor = new RequestUserAgent("some agent");
        interceptor.process((HttpRequest)request, (HttpContext)context);
        Header header = request.getFirstHeader("User-Agent");
        Assert.assertNotNull((Object)header);
        Assert.assertEquals((Object)"whatever", (Object)header.getValue());
    }

    @Test
    public void testRequestUserAgentMissingUserAgent() throws Exception {
        BasicHttpContext context = new BasicHttpContext(null);
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        RequestUserAgent interceptor = new RequestUserAgent();
        interceptor.process((HttpRequest)request, (HttpContext)context);
        Header header = request.getFirstHeader("User-Agent");
        Assert.assertNull((Object)header);
    }

    @Test
    public void testRequestUserAgentInvalidInput() throws Exception {
        RequestUserAgent interceptor = new RequestUserAgent();
        try {
            interceptor.process(null, null);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testResponseConnControlNoEntity() throws Exception {
        BasicHttpContext context = new BasicHttpContext(null);
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        ResponseConnControl interceptor = new ResponseConnControl();
        interceptor.process((HttpResponse)response, (HttpContext)context);
        Header header = response.getFirstHeader("Connection");
        Assert.assertNull((Object)header);
    }

    @Test
    public void testResponseConnControlEntityContentLength() throws Exception {
        BasicHttpContext context = new BasicHttpContext(null);
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        StringEntity entity = new StringEntity("whatever");
        response.setEntity((HttpEntity)entity);
        ResponseConnControl interceptor = new ResponseConnControl();
        interceptor.process((HttpResponse)response, (HttpContext)context);
        Header header = response.getFirstHeader("Connection");
        Assert.assertNull((Object)header);
    }

    @Test
    public void testResponseConnControlEntityUnknownContentLength() throws Exception {
        BasicHttpContext context = new BasicHttpContext(null);
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        request.addHeader((Header)new BasicHeader("Connection", "Keep-Alive"));
        context.setAttribute("http.request", (Object)request);
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        BasicHttpEntity entity = new BasicHttpEntity();
        response.setEntity((HttpEntity)entity);
        ResponseConnControl interceptor = new ResponseConnControl();
        interceptor.process((HttpResponse)response, (HttpContext)context);
        Header header = response.getFirstHeader("Connection");
        Assert.assertNotNull((Object)header);
        Assert.assertEquals((Object)"Close", (Object)header.getValue());
    }

    @Test
    public void testResponseConnControlEntityChunked() throws Exception {
        BasicHttpContext context = new BasicHttpContext(null);
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        BasicHttpEntity entity = new BasicHttpEntity();
        entity.setChunked(true);
        response.setEntity((HttpEntity)entity);
        ResponseConnControl interceptor = new ResponseConnControl();
        interceptor.process((HttpResponse)response, (HttpContext)context);
        Header header = response.getFirstHeader("Connection");
        Assert.assertNull((Object)header);
    }

    @Test
    public void testResponseConnControlEntityUnknownContentLengthHTTP10() throws Exception {
        BasicHttpContext context = new BasicHttpContext(null);
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        request.addHeader((Header)new BasicHeader("Connection", "Keep-Alive"));
        context.setAttribute("http.request", (Object)request);
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_0, 200, "OK");
        BasicHttpEntity entity = new BasicHttpEntity();
        response.setEntity((HttpEntity)entity);
        ResponseConnControl interceptor = new ResponseConnControl();
        interceptor.process((HttpResponse)response, (HttpContext)context);
        Header header = response.getFirstHeader("Connection");
        Assert.assertNotNull((Object)header);
        Assert.assertEquals((Object)"Close", (Object)header.getValue());
    }

    @Test
    public void testResponseConnControlClientRequest() throws Exception {
        BasicHttpContext context = new BasicHttpContext(null);
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        request.addHeader((Header)new BasicHeader("Connection", "Keep-Alive"));
        context.setAttribute("http.request", (Object)request);
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        StringEntity entity = new StringEntity("whatever");
        response.setEntity((HttpEntity)entity);
        ResponseConnControl interceptor = new ResponseConnControl();
        interceptor.process((HttpResponse)response, (HttpContext)context);
        Header header = response.getFirstHeader("Connection");
        Assert.assertNotNull((Object)header);
        Assert.assertEquals((Object)"Keep-Alive", (Object)header.getValue());
    }

    @Test
    public void testResponseConnControlClientRequest2() throws Exception {
        BasicHttpContext context = new BasicHttpContext(null);
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        context.setAttribute("http.request", (Object)request);
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        StringEntity entity = new StringEntity("whatever");
        response.setEntity((HttpEntity)entity);
        ResponseConnControl interceptor = new ResponseConnControl();
        interceptor.process((HttpResponse)response, (HttpContext)context);
        Header header = response.getFirstHeader("Connection");
        Assert.assertNull((Object)header);
    }

    @Test
    public void testResponseConnControl10Client11Response() throws Exception {
        BasicHttpContext context = new BasicHttpContext(null);
        BasicHttpRequest request = new BasicHttpRequest("GET", "/", (ProtocolVersion)HttpVersion.HTTP_1_0);
        context.setAttribute("http.request", (Object)request);
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        StringEntity entity = new StringEntity("whatever");
        response.setEntity((HttpEntity)entity);
        ResponseConnControl interceptor = new ResponseConnControl();
        interceptor.process((HttpResponse)response, (HttpContext)context);
        Header header = response.getFirstHeader("Connection");
        Assert.assertNotNull((Object)header);
        Assert.assertEquals((Object)"Close", (Object)header.getValue());
    }

    @Test
    public void testResponseConnControlStatusCode() throws Exception {
        int[] statusCodes;
        BasicHttpContext context = new BasicHttpContext(null);
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        request.addHeader((Header)new BasicHeader("Connection", "Keep-Alive"));
        context.setAttribute("http.request", (Object)request);
        ResponseConnControl interceptor = new ResponseConnControl();
        for (int statusCode : statusCodes = new int[]{400, 408, 411, 413, 414, 503, 501}) {
            BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, statusCode, "Unreasonable");
            interceptor.process((HttpResponse)response, (HttpContext)context);
            Header header = response.getFirstHeader("Connection");
            Assert.assertNotNull((Object)header);
            Assert.assertEquals((Object)"Close", (Object)header.getValue());
        }
    }

    @Test
    public void testResponseConnControlExplicitClose() throws Exception {
        BasicHttpContext context = new BasicHttpContext(null);
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        request.addHeader((Header)new BasicHeader("Connection", "Keep-Alive"));
        context.setAttribute("http.request", (Object)request);
        ResponseConnControl interceptor = new ResponseConnControl();
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        response.setHeader("Connection", "Close");
        interceptor.process((HttpResponse)response, (HttpContext)context);
        Header header = response.getFirstHeader("Connection");
        Assert.assertNotNull((Object)header);
        Assert.assertEquals((Object)"Close", (Object)header.getValue());
    }

    @Test
    public void testResponseConnControlHostInvalidInput() throws Exception {
        ResponseConnControl interceptor = new ResponseConnControl();
        try {
            interceptor.process(null, null);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
            interceptor.process((HttpResponse)response, null);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testResponseContentNoEntity() throws Exception {
        BasicHttpContext context = new BasicHttpContext(null);
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        ResponseContent interceptor = new ResponseContent();
        interceptor.process((HttpResponse)response, (HttpContext)context);
        Header header = response.getFirstHeader("Content-Length");
        Assert.assertNotNull((Object)header);
        Assert.assertEquals((Object)"0", (Object)header.getValue());
    }

    @Test
    public void testResponseContentStatusNoContent() throws Exception {
        BasicHttpContext context = new BasicHttpContext(null);
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        response.setStatusCode(204);
        ResponseContent interceptor = new ResponseContent();
        interceptor.process((HttpResponse)response, (HttpContext)context);
        Header header = response.getFirstHeader("Content-Length");
        Assert.assertNull((Object)header);
    }

    @Test
    public void testResponseContentStatusResetContent() throws Exception {
        BasicHttpContext context = new BasicHttpContext(null);
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        response.setStatusCode(205);
        ResponseContent interceptor = new ResponseContent();
        interceptor.process((HttpResponse)response, (HttpContext)context);
        Header header = response.getFirstHeader("Content-Length");
        Assert.assertNull((Object)header);
    }

    @Test
    public void testResponseContentStatusNotModified() throws Exception {
        BasicHttpContext context = new BasicHttpContext(null);
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        response.setStatusCode(304);
        ResponseContent interceptor = new ResponseContent();
        interceptor.process((HttpResponse)response, (HttpContext)context);
        Header header = response.getFirstHeader("Content-Length");
        Assert.assertNull((Object)header);
    }

    @Test
    public void testResponseContentEntityChunked() throws Exception {
        BasicHttpContext context = new BasicHttpContext(null);
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        BasicHttpEntity entity = new BasicHttpEntity();
        entity.setChunked(true);
        response.setEntity((HttpEntity)entity);
        ResponseContent interceptor = new ResponseContent();
        interceptor.process((HttpResponse)response, (HttpContext)context);
        Header h1 = response.getFirstHeader("Transfer-Encoding");
        Assert.assertNotNull((Object)h1);
        Assert.assertEquals((Object)"chunked", (Object)h1.getValue());
        Header h2 = response.getFirstHeader("Content-Length");
        Assert.assertNull((Object)h2);
    }

    @Test
    public void testResponseContentEntityContentLenghtDelimited() throws Exception {
        BasicHttpContext context = new BasicHttpContext(null);
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        BasicHttpEntity entity = new BasicHttpEntity();
        entity.setContentLength(10L);
        response.setEntity((HttpEntity)entity);
        ResponseContent interceptor = new ResponseContent();
        interceptor.process((HttpResponse)response, (HttpContext)context);
        Header h1 = response.getFirstHeader("Content-Length");
        Assert.assertNotNull((Object)h1);
        Assert.assertEquals((Object)"10", (Object)h1.getValue());
        Header h2 = response.getFirstHeader("Transfer-Encoding");
        Assert.assertNull((Object)h2);
    }

    @Test
    public void testResponseContentEntityUnknownContentLength() throws Exception {
        BasicHttpContext context = new BasicHttpContext(null);
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        BasicHttpEntity entity = new BasicHttpEntity();
        response.setEntity((HttpEntity)entity);
        ResponseContent interceptor = new ResponseContent();
        interceptor.process((HttpResponse)response, (HttpContext)context);
        Header h1 = response.getFirstHeader("Transfer-Encoding");
        Assert.assertNull((Object)h1);
        Header h2 = response.getFirstHeader("Content-Length");
        Assert.assertNull((Object)h2);
    }

    @Test
    public void testResponseContentEntityChunkedHTTP10() throws Exception {
        BasicHttpContext context = new BasicHttpContext(null);
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_0, 200, "OK");
        BasicHttpEntity entity = new BasicHttpEntity();
        entity.setChunked(true);
        response.setEntity((HttpEntity)entity);
        ResponseContent interceptor = new ResponseContent();
        interceptor.process((HttpResponse)response, (HttpContext)context);
        Header h1 = response.getFirstHeader("Transfer-Encoding");
        Assert.assertNull((Object)h1);
        Header h2 = response.getFirstHeader("Content-Length");
        Assert.assertNull((Object)h2);
    }

    @Test
    public void testResponseContentEntityNoContentTypeAndEncoding() throws Exception {
        BasicHttpContext context = new BasicHttpContext(null);
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        BasicHttpEntity entity = new BasicHttpEntity();
        response.setEntity((HttpEntity)entity);
        ResponseContent interceptor = new ResponseContent();
        interceptor.process((HttpResponse)response, (HttpContext)context);
        Header h1 = response.getFirstHeader("Content-Type");
        Assert.assertNull((Object)h1);
        Header h2 = response.getFirstHeader("Content-Encoding");
        Assert.assertNull((Object)h2);
    }

    @Test
    public void testResponseContentEntityContentTypeAndEncoding() throws Exception {
        BasicHttpContext context = new BasicHttpContext(null);
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        BasicHttpEntity entity = new BasicHttpEntity();
        entity.setContentEncoding("whatever");
        entity.setContentType("whatever");
        response.setEntity((HttpEntity)entity);
        ResponseContent interceptor = new ResponseContent();
        interceptor.process((HttpResponse)response, (HttpContext)context);
        Header h1 = response.getFirstHeader("Content-Type");
        Assert.assertNotNull((Object)h1);
        Assert.assertEquals((Object)"whatever", (Object)h1.getValue());
        Header h2 = response.getFirstHeader("Content-Encoding");
        Assert.assertNotNull((Object)h2);
        Assert.assertEquals((Object)"whatever", (Object)h2.getValue());
    }

    @Test
    public void testResponseContentInvalidInput() throws Exception {
        ResponseContent interceptor = new ResponseContent();
        try {
            interceptor.process(null, null);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testResponseContentInvalidResponseState() throws Exception {
        BasicHttpResponse response;
        ResponseContent interceptor = new ResponseContent();
        BasicHttpContext context = new BasicHttpContext(null);
        try {
            response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
            response.addHeader((Header)new BasicHeader("Content-Length", "10"));
            interceptor.process((HttpResponse)response, (HttpContext)context);
            Assert.fail((String)"ProtocolException should have been thrown");
        }
        catch (ProtocolException ex) {
            // empty catch block
        }
        try {
            response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
            response.addHeader((Header)new BasicHeader("Transfer-Encoding", "stuff"));
            interceptor.process((HttpResponse)response, (HttpContext)context);
            Assert.fail((String)"ProtocolException should have been thrown");
        }
        catch (ProtocolException protocolException) {
            // empty catch block
        }
    }

    @Test
    public void testResponseContentOverwriteHeaders() throws Exception {
        ResponseContent interceptor = new ResponseContent(true);
        BasicHttpContext context = new BasicHttpContext(null);
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        response.addHeader((Header)new BasicHeader("Content-Length", "10"));
        response.addHeader((Header)new BasicHeader("Transfer-Encoding", "whatever"));
        interceptor.process((HttpResponse)response, (HttpContext)context);
        Assert.assertEquals((Object)"0", (Object)response.getFirstHeader("Content-Length").getValue());
    }

    @Test
    public void testResponseContentAddHeaders() throws Exception {
        ResponseContent interceptor = new ResponseContent(true);
        BasicHttpContext context = new BasicHttpContext(null);
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        interceptor.process((HttpResponse)response, (HttpContext)context);
        Assert.assertEquals((Object)"0", (Object)response.getFirstHeader("Content-Length").getValue());
        Assert.assertNull((Object)response.getFirstHeader("Transfer-Encoding"));
    }

    @Test
    public void testResponseDateGenerated() throws Exception {
        BasicHttpContext context = new BasicHttpContext(null);
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        ResponseDate interceptor = new ResponseDate();
        interceptor.process((HttpResponse)response, (HttpContext)context);
        Header h1 = response.getFirstHeader("Date");
        Assert.assertNotNull((Object)h1);
        interceptor.process((HttpResponse)response, (HttpContext)context);
        Header h2 = response.getFirstHeader("Date");
        Assert.assertNotNull((Object)h2);
    }

    @Test
    public void testResponseDateNotGenerated() throws Exception {
        BasicHttpContext context = new BasicHttpContext(null);
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        response.setStatusCode(199);
        ResponseDate interceptor = new ResponseDate();
        interceptor.process((HttpResponse)response, (HttpContext)context);
        Header h1 = response.getFirstHeader("Date");
        Assert.assertNull((Object)h1);
    }

    @Test
    public void testResponseDateInvalidInput() throws Exception {
        ResponseDate interceptor = new ResponseDate();
        try {
            interceptor.process(null, null);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testRequestDateGenerated() throws Exception {
        BasicHttpContext context = new BasicHttpContext(null);
        BasicHttpEntityEnclosingRequest request = new BasicHttpEntityEnclosingRequest("POST", "/");
        RequestDate interceptor = new RequestDate();
        interceptor.process((HttpRequest)request, (HttpContext)context);
        Header h1 = request.getFirstHeader("Date");
        Assert.assertNotNull((Object)h1);
        interceptor.process((HttpRequest)request, (HttpContext)context);
        Header h2 = request.getFirstHeader("Date");
        Assert.assertNotNull((Object)h2);
    }

    @Test
    public void testRequestDateNotGenerated() throws Exception {
        BasicHttpContext context = new BasicHttpContext(null);
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        RequestDate interceptor = new RequestDate();
        interceptor.process((HttpRequest)request, (HttpContext)context);
        Header h1 = request.getFirstHeader("Date");
        Assert.assertNull((Object)h1);
    }

    @Test
    public void testRequestDateInvalidInput() throws Exception {
        RequestDate interceptor = new RequestDate();
        try {
            interceptor.process(null, null);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testResponseServerGenerated() throws Exception {
        BasicHttpContext context = new BasicHttpContext(null);
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        ResponseServer interceptor = new ResponseServer("some server");
        interceptor.process((HttpResponse)response, (HttpContext)context);
        Header h1 = response.getFirstHeader("Server");
        Assert.assertNotNull((Object)h1);
        Assert.assertEquals((Object)"some server", (Object)h1.getValue());
    }

    @Test
    public void testResponseServerNotGenerated() throws Exception {
        BasicHttpContext context = new BasicHttpContext(null);
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        response.addHeader((Header)new BasicHeader("Server", "whatever"));
        ResponseServer interceptor = new ResponseServer("some server");
        interceptor.process((HttpResponse)response, (HttpContext)context);
        Header h1 = response.getFirstHeader("Server");
        Assert.assertNotNull((Object)h1);
        Assert.assertEquals((Object)"whatever", (Object)h1.getValue());
    }

    @Test
    public void testResponseServerMissing() throws Exception {
        BasicHttpContext context = new BasicHttpContext(null);
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        ResponseServer interceptor = new ResponseServer();
        interceptor.process((HttpResponse)response, (HttpContext)context);
        Header h1 = response.getFirstHeader("Server");
        Assert.assertNull((Object)h1);
    }

    @Test
    public void testResponseServerInvalidInput() throws Exception {
        ResponseServer interceptor = new ResponseServer();
        try {
            interceptor.process(null, null);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

